/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.deploy.k8s;

import io.fabric8.kubernetes.api.model.ConfigMapVolumeSource;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.hyperfoil.api.Version;
import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.Deployer;
import io.hyperfoil.deploy.k8s.K8sAgent;
import io.hyperfoil.internal.Controller;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class K8sDeployer
implements Deployer {
    private static final Logger log = LogManager.getLogger(K8sDeployer.class);
    private static final String API_SERVER = Properties.get((String)"io.hyperfoil.deployer.k8s.apiserver", (String)"https://kubernetes.default.svc.cluster.local/");
    private static final String DEFAULT_IMAGE = Properties.get((String)"io.hyperfoil.deployer.k8s.defaultimage", (String)("quay.io/hyperfoil/hyperfoil:" + Version.VERSION));
    private static final String CONTROLLER_POD_NAME = System.getenv("HOSTNAME");
    private static final String APP;
    private static final String NAMESPACE;
    private static final String[] K8S_RECOMMENDED_LABELS;
    protected static final String POD_LABEL_PROPERTY_PREFIX = "pod.label.";
    private KubernetesClient client;

    private static String getPropertyOrLoad(String property, String file) {
        String value = Properties.get((String)property, null);
        if (value != null) {
            return value;
        }
        String path = "/var/run/secrets/kubernetes.io/serviceaccount/" + file;
        try {
            return Files.readString(Paths.get(path, new String[0]));
        }
        catch (IOException e) {
            log.debug("Cannot load {} - not running as pod?", (Object)path, (Object)e);
            return "<cannot load>";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureClient() {
        K8sDeployer k8sDeployer = this;
        synchronized (k8sDeployer) {
            if (this.client == null) {
                Config config = ((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(API_SERVER)).withTrustCerts(true)).build();
                this.client = new KubernetesClientBuilder().withConfig(config).build();
            }
        }
    }

    public DeployedAgent start(Agent agent, String runId, Benchmark benchmark, Consumer<Throwable> exceptionHandler) {
        boolean stop;
        String logProperty;
        String storageRequest;
        String memoryRequest;
        this.ensureClient();
        PodSpecBuilder spec = (PodSpecBuilder)new PodSpecBuilder().withRestartPolicy("Never");
        String serviceAccount = agent.properties.getOrDefault("pod-serviceaccount", Properties.get((String)"io.hyperfoil.deployer.k8s.pod.service-account", null));
        if (serviceAccount != null) {
            spec.withServiceAccount(serviceAccount);
        }
        ArrayList<Object> command = new ArrayList<Object>();
        command.add("java");
        int threads = agent.threads() < 0 ? benchmark.defaultThreads() : agent.threads();
        ResourceRequirements resourceRequirements = new ResourceRequirements();
        LinkedHashMap<String, Quantity> podResourceRequests = new LinkedHashMap<String, Quantity>();
        String cpuRequest = agent.properties.getOrDefault("pod-cpu", Properties.get((String)"io.hyperfoil.deployer.k8s.pod.cpu", null));
        if (cpuRequest != null) {
            podResourceRequests.put("cpu", new Quantity(cpuRequest));
        }
        if ((memoryRequest = agent.properties.getOrDefault("pod-memory", Properties.get((String)"io.hyperfoil.deployer.k8s.pod.memory", null))) != null) {
            podResourceRequests.put("memory", new Quantity(memoryRequest));
        }
        if ((storageRequest = agent.properties.getOrDefault("pod-ephemeral-storage", Properties.get((String)"io.hyperfoil.deployer.k8s.pod.ephemeralstorage", null))) != null) {
            podResourceRequests.put("ephemeral-storage", new Quantity(storageRequest));
        }
        resourceRequirements.setRequests(podResourceRequests);
        if (Boolean.parseBoolean(agent.properties.getOrDefault("pod-limits", Properties.get((String)"io.hyperfoil.deployer.k8s.pod.limits", (String)"false")))) {
            resourceRequirements.setLimits(podResourceRequests);
        }
        ContainerBuilder containerBuilder = (ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withImage(agent.properties.getOrDefault("image", DEFAULT_IMAGE))).withImagePullPolicy(agent.properties.getOrDefault("imagePullPolicy", "Always"))).withName("hyperfoil-agent")).withPorts(new ContainerPort[]{new ContainerPort(Integer.valueOf(7800), null, null, "jgroups", "TCP")})).withNewResourcesLike(resourceRequirements).endResources();
        String node = (String)agent.properties.get("node");
        if (node != null) {
            HashMap<String, String> nodeSelector = new HashMap<String, String>();
            for (String label : node.split(",", 0)) {
                if ((label = label.trim()).isEmpty()) continue;
                if (label.contains("=")) {
                    String[] parts = node.split("=", 2);
                    nodeSelector.put(parts[0].trim(), parts[1].trim());
                    continue;
                }
                nodeSelector.put("kubernetes.io/hostname", label);
            }
            spec = (PodSpecBuilder)spec.withNodeSelector(nodeSelector);
            spec = (PodSpecBuilder)spec.withTolerations(new Toleration[]{new Toleration("", "", "Exists", null, null)});
        }
        if ((logProperty = (String)agent.properties.get("log")) != null) {
            String configMap = logProperty;
            String file = "log4j2.xml";
            if (logProperty.contains("/")) {
                int index = logProperty.indexOf("/");
                configMap = logProperty.substring(0, index);
                file = logProperty.substring(index + 1);
            }
            command.add("-Dlog4j.configurationFile=file:///etc/log4j2/" + file);
            containerBuilder.withVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName("log")).withMountPath("/etc/log4j2")).withReadOnly(Boolean.valueOf(true))).build()});
            spec.withVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName("log")).withConfigMap(new ConfigMapVolumeSource(null, null, configMap, Boolean.valueOf(false)))).build()});
        }
        command.add("-Dvertx.logger-delegate-factory-class-name=io.vertx.core.logging.Log4j2LogDelegateFactory");
        command.add("-Dio.hyperfoil.agent.name=" + agent.name);
        command.add("-Dio.hyperfoil.runid=" + runId);
        command.add("-Dio.hyperfoil.controller.cluster.ip=" + Properties.get((String)"io.hyperfoil.controller.cluster.ip", null));
        command.add("-Dio.hyperfoil.controller.cluster.port=" + Properties.get((String)"io.hyperfoil.controller.cluster.port", null));
        if (agent.properties.containsKey("extras")) {
            command.addAll(Arrays.asList(((String)agent.properties.get("extras")).split(" ", 0)));
        }
        command.add("-cp");
        command.add("/deployment/lib/*:/deployment/extensions/*");
        command.add("io.hyperfoil.Hyperfoil$Agent");
        boolean bl = stop = !"false".equalsIgnoreCase(agent.properties.getOrDefault("stop", "true"));
        if (!stop) {
            command.add("&&");
            command.add("sleep");
            command.add("86400");
        }
        containerBuilder = (ContainerBuilder)containerBuilder.withCommand(command);
        spec = (PodSpecBuilder)spec.withContainers(Collections.singletonList(containerBuilder.build()));
        String podName = "agent-" + runId.toLowerCase() + "-" + agent.name.toLowerCase();
        boolean fetchLogs = !"false".equalsIgnoreCase(agent.properties.getOrDefault("fetchLogs", "true"));
        Path outputPath = null;
        FileOutputStream output = null;
        if (fetchLogs) {
            outputPath = Controller.RUN_DIR.resolve(runId).resolve(podName + ".log");
            try {
                output = new FileOutputStream(outputPath.toFile());
            }
            catch (FileNotFoundException e) {
                log.error("Cannot write to {}", (Object)outputPath, (Object)e);
            }
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        boolean usingRecommendedLabels = false;
        for (String key : K8S_RECOMMENDED_LABELS) {
            int slashIndex = key.indexOf(47);
            String value = Properties.get((String)("io.hyperfoil.deployer.k8s.label." + key.substring(slashIndex + 1)), null);
            if (value == null) continue;
            usingRecommendedLabels = true;
            labels.put(key, value);
        }
        if (usingRecommendedLabels) {
            labels.putIfAbsent("app.kubernetes.io/name", "hyperfoil");
            labels.putIfAbsent("app.kubernetes.io/version", Version.VERSION);
            labels.putIfAbsent("app.kubernetes.io/component", "agent");
            labels.putIfAbsent("app.kubernetes.io/managed-by", "hyperfoil");
            labels.putIfAbsent("app.kubernetes.io/created-by", "hyperfoil");
        } else {
            labels.put("role", "agent");
            if (APP != null) {
                labels.put("app", APP);
            }
        }
        agent.properties.forEach((k, v) -> {
            if (k.startsWith(POD_LABEL_PROPERTY_PREFIX)) {
                labels.put(k.substring(POD_LABEL_PROPERTY_PREFIX.length()), (String)v);
            }
        });
        Pod toCreate = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodFluent.MetadataNested)new PodBuilder().withNewMetadata().withNamespace(NAMESPACE)).withName(podName)).withLabels(labels)).endMetadata()).withSpec(spec.build())).build();
        Pod created = (Pod)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(NAMESPACE)).resource((Object)toCreate)).create();
        K8sAgent k8sAgent = new K8sAgent(agent, this.client, created, stop, outputPath, output);
        if (output != null) {
            ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(NAMESPACE)).withName(podName)).watch((Watcher)new AgentWatcher(podName, k8sAgent));
        }
        return k8sAgent;
    }

    public boolean hasControllerLog() {
        return true;
    }

    public void downloadControllerLog(long offset, long maxLength, String destinationFile, Handler<AsyncResult<Void>> handler) {
        this.downloadRunningLog(CONTROLLER_POD_NAME, offset, maxLength, destinationFile, handler);
    }

    public void downloadAgentLog(DeployedAgent deployedAgent, long offset, long maxLength, String destinationFile, Handler<AsyncResult<Void>> handler) {
        K8sAgent agent = (K8sAgent)deployedAgent;
        this.ensureClient();
        if (agent.outputPath != null) {
            try (FileInputStream stream = new FileInputStream(agent.outputPath.toFile());){
                this.skipBytes(offset, stream);
                Files.copy(new TruncatingInputStream(stream, maxLength), Paths.get(destinationFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                handler.handle((Object)Future.succeededFuture());
            }
            catch (IOException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
            }
        } else {
            this.downloadRunningLog(agent.pod.getMetadata().getName(), offset, maxLength, destinationFile, handler);
        }
    }

    private void skipBytes(long offset, InputStream stream) throws IOException {
        long skipped;
        while (offset > 0L && (skipped = stream.skip(offset)) != 0L) {
            offset -= skipped;
        }
    }

    private void downloadRunningLog(String podName, long offset, long maxLength, String destinationFile, Handler<AsyncResult<Void>> handler) {
        this.ensureClient();
        try {
            PodResource podResource = (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(NAMESPACE)).withName(podName);
            try (InputStream stream = this.getLog(podResource);){
                this.skipBytes(offset, stream);
                Files.copy(new TruncatingInputStream(stream, maxLength), Paths.get(destinationFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            handler.handle((Object)Future.succeededFuture());
        }
        catch (IOException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private InputStream getLog(PodResource podResource) throws IOException {
        return podResource.getLogInputStream();
    }

    public void close() {
        this.client.close();
    }

    static {
        K8S_RECOMMENDED_LABELS = new String[]{"app.kubernetes.io/name", "app.kubernetes.io/instance", "app.kubernetes.io/version", "app.kubernetes.io/component", "app.kubernetes.io/part-of", "app.kubernetes.io/managed-by", "app.kubernetes.io/created-by"};
        APP = Properties.get((String)"io.hyperfoil.deployer.k8s.app", null);
        NAMESPACE = K8sDeployer.getPropertyOrLoad("io.hyperfoil.deployer.k8s.namespace", "namespace");
    }

    private class AgentWatcher
    implements Watcher<Pod> {
        private final String podName;
        private final K8sAgent agent;

        AgentWatcher(String podName, K8sAgent agent) {
            this.podName = podName;
            this.agent = agent;
        }

        public void eventReceived(Watcher.Action action, Pod resource) {
            if (resource.getStatus().getConditions().stream().filter(c -> "Ready".equalsIgnoreCase(c.getType())).anyMatch(c -> "True".equalsIgnoreCase(c.getStatus()))) {
                if (this.agent.logWatch != null) {
                    return;
                }
                this.agent.logWatch = ((PodResource)((NonNamespaceOperation)K8sDeployer.this.client.pods().inNamespace(NAMESPACE)).withName(this.podName)).watchLog((OutputStream)this.agent.output);
            }
        }

        public void onClose(WatcherException cause) {
        }
    }

    private static class TruncatingInputStream
    extends InputStream {
        private final InputStream stream;
        private long remain;

        public TruncatingInputStream(InputStream stream, long maxLength) {
            this.stream = stream;
            this.remain = maxLength;
        }

        @Override
        public int read() throws IOException {
            if (this.remain <= 0L) {
                return -1;
            }
            int b = this.stream.read();
            if (b >= 0) {
                --this.remain;
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remain <= 0L) {
                return -1;
            }
            int n = this.stream.read(b, off, Math.toIntExact(Math.min((long)len, this.remain)));
            if (n > 0) {
                this.remain -= (long)n;
            }
            return n;
        }
    }

    public static class Factory
    implements Deployer.Factory {
        public String name() {
            return "k8s";
        }

        public K8sDeployer create() {
            return new K8sDeployer();
        }
    }
}

