/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.deployment.DeployedAgent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class K8sAgent
implements DeployedAgent {
    private static final Logger log = LogManager.getLogger(K8sAgent.class);
    final Agent def;
    final KubernetesClient client;
    final Pod pod;
    final boolean stop;
    final Path outputPath;
    final FileOutputStream output;
    LogWatch logWatch;

    K8sAgent(Agent def, KubernetesClient client, Pod pod, boolean stop, Path outputPath, FileOutputStream output) {
        this.def = def;
        this.client = client;
        this.pod = pod;
        this.stop = stop;
        this.outputPath = outputPath;
        this.output = output;
    }

    public void stop() {
        if (this.stop) {
            ((NonNamespaceOperation)this.client.pods().inNamespace(this.pod.getMetadata().getNamespace())).delete((Object)this.pod);
        }
        if (this.logWatch != null) {
            this.logWatch.close();
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException e) {
                log.error("Failed to close log output.", (Throwable)e);
            }
        }
    }
}

