/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.deploy.ssh;

import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.DeploymentException;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.channel.StreamingChannel;
import org.apache.sshd.common.io.IoOutputStream;
import org.apache.sshd.common.io.IoReadFuture;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.output.NullOutputStream;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;

public class SshDeployedAgent
implements DeployedAgent {
    private static final Logger log = LogManager.getLogger(SshDeployedAgent.class);
    private static final String PROMPT = "<_#%@_hyperfoil_@%#_>";
    private static final String DEBUG_ADDRESS = Properties.get((String)"io.hyperfoil.agent.debug.port", null);
    private static final String DEBUG_SUSPEND = Properties.get((String)"io.hyperfoil.agent.debug.suspend", (String)"n");
    private static final String AGENTLIB = "/agentlib";
    final String name;
    final String runId;
    final String username;
    final String hostname;
    final String sshKey;
    final int port;
    final String dir;
    final String extras;
    final String cpu;
    private ClientSession session;
    private ChannelShell shellChannel;
    private Consumer<Throwable> exceptionHandler;
    private ScpClient scpClient;
    private PrintStream commandStream;

    public SshDeployedAgent(String name, String runId, String username, String hostname, String sshKey, int port, String dir, String extras, String cpu) {
        this.name = name;
        this.runId = runId;
        this.username = username;
        this.hostname = hostname;
        this.sshKey = sshKey;
        this.port = port;
        this.dir = dir;
        this.extras = extras;
        this.cpu = cpu;
    }

    public void stop() {
        log.info("Stopping agent {}", (Object)this.name);
        if (this.commandStream != null) {
            this.commandStream.close();
        }
        try {
            if (this.shellChannel != null) {
                this.shellChannel.close();
            }
        }
        catch (IOException e) {
            log.error("Failed closing shell", (Throwable)e);
        }
        try {
            this.session.close();
        }
        catch (IOException e) {
            log.error("Failed closing SSH session", (Throwable)e);
        }
    }

    public void deploy(ClientSession session, Consumer<Throwable> exceptionHandler) {
        String log4jConfigurationFile;
        this.session = session;
        this.exceptionHandler = exceptionHandler;
        this.scpClient = ScpClientCreator.instance().createScpClient(session);
        try {
            this.shellChannel = session.createShellChannel();
            this.shellChannel.setStreaming(StreamingChannel.Streaming.Async);
            this.shellChannel.setErr((OutputStream)new NullOutputStream());
            OpenFuture open = this.shellChannel.open();
            if (!open.await(10000L)) {
                exceptionHandler.accept(new DeploymentException("Shell not opened within timeout", null));
            }
            if (!open.isOpened()) {
                exceptionHandler.accept(new DeploymentException("Could not open shell", open.getException()));
            }
        }
        catch (IOException e) {
            exceptionHandler.accept(new DeploymentException("Failed to open shell", (Throwable)e));
        }
        final IoOutputStream inStream = this.shellChannel.getAsyncIn();
        this.commandStream = new PrintStream(new OutputStream(this){
            final ByteArrayBuffer buffer = new ByteArrayBuffer();

            @Override
            public void write(byte[] b) throws IOException {
                this.buffer.clear(false);
                this.buffer.putRawBytes(b, 0, b.length);
                if (!inStream.writeBuffer((Buffer)this.buffer).await()) {
                    throw new IOException("Failed waiting for the write");
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.buffer.clear(false);
                this.buffer.putRawBytes(b, off, len);
                if (!inStream.writeBuffer((Buffer)this.buffer).await()) {
                    throw new IOException("Failed waiting for the write");
                }
            }

            @Override
            public void write(int b) throws IOException {
                this.buffer.clear(false);
                this.buffer.putByte((byte)b);
                if (!inStream.writeBuffer((Buffer)this.buffer).await()) {
                    throw new IOException("Failed waiting for the write");
                }
            }

            @Override
            public void close() throws IOException {
                inStream.close();
            }
        });
        this.runCommand("unset PROMPT_COMMAND; export PS1='<_#%@_hyperfoil_@%#_>'", true);
        this.runCommand("mkdir -p " + this.dir + AGENTLIB, true);
        Map<String, String> remoteMd5 = this.getRemoteMd5();
        Map<String, String> localMd5 = this.getLocalMd5();
        if (localMd5 == null) {
            return;
        }
        StringBuilder startAgentCommmand = new StringBuilder();
        if (this.cpu != null) {
            startAgentCommmand.append("taskset -c ").append(this.cpu).append(' ');
        }
        String java = Properties.get((String)"io.hyperfoil.agent.java.executable", (String)"java");
        startAgentCommmand.append(java).append(" -cp ");
        for (Map.Entry<String, String> entry : localMd5.entrySet()) {
            int n = entry.getKey().lastIndexOf("/");
            String filename = n < 0 ? entry.getKey() : entry.getKey().substring(n + 1);
            String remoteChecksum = remoteMd5.remove(filename);
            if (!((String)entry.getValue()).equals(remoteChecksum)) {
                log.debug("MD5 mismatch {}/{}, copying {}", entry.getValue(), (Object)remoteChecksum, entry.getKey());
                try {
                    this.scpClient.upload((String)entry.getKey(), this.dir + "/agentlib/" + filename, new ScpClient.Option[]{ScpClient.Option.PreserveAttributes});
                }
                catch (IOException e) {
                    exceptionHandler.accept(e);
                    return;
                }
            }
            startAgentCommmand.append(this.dir).append(AGENTLIB).append('/').append(filename).append(':');
        }
        if (!remoteMd5.isEmpty()) {
            StringBuilder rmCommand = new StringBuilder();
            rmCommand.append("rm --interactive=never ");
            for (Map.Entry entry : remoteMd5.entrySet()) {
                rmCommand.append(' ').append(this.dir).append(AGENTLIB).append('/').append((String)entry.getKey());
            }
            this.runCommand(rmCommand.toString(), true);
        }
        if ((log4jConfigurationFile = Properties.get((String)"log4j.configurationFile", null)) != null) {
            if (log4jConfigurationFile.startsWith("file://")) {
                log4jConfigurationFile = log4jConfigurationFile.substring("file://".length());
            }
            String filename = log4jConfigurationFile.substring(log4jConfigurationFile.lastIndexOf(File.separatorChar) + 1);
            try {
                String string = this.dir + "/agentlib/" + filename;
                this.scpClient.upload(log4jConfigurationFile, string, new ScpClient.Option[]{ScpClient.Option.PreserveAttributes});
                startAgentCommmand.append(" -D").append("log4j.configurationFile").append("=file://").append(string);
            }
            catch (IOException iOException) {
                log.error("Cannot copy log4j2 configuration file.", (Throwable)iOException);
            }
        }
        startAgentCommmand.append(" -Dvertx.logger-delegate-factory-class-name=io.vertx.core.logging.Log4j2LogDelegateFactory");
        startAgentCommmand.append(" -D").append("io.hyperfoil.agent.name").append('=').append(this.name);
        startAgentCommmand.append(" -D").append("io.hyperfoil.runid").append('=').append(this.runId);
        startAgentCommmand.append(" -D").append("io.hyperfoil.controller.cluster.ip").append('=').append(Properties.get((String)"io.hyperfoil.controller.cluster.ip", (String)""));
        startAgentCommmand.append(" -D").append("io.hyperfoil.controller.cluster.port").append('=').append(Properties.get((String)"io.hyperfoil.controller.cluster.port", (String)""));
        if (DEBUG_ADDRESS != null) {
            startAgentCommmand.append(" -agentlib:jdwp=transport=dt_socket,server=y,suspend=").append(DEBUG_SUSPEND).append(",address=").append(DEBUG_ADDRESS);
        }
        if (this.extras != null) {
            startAgentCommmand.append(" ").append(this.extras);
        }
        startAgentCommmand.append(" io.hyperfoil.Hyperfoil\\$Agent &> ").append(this.dir).append(File.separatorChar).append("agent.").append(this.name).append(".log");
        String startAgent = startAgentCommmand.toString();
        log.info("Starting agent {}", (Object)this.name);
        log.debug("Command: {}", (Object)startAgent);
        this.runCommand(startAgent, false);
        this.onPrompt(new StringBuilder(), new ByteArrayBuffer(), () -> exceptionHandler.accept((Throwable)new BenchmarkExecutionException("Agent process terminated prematurely. Hint: type 'log " + this.name + "' to see agent output.")));
    }

    private void onPrompt(StringBuilder sb, ByteArrayBuffer buffer, Runnable completion) {
        buffer.clear(false);
        this.shellChannel.getAsyncOut().read((Buffer)buffer).addListener(future -> {
            byte[] buf = new byte[future.getRead()];
            future.getBuffer().getRawBytes(buf);
            String str = new String(buf, StandardCharsets.UTF_8);
            log.info("Read: {}", (Object)str);
            sb.append(str);
            if (sb.indexOf(PROMPT) >= 0) {
                completion.run();
            } else {
                if (sb.length() >= PROMPT.length()) {
                    sb.delete(0, sb.length() - PROMPT.length());
                }
                this.onPrompt(sb, buffer, completion);
            }
        });
    }

    private String runCommand(String cmd, boolean wait) {
        log.trace("Running command {}", (Object)cmd);
        this.commandStream.println(cmd);
        this.commandStream.println();
        this.commandStream.flush();
        StringBuilder lines = new StringBuilder();
        ByteArrayBuffer buffer = new ByteArrayBuffer();
        byte[] buf = new byte[buffer.capacity()];
        try {
            IoReadFuture future;
            String line;
            int newLine;
            do {
                buffer.clear(false);
                future = this.shellChannel.getAsyncOut().read((Buffer)buffer);
                if (!future.await(10L, TimeUnit.SECONDS)) {
                    this.exceptionHandler.accept((Throwable)new BenchmarkExecutionException("Timed out waiting for SSH output"));
                    return null;
                }
                buffer.getRawBytes(buf, 0, future.getRead());
            } while ((newLine = (line = new String(buf, 0, future.getRead(), StandardCharsets.UTF_8)).indexOf(10)) < 0);
            if (!wait) {
                return null;
            }
            lines.append(line.substring(newLine + 1));
            while (true) {
                int prompt;
                if ((prompt = lines.lastIndexOf("<_#%@_hyperfoil_@%#_>\r\n")) >= 0) {
                    lines.delete(prompt, lines.length());
                    return lines.toString();
                }
                buffer.clear(false);
                IoReadFuture future2 = this.shellChannel.getAsyncOut().read((Buffer)buffer);
                if (!future2.await(10L, TimeUnit.SECONDS)) {
                    this.exceptionHandler.accept((Throwable)new BenchmarkExecutionException("Timed out waiting for SSH output"));
                    return null;
                }
                buffer.getRawBytes(buf, 0, future2.getRead());
                lines.append(new String(buf, 0, future2.getRead(), StandardCharsets.UTF_8));
            }
        }
        catch (IOException e) {
            this.exceptionHandler.accept(new DeploymentException("Error reading from shell", (Throwable)e));
            return null;
        }
    }

    private Map<String, String> getLocalMd5() {
        String classpath = System.getProperty("java.class.path");
        HashMap<String, String> md5map = new HashMap<String, String>();
        for (String file : classpath.split(":")) {
            if (!file.endsWith(".jar")) continue;
            try {
                Process process = new ProcessBuilder("md5sum", file).start();
                process.waitFor();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line = reader.readLine();
                    if (line == null) {
                        log.warn("No output for md5sum {}", (Object)file);
                        continue;
                    }
                    int space = line.indexOf(32);
                    if (space < 0) {
                        log.warn("Wrong output for md5sum {}: {}", (Object)file, (Object)line);
                        continue;
                    }
                    String checksum = line.substring(0, space);
                    md5map.put(file, checksum);
                }
            }
            catch (IOException e) {
                log.info("Cannot get md5sum for {}", (Object)file, (Object)e);
            }
            catch (InterruptedException e) {
                log.info("Interrupted waiting for md5sum{}", (Object)file);
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return md5map;
    }

    private Map<String, String> getRemoteMd5() {
        String[] lines = this.runCommand("md5sum " + this.dir + "/agentlib/*", true).split("\r*\n");
        HashMap<String, String> md5map = new HashMap<String, String>();
        for (String line : lines) {
            int space;
            if (line.isEmpty()) continue;
            if (line.endsWith("No such file or directory") || (space = line.indexOf(32)) < 0) break;
            String checksum = line.substring(0, space);
            int fileIndex = line.lastIndexOf(47);
            if (fileIndex < 0) {
                fileIndex = space;
            }
            String file = line.substring(fileIndex + 1).trim();
            md5map.put(file, checksum);
        }
        return md5map;
    }

    public void downloadLog(ClientSession session, long offset, long maxLength, String destinationFile, Handler<AsyncResult<Void>> handler) {
        try (SftpClient sftpClient = SftpClientFactory.instance().createSftpClient(session);){
            try (SftpClient.CloseableHandle handle = sftpClient.open(this.dir + File.separatorChar + "agent." + this.name + ".log");){
                byte[] buffer = new byte[65536];
                try (FileOutputStream output = new FileOutputStream(destinationFile);){
                    long remaining;
                    long readOffset = offset;
                    long totalRead = 0L;
                    while ((remaining = maxLength - totalRead) > 0L) {
                        int nread = sftpClient.read((SftpClient.Handle)handle, readOffset, buffer, 0, Math.toIntExact(Math.min(remaining, (long)buffer.length)));
                        if (nread < 0) {
                            break;
                        }
                        output.write(buffer, 0, nread);
                        readOffset += (long)nread;
                        totalRead += (long)nread;
                    }
                }
            }
            handler.handle((Object)Future.succeededFuture());
        }
        catch (IOException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }
}

