/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.controller.Data;
import io.hyperfoil.controller.HistogramConverter;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.core.util.LowHigh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.HdrHistogram.AbstractHistogram;

public class StatisticsStore {
    static final double[] PERCENTILES = new double[]{50.0, 90.0, 99.0, 99.9, 99.99};
    private static final Comparator<RequestStats> REQUEST_STATS_COMPARATOR = Comparator.comparing(rs -> rs.summary.startTime).thenComparing(rs -> rs.phase).thenComparing(rs -> rs.metric);
    private final Benchmark benchmark;
    final Map<Integer, Map<String, Data>> data = new HashMap<Integer, Map<String, Data>>();
    private final Consumer<SLA.Failure> failureHandler;
    final List<SLA.Failure> failures = new ArrayList<SLA.Failure>();
    private final int maxFailures = 100;
    private final Map<Integer, SLA.Provider> slaProviders;
    final Map<String, SessionPoolStats> sessionPoolStats = new HashMap<String, SessionPoolStats>();
    final Map<String, Map<String, Map<String, List<ConnectionPoolStats>>>> connectionPoolStats = new HashMap<String, Map<String, Map<String, List<ConnectionPoolStats>>>>();
    final Map<String, Map<String, String>> cpuUsage = new HashMap<String, Map<String, String>>();

    public StatisticsStore(Benchmark benchmark, Consumer<SLA.Failure> failureHandler) {
        this.benchmark = benchmark;
        this.failureHandler = failureHandler;
        this.slaProviders = benchmark.steps().filter(SLA.Provider.class::isInstance).map(SLA.Provider.class::cast).collect(Collectors.toMap(SLA.Provider::id, Function.identity(), (s1, s2) -> {
            if (s1 != s2) {
                throw new IllegalStateException();
            }
            return s1;
        }));
    }

    public boolean record(String agentName, int phaseId, int stepId, String metric, StatisticsSnapshot stats) {
        Map map = this.data.computeIfAbsent((phaseId << 16) + stepId, phaseStep -> new HashMap());
        Data data = (Data)map.get(metric);
        if (data == null) {
            SLA.Provider slaProvider;
            long collectionPeriod = this.benchmark.statisticsCollectionPeriod();
            Phase phase = this.benchmark.phases().stream().filter(p -> p.id() == phaseId).findFirst().get();
            SLA[] sla = stepId != 0 ? ((slaProvider = this.slaProviders.get(stepId)) == null ? null : slaProvider.sla()) : (SLA[])phase.customSlas.get(metric);
            Map<SLA, Window> rings = sla == null ? Collections.emptyMap() : Stream.of(sla).filter(s -> s.window() > 0L).collect(Collectors.toMap(Function.identity(), s -> new Window((int)(s.window() / collectionPeriod))));
            SLA[] total = sla == null ? new SLA[]{} : (SLA[])Stream.of(sla).filter(s -> s.window() <= 0L).toArray(SLA[]::new);
            data = new Data(this, phase.name, phase.isWarmup, stepId, metric, rings, total);
            map.put(metric, data);
        }
        return data.record(agentName, stats);
    }

    public void addFailure(String phase, String metric, long startTimestamp, long endTimestamp, String cause) {
        StatisticsSnapshot statistics = new StatisticsSnapshot();
        statistics.histogram.setStartTimeStamp(startTimestamp);
        statistics.histogram.setEndTimeStamp(endTimestamp);
        this.failures.add(new SLA.Failure(null, phase, metric, statistics, cause));
    }

    public void completePhase(String phase) {
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                if (!data.phase.equals(phase)) continue;
                data.completePhase();
            }
        }
    }

    public void completeAll(Consumer<String> errorHandler) {
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                if (data.isCompleted()) continue;
                String message = String.format("Data for %s/%d/%s were not completed when the phase terminated - was the data received after that?", data.phase, data.stepId, data.metric);
                errorHandler.accept(message);
                data.completePhase();
            }
        }
    }

    public void adjustPhaseTimestamps(String phase, long start, long completion) {
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                if (!data.phase.equals(phase)) continue;
                data.total.histogram.setStartTimeStamp(Math.min(start, data.total.histogram.getStartTimeStamp()));
                data.total.histogram.setEndTimeStamp(Math.max(completion, data.total.histogram.getEndTimeStamp()));
            }
        }
    }

    public boolean validateSlas() {
        return this.failures.isEmpty();
    }

    public List<RequestStats> recentSummary(long minValidTimestamp) {
        ArrayList<RequestStats> result = new ArrayList<RequestStats>();
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                OptionalInt lastSequenceId = data.lastStats.values().stream().flatMapToInt(map -> map.keySet().stream().mapToInt(Integer::intValue)).max();
                if (lastSequenceId.isEmpty()) continue;
                int penultimateId = lastSequenceId.getAsInt() - 1;
                StatisticsSnapshot sum = new StatisticsSnapshot();
                data.lastStats.values().stream().map(map -> (StatisticsSnapshot)map.get(penultimateId)).filter(Objects::nonNull).forEach(arg_0 -> ((StatisticsSnapshot)sum).add(arg_0));
                if (sum.isEmpty() || sum.histogram.getStartTimeStamp() < minValidTimestamp) continue;
                List failures = this.failures.stream().filter(f -> f.phase().equals(data.phase) && (f.metric() == null || f.metric().equals(data.metric))).map(SLA.Failure::message).collect(Collectors.toList());
                result.add(new RequestStats(data.phase, data.stepId, data.metric, sum.summary(PERCENTILES), failures, data.isWarmup));
            }
        }
        result.sort(REQUEST_STATS_COMPARATOR);
        return result;
    }

    public List<RequestStats> totalSummary() {
        ArrayList<RequestStats> result = new ArrayList<RequestStats>();
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                StatisticsSummary last = data.total.summary(PERCENTILES);
                List failures = this.failures.stream().filter(f -> f.phase().equals(data.phase) && (f.metric() == null || f.metric().equals(data.metric))).map(SLA.Failure::message).collect(Collectors.toList());
                result.add(new RequestStats(data.phase, data.stepId, data.metric, last, failures, data.isWarmup));
            }
        }
        result.sort(REQUEST_STATS_COMPARATOR);
        return result;
    }

    public Histogram histogram(String phase, int stepId, String metric) {
        Data data = this.getData(phase, stepId, metric);
        if (data == null) {
            return null;
        }
        return HistogramConverter.convert((String)phase, (String)metric, (AbstractHistogram)data.total.histogram);
    }

    public List<StatisticsSummary> series(String phase, int stepId, String metric) {
        Data data = this.getData(phase, stepId, metric);
        if (data == null) {
            return null;
        }
        return data.series;
    }

    private Data getData(String phase, int stepId, String metric) {
        int phaseId = this.benchmark.phases().stream().filter(p -> p.name.equals(phase)).mapToInt(p -> p.id).findFirst().orElse(-1);
        Map<String, Data> phaseStepData = this.data.get((phaseId << 16) + stepId);
        if (phaseStepData == null) {
            return null;
        }
        return phaseStepData.get(metric);
    }

    public void recordSessionStats(String address, long timestamp, String phase, int minSessions, int maxSessions) {
        SessionPoolStats sps = this.sessionPoolStats.computeIfAbsent(phase, p -> new SessionPoolStats());
        sps.records.computeIfAbsent(address, a -> new ArrayList()).add(new SessionPoolRecord(timestamp, minSessions, maxSessions));
    }

    public Map<String, Map<String, LowHigh>> recentSessionPoolSummary(long minValidTimestamp) {
        return this.sessionPoolSummary(records -> {
            SessionPoolRecord record = (SessionPoolRecord)((Object)((Object)records.get(records.size() - 1)));
            return record.timestamp >= minValidTimestamp ? record : null;
        });
    }

    public Map<String, Map<String, LowHigh>> totalSessionPoolSummary() {
        return this.sessionPoolSummary(records -> {
            int low = records.stream().mapToInt(r -> r.low).min().orElse(0);
            int high = records.stream().mapToInt(r -> r.high).max().orElse(0);
            return new LowHigh(low, high);
        });
    }

    private Map<String, Map<String, LowHigh>> sessionPoolSummary(Function<List<SessionPoolRecord>, LowHigh> function) {
        HashMap<String, Map<String, LowHigh>> result = new HashMap<String, Map<String, LowHigh>>();
        for (Map.Entry<String, SessionPoolStats> phaseEntry : this.sessionPoolStats.entrySet()) {
            HashMap<String, LowHigh> addressSummary = new HashMap<String, LowHigh>();
            for (Map.Entry<String, List<SessionPoolRecord>> addressEntry : phaseEntry.getValue().records.entrySet()) {
                LowHigh lohi;
                List<SessionPoolRecord> records = addressEntry.getValue();
                if (records.isEmpty() || (lohi = function.apply(records)) == null) continue;
                addressSummary.put(addressEntry.getKey(), lohi);
            }
            if (addressSummary.isEmpty()) continue;
            result.put(phaseEntry.getKey(), addressSummary);
        }
        return result;
    }

    public void recordConnectionStats(String address, long timestamp, Map<String, Map<String, LowHigh>> stats) {
        for (Map.Entry<String, Map<String, LowHigh>> byAuthority : stats.entrySet()) {
            for (Map.Entry<String, LowHigh> byType : byAuthority.getValue().entrySet()) {
                Map authorityData = this.connectionPoolStats.computeIfAbsent(byAuthority.getKey(), a -> new HashMap());
                Map typeData = authorityData.computeIfAbsent(byType.getKey(), t -> new HashMap());
                List agentData = typeData.computeIfAbsent(address, a -> new ArrayList());
                LowHigh value = byType.getValue();
                agentData.add(new ConnectionPoolStats(timestamp, value.low, value.high));
            }
        }
    }

    public Map<String, Map<String, LowHigh>> recentConnectionsSummary() {
        HashMap<String, Map<String, LowHigh>> summary = new HashMap<String, Map<String, LowHigh>>();
        long minTimestamp = System.currentTimeMillis() - 5000L;
        for (Map.Entry<String, Map<String, Map<String, List<ConnectionPoolStats>>>> byAuthority : this.connectionPoolStats.entrySet()) {
            for (Map.Entry<String, Map<String, List<ConnectionPoolStats>>> byType : byAuthority.getValue().entrySet()) {
                LowHigh sum;
                if (byType.getValue().values().stream().anyMatch(list -> ((ConnectionPoolStats)((Object)((Object)list.get((int)(list.size() - 1))))).timestamp < minTimestamp) || (sum = (LowHigh)byType.getValue().values().stream().map(list -> (LowHigh)list.get(list.size() - 1)).reduce(LowHigh::sum).orElse(null)) == null) continue;
                summary.computeIfAbsent(byAuthority.getKey(), a -> new HashMap()).put(byType.getKey(), sum);
            }
        }
        return summary;
    }

    public Map<String, Map<String, LowHigh>> totalConnectionsSummary() {
        HashMap<String, Map<String, LowHigh>> summary = new HashMap<String, Map<String, LowHigh>>();
        for (Map.Entry<String, Map<String, Map<String, List<ConnectionPoolStats>>>> byAuthority : this.connectionPoolStats.entrySet()) {
            for (Map.Entry<String, Map<String, List<ConnectionPoolStats>>> byType : byAuthority.getValue().entrySet()) {
                int maxSize = byType.getValue().values().stream().mapToInt(List::size).max().orElse(0);
                LowHigh total = null;
                int i = 0;
                while (i < maxSize) {
                    int ii = i++;
                    total = LowHigh.combine(total, (LowHigh)byType.getValue().values().stream().map(list -> ii < list.size() ? (LowHigh)list.get(ii) : null).reduce(LowHigh::sum).orElse(null));
                }
                if (total == null) continue;
                summary.computeIfAbsent(byAuthority.getKey(), a -> new HashMap()).put(byType.getKey(), total);
            }
        }
        return summary;
    }

    public void recordCpuUsage(String phase, String agentName, String usage) {
        this.cpuUsage.computeIfAbsent(phase, p -> new HashMap()).putIfAbsent(agentName, usage);
    }

    public Map<String, Map<String, String>> cpuUsage() {
        return this.cpuUsage;
    }

    void addFailure(SLA.Failure failure) {
        if (this.failures.size() < 100) {
            this.failures.add(failure);
        }
        this.failureHandler.accept(failure);
    }

    public List<Data> getData() {
        Data[] rtrn = (Data[])this.data.values().stream().flatMap(map -> map.values().stream()).toArray(Data[]::new);
        Arrays.sort(rtrn, Comparator.comparing(data -> data.phase).thenComparing(d -> d.metric).thenComparingInt(d -> d.stepId));
        return Arrays.asList(rtrn);
    }

    void addData(int id, String metric, Data data) {
        this.data.computeIfAbsent(id, i -> new HashMap()).put(metric, data);
    }

    public List<SLA.Failure> getFailures() {
        return this.failures;
    }

    static class SessionPoolStats {
        Map<String, List<SessionPoolRecord>> records = new HashMap<String, List<SessionPoolRecord>>();

        SessionPoolStats() {
        }

        LowHigh findMinMax() {
            LowHigh combined;
            int min = Integer.MAX_VALUE;
            int max = 0;
            List iterators = this.records.values().stream().map(List::iterator).collect(Collectors.toList());
            while ((combined = (LowHigh)iterators.stream().filter(Iterator::hasNext).map(Iterator::next).map(LowHigh.class::cast).reduce(LowHigh::sum).orElse(null)) != null) {
                min = Math.min(min, combined.low);
                max = Math.max(max, combined.high);
            }
            return new LowHigh(min, max);
        }
    }

    static class SessionPoolRecord
    extends LowHigh {
        final long timestamp;

        SessionPoolRecord(long timestamp, int min, int max) {
            super(min, max);
            this.timestamp = timestamp;
        }
    }

    static class ConnectionPoolStats
    extends LowHigh {
        final long timestamp;

        ConnectionPoolStats(long timestamp, int low, int high) {
            super(low, high);
            this.timestamp = timestamp;
        }
    }

    static final class Window {
        private final StatisticsSnapshot[] ring;
        private final StatisticsSnapshot sum = new StatisticsSnapshot();
        private int ptr = 0;

        Window(int size) {
            assert (size > 0);
            this.ring = new StatisticsSnapshot[size];
        }

        void add(StatisticsSnapshot stats) {
            if (this.ring[this.ptr] != null) {
                this.sum.subtract(this.ring[this.ptr]);
            }
            this.ring[this.ptr] = stats;
            this.sum.add(stats);
            this.ptr = (this.ptr + 1) % this.ring.length;
        }

        public boolean isFull() {
            return this.ring[this.ptr] != null;
        }

        public StatisticsSnapshot current() {
            return this.sum;
        }
    }
}

