/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import com.fasterxml.jackson.core.JsonGenerator;
import io.hyperfoil.api.Version;
import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.controller.Data;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.controller.WriterUtil;
import io.hyperfoil.core.util.LowHigh;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.HdrHistogram.HistogramIterationValue;

public class JsonWriter {
    static final String RUN_SCHEMA = "http://hyperfoil.io/run-schema/v3.0";

    /*
     * WARNING - void declaration
     */
    public static void writeArrayJsons(StatisticsStore store, JsonGenerator jGenerator, JsonObject info) throws IOException {
        void var7_12;
        String[] split;
        void var7_10;
        Data[] sorted = (Data[])store.data.values().stream().flatMap(map -> map.values().stream()).toArray(Data[]::new);
        Arrays.sort(sorted, Comparator.comparing(data -> data.phase).thenComparing(d -> d.metric).thenComparingInt(d -> d.stepId));
        jGenerator.writeStartObject();
        if (info != null && !info.isEmpty()) {
            jGenerator.writeFieldName("info");
            jGenerator.writeRawValue(info.encode());
        }
        jGenerator.writeStringField("$schema", RUN_SCHEMA);
        jGenerator.writeStringField("version", Version.VERSION);
        jGenerator.writeStringField("commit", Version.COMMIT_ID);
        jGenerator.writeFieldName("failures");
        jGenerator.writeStartArray();
        List<SLA.Failure> failures = store.getFailures();
        for (SLA.Failure failure : failures) {
            jGenerator.writeStartObject();
            jGenerator.writeStringField("phase", failure.phase());
            jGenerator.writeStringField("metric", failure.metric());
            jGenerator.writeStringField("message", failure.message());
            jGenerator.writeNumberField("start", failure.statistics().histogram.getStartTimeStamp());
            jGenerator.writeNumberField("end", failure.statistics().histogram.getEndTimeStamp());
            jGenerator.writeObjectField("percentileResponseTime", (Object)failure.statistics().getPercentiles(StatisticsStore.PERCENTILES));
            jGenerator.writeEndObject();
        }
        jGenerator.writeEndArray();
        jGenerator.writeFieldName("stats");
        jGenerator.writeStartArray();
        Data[] dataArray = sorted;
        int n = dataArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            Data data2 = dataArray[var7_10];
            jGenerator.writeStartObject();
            jGenerator.writeStringField("name", data2.phase);
            split = JsonWriter.parsePhaseName(data2.phase, "");
            jGenerator.writeStringField("phase", split[0]);
            jGenerator.writeStringField("iteration", split[1]);
            jGenerator.writeStringField("fork", split[2]);
            jGenerator.writeStringField("metric", data2.metric);
            jGenerator.writeBooleanField("isWarmup", data2.isWarmup);
            jGenerator.writeFieldName("total");
            long numFailures = failures.stream().filter(f -> f.phase().equals(data.phase) && (f.metric() == null || f.metric().equals(data.metric))).count();
            StatisticsStore.SessionPoolStats sessionPoolStats = store.sessionPoolStats.get(data2.phase);
            LowHigh minMaxSessions = sessionPoolStats == null ? new LowHigh(0, 0) : sessionPoolStats.findMinMax();
            JsonWriter.writeTotalValue(jGenerator, data2, d -> d.total, minMaxSessions, numFailures);
            jGenerator.writeFieldName("histogram");
            jGenerator.writeStartObject();
            jGenerator.writeFieldName("percentiles");
            JsonWriter.histogramArray(jGenerator, data2.total.histogram.percentiles(5).iterator(), 100.0);
            jGenerator.writeFieldName("linear");
            JsonWriter.histogramArray(jGenerator, data2.total.histogram.linearBucketValues(1000000L).iterator(), 95.0);
            jGenerator.writeEndObject();
            jGenerator.writeFieldName("series");
            JsonWriter.seriesArray(jGenerator, data2.series);
            jGenerator.writeEndObject();
            ++var7_10;
        }
        jGenerator.writeEndArray();
        jGenerator.writeFieldName("sessions");
        jGenerator.writeStartArray();
        dataArray = sorted;
        n = dataArray.length;
        boolean bl2 = false;
        while (var7_12 < n) {
            Data data2 = dataArray[var7_12];
            if (store.sessionPoolStats.containsKey(data2.phase)) {
                jGenerator.writeStartObject();
                jGenerator.writeStringField("name", data2.phase);
                split = JsonWriter.parsePhaseName(data2.phase, "");
                jGenerator.writeStringField("phase", split[0]);
                jGenerator.writeStringField("iteration", split[1]);
                jGenerator.writeStringField("fork", split[2]);
                StatisticsStore.SessionPoolStats sps = store.sessionPoolStats.get(data2.phase);
                Map records = sps != null ? sps.records : Collections.emptyMap();
                jGenerator.writeFieldName("sessions");
                jGenerator.writeStartArray();
                WriterUtil.printInSync(records, (agent, record) -> {
                    jGenerator.writeStartObject();
                    jGenerator.writeNumberField("timestamp", record.timestamp);
                    jGenerator.writeStringField("agent", agent);
                    jGenerator.writeNumberField("minSessions", record.low);
                    jGenerator.writeNumberField("maxSessions", record.high);
                    jGenerator.writeEndObject();
                });
                jGenerator.writeEndArray();
                jGenerator.writeEndObject();
            }
            ++var7_12;
        }
        jGenerator.writeEndArray();
        String[] agents = (String[])store.data.values().stream().flatMap(m -> m.values().stream()).flatMap(d -> d.perAgent.keySet().stream()).distinct().sorted().toArray(String[]::new);
        jGenerator.writeFieldName("agents");
        jGenerator.writeStartArray();
        for (String agent2 : agents) {
            jGenerator.writeStartObject();
            jGenerator.writeStringField("name", agent2);
            jGenerator.writeFieldName("stats");
            jGenerator.writeStartArray();
            for (Data data3 : sorted) {
                if (!data3.perAgent.containsKey(agent2)) continue;
                jGenerator.writeStartObject();
                jGenerator.writeStringField("name", data3.phase);
                String[] split2 = JsonWriter.parsePhaseName(data3.phase, "");
                jGenerator.writeStringField("phase", split2[0]);
                jGenerator.writeStringField("iteration", split2[1]);
                jGenerator.writeStringField("fork", split2[2]);
                jGenerator.writeStringField("metric", data3.metric);
                jGenerator.writeBooleanField("isWarmup", data3.isWarmup);
                jGenerator.writeFieldName("total");
                JsonWriter.writeTotalValue(jGenerator, data3, d -> d.perAgent.get(agent2), ((List)store.sessionPoolStats.getOrDefault((Object)data3.phase, (StatisticsStore.SessionPoolStats)new StatisticsStore.SessionPoolStats()).records.getOrDefault(agent2, new ArrayList())).stream().map(LowHigh.class::cast).reduce(LowHigh::combine).orElse(new LowHigh(0, 0)), -1L);
                jGenerator.writeFieldName("histogram");
                jGenerator.writeStartObject();
                jGenerator.writeFieldName("percentiles");
                JsonWriter.histogramArray(jGenerator, data3.perAgent.get((Object)agent2).histogram.percentiles(5).iterator(), 100.0);
                jGenerator.writeFieldName("linear");
                JsonWriter.histogramArray(jGenerator, data3.perAgent.get((Object)agent2).histogram.linearBucketValues(1000000L).iterator(), 95.0);
                jGenerator.writeEndObject();
                jGenerator.writeFieldName("series");
                JsonWriter.seriesArray(jGenerator, data3.agentSeries.get(agent2));
                jGenerator.writeEndObject();
            }
            jGenerator.writeEndArray();
            jGenerator.writeEndObject();
        }
        jGenerator.writeEndArray();
        jGenerator.writeObjectFieldStart("connections");
        for (Map.Entry entry : store.connectionPoolStats.entrySet()) {
            jGenerator.writeObjectFieldStart((String)entry.getKey());
            for (Map.Entry typeEntry : ((Map)entry.getValue()).entrySet()) {
                jGenerator.writeArrayFieldStart((String)typeEntry.getKey());
                WriterUtil.printInSync((Map)typeEntry.getValue(), (agent, record) -> {
                    jGenerator.writeStartObject();
                    jGenerator.writeNumberField("timestamp", record.timestamp);
                    jGenerator.writeStringField("agent", agent);
                    jGenerator.writeNumberField("min", record.low);
                    jGenerator.writeNumberField("max", record.high);
                    jGenerator.writeEndObject();
                });
                jGenerator.writeEndArray();
            }
            jGenerator.writeEndObject();
        }
        jGenerator.writeEndObject();
        jGenerator.writeObjectFieldStart("agentCpu");
        for (Map.Entry entry : store.cpuUsage.entrySet()) {
            jGenerator.writeObjectFieldStart((String)entry.getKey());
            for (Map.Entry agentEntry : ((Map)entry.getValue()).entrySet()) {
                jGenerator.writeStringField((String)agentEntry.getKey(), (String)agentEntry.getValue());
            }
            jGenerator.writeEndObject();
        }
        jGenerator.writeEndObject();
        jGenerator.writeEndObject();
    }

    private static String[] parsePhaseName(String phase, String defaultName) {
        String[] rtrn = new String[3];
        if (phase.contains("/")) {
            rtrn[0] = phase.substring(0, phase.indexOf("/"));
            phase = phase.substring(phase.indexOf("/") + 1);
        } else {
            rtrn[0] = phase;
            phase = "";
        }
        if (phase.isEmpty()) {
            rtrn[1] = defaultName;
            rtrn[2] = defaultName;
            return rtrn;
        }
        if (phase.contains("/")) {
            rtrn[1] = phase.substring(0, phase.indexOf("/"));
            if ((phase = phase.substring(phase.indexOf("/") + 1)).isEmpty()) {
                phase = defaultName;
            }
            rtrn[2] = phase;
        } else if (phase.matches("[0-9]+")) {
            rtrn[1] = phase;
            rtrn[2] = defaultName;
        } else {
            rtrn[1] = defaultName;
            rtrn[2] = phase;
        }
        return rtrn;
    }

    private static void histogramArray(JsonGenerator jGenerator, Iterator<HistogramIterationValue> iter, double maxPercentile) throws IOException {
        jGenerator.writeStartArray();
        double from = -1.0;
        double to = -1.0;
        double percentileTo = -1.0;
        long total = 0L;
        HistogramIterationValue iterValue = null;
        while (iter.hasNext()) {
            iterValue = iter.next();
            if (iterValue.getCountAddedInThisIterationStep() == 0L) {
                if (from < 0.0) {
                    from = iterValue.getValueIteratedFrom();
                    total = iterValue.getTotalCountToThisValue();
                }
                to = iterValue.getValueIteratedTo();
                percentileTo = iterValue.getPercentileLevelIteratedTo();
            } else {
                if (from >= 0.0) {
                    JsonWriter.writeBucket(jGenerator, from, to, percentileTo, 0L, total);
                    from = -1.0;
                }
                JsonWriter.writeBucket(jGenerator, iterValue.getDoubleValueIteratedFrom(), iterValue.getDoubleValueIteratedTo(), iterValue.getPercentileLevelIteratedTo(), iterValue.getCountAddedInThisIterationStep(), iterValue.getTotalCountToThisValue());
            }
            if (!(iterValue.getPercentileLevelIteratedTo() > maxPercentile)) continue;
        }
        if (from >= 0.0) {
            JsonWriter.writeBucket(jGenerator, from, to, percentileTo, 0L, total);
        }
        if (iterValue != null) {
            from = iterValue.getDoubleValueIteratedTo();
            total = iterValue.getTotalCountToThisValue();
            while (iter.hasNext()) {
                iterValue = iter.next();
            }
            if (iterValue.getTotalCountToThisValue() != total) {
                JsonWriter.writeBucket(jGenerator, from, iterValue.getDoubleValueIteratedTo(), iterValue.getPercentileLevelIteratedTo(), iterValue.getTotalCountToThisValue() - total, iterValue.getTotalCountToThisValue());
            }
        }
        jGenerator.writeEndArray();
    }

    private static void writeBucket(JsonGenerator jGenerator, double from, double to, double percentile, long count, long totalCount) throws IOException {
        jGenerator.writeStartObject();
        jGenerator.writeNumberField("from", from);
        jGenerator.writeNumberField("to", to);
        jGenerator.writeNumberField("percentile", percentile / 100.0);
        jGenerator.writeNumberField("count", count);
        jGenerator.writeNumberField("totalCount", totalCount);
        jGenerator.writeEndObject();
    }

    private static void seriesArray(JsonGenerator jGenerator, List<StatisticsSummary> series) throws IOException {
        jGenerator.writeStartArray();
        if (series != null) {
            for (StatisticsSummary summary : series) {
                jGenerator.writeObject((Object)summary);
            }
        }
        jGenerator.writeEndArray();
        jGenerator.flush();
    }

    private static void writeTotalValue(JsonGenerator generator, Data data, Function<Data, StatisticsSnapshot> selector, LowHigh minMaxSessions, long failures) throws IOException {
        StatisticsSnapshot snapshot = selector.apply(data);
        generator.writeStartObject();
        generator.writeStringField("phase", data.phase);
        generator.writeStringField("metric", data.metric);
        generator.writeNumberField("start", data.total.histogram.getStartTimeStamp());
        generator.writeNumberField("end", data.total.histogram.getEndTimeStamp());
        generator.writeObjectField("summary", (Object)snapshot.summary(StatisticsStore.PERCENTILES));
        if (failures >= 0L) {
            generator.writeNumberField("failures", failures);
        }
        if (minMaxSessions != null) {
            generator.writeNumberField("minSessions", minMaxSessions.low);
            generator.writeNumberField("maxSessions", minMaxSessions.high);
        }
        generator.writeEndObject();
    }
}

