/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.api.statistics.StatsExtension;
import io.hyperfoil.controller.Data;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.controller.WriterUtil;
import io.hyperfoil.core.util.LowHigh;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvWriter {
    private static final Logger log = LogManager.getLogger(CsvWriter.class);

    /*
     * WARNING - void declaration
     */
    public static void writeCsv(Path dir, StatisticsStore store) throws IOException {
        Object writer;
        String[] agents;
        void var6_12;
        store.data.values().stream().flatMap(m -> m.values().stream()).filter(d -> !d.isCompleted()).findAny().ifPresent(incomplete -> log.error("Phase {} metric {} was not completed!", (Object)incomplete.phase, (Object)incomplete.metric));
        File statsDir = dir.toFile();
        if (!statsDir.exists() && !statsDir.mkdirs()) {
            throw new IOException("Cannot create directory " + String.valueOf(dir));
        }
        Data[] sorted = (Data[])store.data.values().stream().flatMap(map -> map.values().stream()).toArray(Data[]::new);
        Arrays.sort(sorted, Comparator.comparing(d -> d.phase).thenComparing(d -> d.metric).thenComparingInt(d -> d.stepId));
        try (Data[] writer2 = new PrintWriter(String.valueOf(dir) + File.separator + "total.csv");){
            void var8_30;
            writer2.print("Phase,Metric,Start,End,");
            StatisticsSummary.printHeader((PrintWriter)writer2, (double[])StatisticsStore.PERCENTILES);
            String[] extensionHeaders = CsvWriter.getHeaders(Stream.of(sorted).map(d -> d.total.extensions));
            CsvWriter.printExtensionHeaders((PrintWriter)writer2, extensionHeaders);
            writer2.println(",MinSessions,MaxSessions");
            Data[] dataArray = sorted;
            int n = dataArray.length;
            boolean bl = false;
            while (var8_30 < n) {
                Data data = dataArray[var8_30];
                writer2.print(data.phase);
                writer2.print(',');
                writer2.print(data.metric);
                writer2.print(',');
                writer2.print(data.total.histogram.getStartTimeStamp());
                writer2.print(',');
                writer2.print(data.total.histogram.getEndTimeStamp());
                writer2.print(',');
                data.total.summary(StatisticsStore.PERCENTILES).printTo((PrintWriter)writer2, extensionHeaders);
                StatisticsStore.SessionPoolStats sps = store.sessionPoolStats.get(data.phase);
                if (sps == null) {
                    writer2.print(",,");
                } else {
                    LowHigh minMax = sps.findMinMax();
                    writer2.print(',');
                    writer2.print(minMax.low);
                    writer2.print(',');
                    writer2.print(minMax.high);
                }
                writer2.println();
                ++var8_30;
            }
        }
        writer2 = sorted;
        int extensionHeaders = writer2.length;
        boolean bl = false;
        while (var6_12 < extensionHeaders) {
            Data data = writer2[var6_12];
            String string = String.valueOf(dir) + File.separator + CsvWriter.sanitize(data.phase) + "." + CsvWriter.sanitize(data.metric) + "." + data.stepId;
            CsvWriter.writeHistogramAndSeries(string, data.total, data.series);
            ++var6_12;
        }
        for (String string : agents = (String[])store.data.values().stream().flatMap(m -> m.values().stream()).flatMap(d -> d.perAgent.keySet().stream()).distinct().sorted().toArray(String[]::new)) {
            writer = new PrintWriter(String.valueOf(dir) + File.separator + "agent." + CsvWriter.sanitize(string) + ".csv");
            try {
                ((PrintWriter)writer).print("Phase,Metric,Start,End,");
                StatisticsSummary.printHeader((PrintWriter)writer, (double[])StatisticsStore.PERCENTILES);
                String[] extensionHeaders2 = CsvWriter.getHeaders(Stream.of(sorted).map(d -> d.perAgent.get(agent2)).filter(Objects::nonNull).map(s -> s.extensions));
                CsvWriter.printExtensionHeaders((PrintWriter)writer, extensionHeaders2);
                ((PrintWriter)writer).println(",MinSessions,MaxSessions");
                for (Data data : sorted) {
                    StatisticsSnapshot agentStats = data.perAgent.get(string);
                    if (agentStats == null) continue;
                    ((PrintWriter)writer).print(data.phase);
                    ((PrintWriter)writer).print(',');
                    ((PrintWriter)writer).print(data.metric);
                    ((PrintWriter)writer).print(',');
                    ((PrintWriter)writer).print(data.total.histogram.getStartTimeStamp());
                    ((PrintWriter)writer).print(',');
                    ((PrintWriter)writer).print(data.total.histogram.getEndTimeStamp());
                    ((PrintWriter)writer).print(',');
                    agentStats.summary(StatisticsStore.PERCENTILES).printTo((PrintWriter)writer, extensionHeaders2);
                    StatisticsStore.SessionPoolStats sps = store.sessionPoolStats.get(data.phase);
                    if (sps == null || sps.records.get(string) == null) {
                        ((PrintWriter)writer).print(",,");
                    } else {
                        LowHigh lohi = sps.records.get(string).stream().map(LowHigh.class::cast).reduce(LowHigh::combine).orElse(new LowHigh(0, 0));
                        ((PrintWriter)writer).print(',');
                        ((PrintWriter)writer).print(lohi.low);
                        ((PrintWriter)writer).print(',');
                        ((PrintWriter)writer).print(lohi.high);
                    }
                    ((PrintWriter)writer).println();
                }
            }
            finally {
                ((PrintWriter)writer).close();
            }
            for (Data data : sorted) {
                String filePrefix = String.valueOf(dir) + File.separator + CsvWriter.sanitize(data.phase) + "." + CsvWriter.sanitize(data.metric) + "." + data.stepId + ".agent." + string;
                CsvWriter.writeHistogramAndSeries(filePrefix, data.perAgent.get(string), data.agentSeries.get(string));
            }
        }
        try (Iterator<Map.Entry<String, Map<String, Map<String, List<StatisticsStore.ConnectionPoolStats>>>>> writer3 = new PrintWriter(String.valueOf(dir) + File.separator + "failures.csv");){
            ((PrintWriter)((Object)writer3)).print("Phase,Metric,Message,Start,End,");
            StatisticsSummary.printHeader((PrintWriter)((Object)writer3), (double[])StatisticsStore.PERCENTILES);
            String[] stringArray = CsvWriter.getHeaders(store.failures.stream().map(f -> f.statistics().extensions));
            CsvWriter.printExtensionHeaders((PrintWriter)((Object)writer3), stringArray);
            ((PrintWriter)((Object)writer3)).println();
            for (SLA.Failure failure : store.failures) {
                ((PrintWriter)((Object)writer3)).print(failure.phase());
                ((PrintWriter)((Object)writer3)).print(',');
                ((PrintWriter)((Object)writer3)).print(failure.metric());
                ((PrintWriter)((Object)writer3)).print(",\"");
                ((PrintWriter)((Object)writer3)).print(failure.message());
                ((PrintWriter)((Object)writer3)).print("\",");
                StatisticsSummary summary = failure.statistics().summary(StatisticsStore.PERCENTILES);
                ((PrintWriter)((Object)writer3)).print(summary.startTime);
                ((PrintWriter)((Object)writer3)).print(',');
                ((PrintWriter)((Object)writer3)).print(summary.endTime);
                ((PrintWriter)((Object)writer3)).print(',');
                summary.printTo(writer3, stringArray);
                ((PrintWriter)((Object)writer3)).println();
            }
        }
        for (Map.Entry entry : store.sessionPoolStats.entrySet()) {
            try (PrintWriter writer4 = new PrintWriter(String.valueOf(dir) + File.separator + CsvWriter.sanitize((String)entry.getKey()) + ".sessions.csv");){
                writer4.println("Timestamp,Agent,MinSessions,MaxSessions");
                WriterUtil.printInSync(((StatisticsStore.SessionPoolStats)entry.getValue()).records, (agent, record) -> {
                    writer4.print(record.timestamp);
                    writer4.print(',');
                    writer4.print((String)agent);
                    writer4.print(',');
                    writer4.print(record.low);
                    writer4.print(',');
                    writer4.println(record.high);
                });
            }
        }
        for (Map.Entry<String, Map<String, Map<String, List<StatisticsStore.ConnectionPoolStats>>>> entry : store.connectionPoolStats.entrySet()) {
            for (Map.Entry entry2 : entry.getValue().entrySet()) {
                writer = new PrintWriter(String.valueOf(dir) + File.separator + CsvWriter.sanitize(entry.getKey()) + "." + CsvWriter.sanitize((String)entry2.getKey()) + ".connections.csv");
                try {
                    ((PrintWriter)writer).println("Timestamp,Agent,MinConnections,MaxConnections");
                    WriterUtil.printInSync((Map)entry2.getValue(), (arg_0, arg_1) -> CsvWriter.lambda$writeCsv$16((PrintWriter)writer, arg_0, arg_1));
                }
                finally {
                    ((PrintWriter)writer).close();
                }
            }
        }
        try (PrintWriter writer2 = new PrintWriter(String.valueOf(dir) + File.separator + "agentCpu.csv");){
            String[] stringArray = (String[])store.cpuUsage.values().stream().flatMap(agentMap -> agentMap.keySet().stream()).sorted().distinct().toArray(String[]::new);
            writer2.print("phase,");
            for (int i = 0; i < stringArray.length; ++i) {
                writer2.print(stringArray[i]);
            }
            writer2.println();
            for (Map.Entry<String, Map<String, String>> entry : store.cpuUsage.entrySet()) {
                writer2.print(entry.getKey());
                for (String a : stringArray) {
                    writer2.print(',');
                    String usage = entry.getValue().get(a);
                    if (usage == null) continue;
                    writer2.print(usage);
                }
                writer2.println();
            }
        }
    }

    private static String sanitize(String phase) {
        return phase.replaceAll(File.separator, "_");
    }

    private static void writeHistogramAndSeries(String filePrefix, StatisticsSnapshot total, List<StatisticsSummary> series) throws FileNotFoundException {
        if (total != null) {
            try (PrintStream stream = new PrintStream(new FileOutputStream(filePrefix + ".histogram.csv"));){
                total.histogram.outputPercentileDistribution(stream, 5, Double.valueOf(1000000.0), true);
            }
        }
        if (series != null) {
            String[] extensionHeaders = CsvWriter.getHeaders(series.stream().map(ss -> ss.extensions));
            try (PrintWriter writer = new PrintWriter(filePrefix + ".series.csv");){
                writer.print("Start,End,");
                StatisticsSummary.printHeader((PrintWriter)writer, (double[])StatisticsStore.PERCENTILES);
                CsvWriter.printExtensionHeaders(writer, extensionHeaders);
                writer.println();
                for (StatisticsSummary summary : series) {
                    writer.print(summary.startTime);
                    writer.print(',');
                    writer.print(summary.endTime);
                    writer.print(',');
                    summary.printTo(writer, extensionHeaders);
                    writer.println();
                }
            }
        }
    }

    private static void printExtensionHeaders(PrintWriter writer, String[] extensionHeaders) {
        for (String header : extensionHeaders) {
            writer.print(',');
            writer.print(header);
        }
    }

    private static String[] getHeaders(Stream<? extends Map<String, StatsExtension>> extensions) {
        return (String[])extensions.flatMap(ext -> ext.entrySet().stream().flatMap(c -> Stream.of(((StatsExtension)c.getValue()).headers()).map(h -> (String)c.getKey() + "." + h))).sorted().distinct().toArray(String[]::new);
    }

    private static /* synthetic */ void lambda$writeCsv$16(PrintWriter writer, String agent, StatisticsStore.ConnectionPoolStats record) throws RuntimeException {
        writer.print(record.timestamp);
        writer.print(',');
        writer.print(agent);
        writer.print(',');
        writer.print(record.low);
        writer.print(',');
        writer.println(record.high);
    }
}

