/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.webcli;

import io.hyperfoil.clustering.webcli.WebCLI;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class WebsocketOutputStream
extends OutputStream
implements Callable<Void> {
    private ServerWebSocket webSocket;
    private final ByteArrayOutputStream bytes = new ByteArrayOutputStream();
    private ScheduledFuture<Void> future;

    WebsocketOutputStream(ServerWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public synchronized void reattach(ServerWebSocket webSocket) {
        this.webSocket = webSocket;
    }

    private void checkCommand(byte[] b, int off, int len) {
        if (len >= 2 && b[off] == 95 && b[off + 1] == 95) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.checkCommand(b, 0, b.length);
        this.bytes.write(b);
        this.scheduleSendTextFrame();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.checkCommand(b, 0, b.length);
        this.bytes.write(b, off, len);
        this.scheduleSendTextFrame();
    }

    @Override
    public synchronized void write(int b) {
        this.bytes.write(b);
        this.scheduleSendTextFrame();
    }

    @Override
    public synchronized void flush() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.call();
    }

    private void scheduleSendTextFrame() {
        if (this.future == null) {
            this.future = WebCLI.SCHEDULED_EXECUTOR.schedule(this, 10L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized Void call() {
        this.webSocket.writeTextMessage(this.bytes.toString(StandardCharsets.UTF_8));
        this.bytes.reset();
        this.future = null;
        return null;
    }

    public synchronized void writeSingleBinary(Buffer buffer) {
        this.flush();
        this.webSocket.writeBinaryMessage(buffer);
    }

    public synchronized void writeSingleText(String text) {
        this.flush();
        this.webSocket.writeTextMessage(text);
    }
}

