/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.webcli;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.clustering.webcli.WebCliContext;
import io.hyperfoil.controller.Client;
import io.vertx.core.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="report", description="Generate HTML report")
public class WebReport
extends BaseRunIdCommand {
    @Option(shortName=115, description="Other file (in given run) to use as report input.")
    protected String source;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Client.RunRef runRef = this.getRunRef(invocation);
        String report = new String(runRef.report(this.source), StandardCharsets.UTF_8);
        invocation.println("Creating report...");
        invocation.println("__HYPERFOIL_DIRECT_DOWNLOAD_MAGIC__");
        invocation.println(runRef.id() + ".html");
        ((WebCliContext)invocation.context()).sendBinaryMessage(Buffer.buffer((String)report));
        invocation.println("__HYPERFOIL_DIRECT_DOWNLOAD_END__");
        return CommandResult.SUCCESS;
    }
}

