/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.webcli;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.cli.commands.BaseEditCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.clustering.webcli.WebCliContext;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.impl.ProvidedBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;

@CommandDefinition(name="edit", description="Edit benchmark definition.")
public class WebEdit
extends BaseEditCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        CountDownLatch latch;
        String updatedName;
        Client.BenchmarkRef benchmarkRef = this.ensureBenchmark(invocation);
        Client.BenchmarkSource source = this.ensureSource(invocation, benchmarkRef);
        WebCliContext context = (WebCliContext)invocation.context();
        HashMap<String, byte[]> extraData = new HashMap<String, byte[]>();
        if (this.extraFiles != null) {
            for (String extraFile : this.extraFiles) {
                try {
                    extraData.put(extraFile, context.loadFile(invocation, extraFile));
                }
                catch (InterruptedException e) {
                    invocation.println("Benchmark upload cancelled.");
                    return CommandResult.FAILURE;
                }
            }
        }
        ProvidedBenchmarkData filesData = new ProvidedBenchmarkData(extraData);
        String updatedSource = source.source;
        while (true) {
            if ((updatedSource = this.edit(invocation, context, benchmarkRef, updatedSource)) == null) {
                return CommandResult.FAILURE;
            }
            try {
                String benchmark;
                BenchmarkSource newSource = BenchmarkParser.instance().createSource(updatedSource, (BenchmarkData)filesData);
                updatedName = newSource.name;
                if (newSource.isTemplate()) break;
                while (true) {
                    try {
                        benchmark = BenchmarkParser.instance().buildBenchmark(newSource, Collections.emptyMap());
                        break;
                    }
                    catch (BenchmarkData.MissingFileException e) {
                        try {
                            if (source.files.contains(BenchmarkData.sanitize((String)e.file))) {
                                invocation.print("Re-upload file " + e.file + "? [y/N] ");
                                switch (invocation.inputLine().trim().toLowerCase()) {
                                    case "y": 
                                    case "yes": {
                                        filesData.files.put(e.file, context.loadFile(invocation, e.file));
                                        break;
                                    }
                                    default: {
                                        filesData.ignoredFiles.add(e.file);
                                        break;
                                    }
                                }
                                continue;
                            }
                            filesData.files.put(e.file, context.loadFile(invocation, e.file));
                        }
                        catch (InterruptedException interruptedException) {
                            invocation.println("Edits cancelled.");
                            return CommandResult.FAILURE;
                        }
                    }
                }
                try {
                    Util.serialize((Benchmark)benchmark);
                }
                catch (IOException e) {
                    invocation.error("Benchmark is not serializable.", (Throwable)e);
                    return CommandResult.FAILURE;
                }
            }
            catch (BenchmarkDefinitionException | ParserException e) {
                invocation.error(e);
                invocation.print("Retry edits? [Y/n] ");
                try {
                    switch (invocation.inputLine().trim().toLowerCase()) {
                        case "n": 
                        case "no": {
                            return CommandResult.FAILURE;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    invocation.println("Edits cancelled.");
                    return CommandResult.FAILURE;
                }
                filesData = new ProvidedBenchmarkData(extraData);
                continue;
            }
            break;
        }
        String prevVersion = source.version;
        if (!updatedName.equals(benchmarkRef.name())) {
            invocation.println("NOTE: Renamed benchmark " + benchmarkRef.name() + " to " + updatedName + "; old benchmark won't be deleted.");
            prevVersion = null;
        }
        WebCliContext webCliContext = context;
        synchronized (webCliContext) {
            latch = context.latch = new CountDownLatch(1);
        }
        invocation.println("__HYPERFOIL_BENCHMARK_FILE_LIST__");
        invocation.println(this.benchmark);
        invocation.println(prevVersion == null ? "" : prevVersion);
        for (String file : filesData.files.keySet()) {
            invocation.println(file);
        }
        invocation.println("__HYPERFOIL_BENCHMARK_END_OF_FILES__");
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        context.latch = null;
        return CommandResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String edit(HyperfoilCommandInvocation invocation, WebCliContext context, Client.BenchmarkRef benchmarkRef, String source) {
        CountDownLatch latch;
        WebCliContext webCliContext = context;
        synchronized (webCliContext) {
            latch = context.latch = new CountDownLatch(1);
        }
        invocation.println("__HYPERFOIL_EDIT_MAGIC__" + benchmarkRef.name());
        invocation.println(source);
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        webCliContext = context;
        synchronized (webCliContext) {
            context.latch = null;
            if (context.editBenchmark == null) {
                invocation.println("Edits cancelled.");
                return null;
            }
            source = context.editBenchmark.toString();
            context.editBenchmark = null;
        }
        return source;
    }
}

