/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.webcli;

import io.hyperfoil.cli.Pager;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.clustering.webcli.WebPager;
import io.hyperfoil.clustering.webcli.WebsocketOutputStream;
import io.hyperfoil.controller.model.Run;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ServerWebSocket;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aesh.AeshConsoleRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WebCliContext
extends HyperfoilCliContext {
    private static final Logger log = LogManager.getLogger(WebCliContext.class);
    final String sessionId;
    final OutputStreamWriter inputStream;
    final WebsocketOutputStream outputStream;
    ScheduledFuture<?> runCompletionFuture;
    ServerWebSocket webSocket;
    AeshConsoleRunner runner;
    CountDownLatch latch;
    StringBuilder editBenchmark;
    String uploadUrl;
    int binaryLength;
    ByteArrayOutputStream binaryContent;
    String prevId = null;
    String notifiedId = null;

    WebCliContext(Vertx vertx, OutputStreamWriter inputStream, WebsocketOutputStream outputStream, ServerWebSocket webSocket) {
        super(vertx, true);
        this.sessionId = webSocket.query();
        this.inputStream = inputStream;
        this.webSocket = webSocket;
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] loadFile(HyperfoilCommandInvocation invocation, String file) throws InterruptedException {
        CountDownLatch latch;
        WebCliContext webCliContext = this;
        synchronized (webCliContext) {
            latch = this.latch = new CountDownLatch(1);
        }
        invocation.println("__HYPERFOIL_LOAD_FILE__" + file);
        latch.await();
        webCliContext = this;
        synchronized (webCliContext) {
            this.latch = null;
            if (this.binaryContent == null) {
                throw new InterruptedException();
            }
            byte[] bytes = this.binaryContent.toByteArray();
            this.binaryContent = null;
            invocation.println("File " + file + " uploaded.");
            return bytes;
        }
    }

    public void reattach(ServerWebSocket webSocket) {
        this.webSocket = webSocket;
        this.outputStream.reattach(webSocket);
    }

    public String interruptKey() {
        return "Escape";
    }

    public synchronized Pager createPager(String pager) {
        this.latch = new CountDownLatch(1);
        return new WebPager();
    }

    public void sendBinaryMessage(Buffer buffer) {
        this.outputStream.writeSingleBinary(buffer);
    }

    void startNotifications() {
        if (this.runCompletionFuture != null) {
            this.runCompletionFuture.cancel(false);
        }
        this.runCompletionFuture = this.executor().scheduleAtFixedRate(this::checkRunCompletion, 0L, 15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRunCompletion() {
        RestClient client = this.client();
        if (client == null) {
            return;
        }
        Run current = client.run("last").get();
        String fetchRun = null;
        WebCliContext webCliContext = this;
        synchronized (webCliContext) {
            if (this.notifiedId == null) {
                this.prevId = this.notifiedId = current.id;
                return;
            }
            if (current.completed && this.notifiedId.compareTo(current.id) < 0) {
                this.notifyRunCompleted(current);
            } else if (!this.prevId.equals(current.id) && this.notifiedId.compareTo(this.prevId) < 0) {
                fetchRun = this.prevId;
            }
        }
        this.prevId = current.id;
        if (fetchRun != null) {
            this.notifyRunCompleted(client.run(fetchRun).get());
        }
    }

    public synchronized void notifyRunCompleted(Run run) {
        if (this.notifiedId != null && this.notifiedId.compareTo(run.id) >= 0) {
            return;
        }
        this.notifiedId = run.id;
        StringBuilder sb = new StringBuilder("__HYPERFOIL_NOTIFICATION__");
        sb.append("Run ").append(run.id).append(" (").append(run.benchmark).append(") has finished").append('\n');
        if (run.cancelled) {
            sb.append("The run was cancelled.\n");
        }
        if (run.started != null && run.terminated != null) {
            String prettyDuration = Duration.between(run.started.toInstant(), run.terminated.toInstant()).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
            sb.append("Total duration: ").append(prettyDuration).append('\n');
        }
        if (run.errors != null && !run.errors.isEmpty()) {
            sb.append("Errors (").append(run.errors.size()).append("):\n");
            run.errors.stream().limit(10L).forEach(e -> sb.append((String)e).append('\n'));
            if (run.errors.size() > 10) {
                sb.append("... (further errors omitted)");
            }
        }
        this.outputStream.writeSingleText(sb.toString());
    }
}

