/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.util;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.clustering.util.PersistedBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class PersistenceUtil {
    private static final Logger log = LogManager.getLogger(PersistenceUtil.class);

    public static void store(BenchmarkSource source, Path dir) {
        if (!dir.toFile().exists() && !dir.toFile().mkdirs()) {
            log.error("Failed to create directory {}", (Object)dir);
        }
        String name = BenchmarkData.sanitize((String)source.name);
        Path path = dir.resolve(name + ".yaml");
        try {
            Files.write(path, source.yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            log.info("Stored benchmark '{}' in {}", (Object)source.name, (Object)path);
        }
        catch (IOException e) {
            log.error((Message)new FormattedMessage("Failed to persist benchmark {} to {}", (Object)source.name, (Object)path), (Throwable)e);
        }
        Path dataDirPath = dir.resolve(name + ".data");
        File dataDir = dataDirPath.toFile();
        Map files = source.data.files();
        if (dataDir.exists()) {
            if (!(dataDir.isDirectory() || dataDir.delete() && dataDir.mkdir())) {
                log.error("Couldn't delete/create data dir {}", (Object)dataDir);
                return;
            }
            for (File file : dataDir.listFiles()) {
                if (!file.delete()) continue;
                log.warn("Could not delete old file {}", (Object)file);
            }
            if (files.isEmpty()) {
                dataDir.delete();
            }
        } else if (!(dataDir.exists() || files.isEmpty() || dataDir.mkdir())) {
            log.error("Couldn't create data dir {}", (Object)dataDir);
            return;
        }
        try {
            PersistedBenchmarkData.store(files, dataDirPath);
        }
        catch (IOException e) {
            log.error("Couldn't persist files for benchmark " + source.name, (Throwable)e);
        }
    }

    public static BenchmarkSource load(Path file) {
        String filename = file.getFileName().toString();
        if (filename.endsWith(".yaml")) {
            BenchmarkData data = BenchmarkData.EMPTY;
            String dataDirName = filename.substring(0, filename.length() - 5) + ".data";
            Path dataDirPath = file.getParent().resolve(dataDirName);
            File dataDir = dataDirPath.toFile();
            if (dataDir.exists()) {
                if (dataDir.isDirectory()) {
                    data = new PersistedBenchmarkData(dataDirPath);
                } else {
                    log.error("Expected data dir {} to be a directory!", (Object)dataDirName);
                }
            }
            try {
                BenchmarkSource source = BenchmarkParser.instance().createSource(Files.readString(file), data);
                log.info("Loaded benchmark from {}", (Object)file);
                return source;
            }
            catch (IOException e) {
                log.error("Cannot read file " + String.valueOf(file), (Throwable)e);
            }
            catch (ParserException e) {
                log.error("Cannot parse file " + String.valueOf(file), (Throwable)e);
            }
        } else if (filename.endsWith(".serialized")) {
            log.debug("Serialized benchmarks are not used anymore, ignoring {}", (Object)filename);
        } else if (file.toFile().isDirectory() && filename.endsWith(".data")) {
            log.debug("Ignoring directory {}", (Object)filename);
        } else {
            log.warn("Unknown benchmark file format: {}", (Object)file);
        }
        return null;
    }

    public static boolean delete(String name, Path dir) {
        File dataDir;
        if (dir.resolve((name = BenchmarkData.sanitize((String)name)) + ".yaml").toFile().delete()) {
            log.debug("Benchmark YAML was deleted");
        }
        if (dir.resolve(name + ".serialized").toFile().delete()) {
            log.debug("Serialized benchmark was deleted");
        }
        if ((dataDir = dir.resolve(name + ".data").toFile()).exists()) {
            if (dataDir.isDirectory()) {
                for (File file : dataDir.listFiles()) {
                    if (file.delete()) continue;
                    log.warn("Could not delete file {}", (Object)file);
                    return false;
                }
            }
            if (!dataDir.delete()) {
                log.error("Couldn't delete/create data dir {}", (Object)dataDir);
                return false;
            }
        }
        return true;
    }
}

