/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.messages;

import io.hyperfoil.api.session.GlobalData;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.clustering.messages.AgentStatusMessage;
import io.hyperfoil.clustering.messages.ObjectCodec;
import io.hyperfoil.impl.Util;
import java.util.Map;

public class PhaseChangeMessage
extends AgentStatusMessage {
    private final String phase;
    private final PhaseInstance.Status status;
    private final boolean sessionLimitExceeded;
    private final String cpuUsage;
    private final Throwable error;
    private final Map<String, GlobalData.Element> globalData;

    public PhaseChangeMessage(String senderId, String runId, String phase, PhaseInstance.Status status, boolean sessionLimitExceeded, String cpuUsage, Throwable error, Map<String, GlobalData.Element> globalData) {
        super(senderId, runId);
        this.phase = phase;
        this.status = status;
        this.sessionLimitExceeded = sessionLimitExceeded;
        this.cpuUsage = cpuUsage;
        this.error = error;
        this.globalData = globalData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PhaseChangeMessage{");
        sb.append("senderId='").append(this.senderId).append('\'');
        sb.append(", phase=").append(this.phase);
        sb.append(", status=").append(this.status);
        sb.append(", cpuUsage=").append(this.cpuUsage);
        sb.append(", error=").append(Util.explainCauses((Throwable)this.error));
        sb.append(", globalData=").append(this.globalData);
        sb.append('}');
        return sb.toString();
    }

    public String phase() {
        return this.phase;
    }

    public PhaseInstance.Status status() {
        return this.status;
    }

    public boolean sessionLimitExceeded() {
        return this.sessionLimitExceeded;
    }

    public Throwable getError() {
        return this.error;
    }

    public String cpuUsage() {
        return this.cpuUsage;
    }

    public Map<String, GlobalData.Element> globalData() {
        return this.globalData;
    }

    public static class Codec
    extends ObjectCodec<PhaseChangeMessage> {
    }
}

