/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.clustering.OutputStreamAdapter;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.streams.WriteStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Zipper {
    private static final Logger log = LogManager.getLogger(Zipper.class);
    private final HttpServerResponse response;
    private final ZipOutputStream zipStream;
    private final Queue<File> files = new LinkedList<File>();
    private final Path dir;

    public Zipper(HttpServerResponse response, Path dir) {
        this.response = response;
        this.zipStream = new ZipOutputStream(new OutputStreamAdapter((WriteStream<Buffer>)response));
        this.dir = dir;
        this.files.addAll(Arrays.asList(dir.toFile().listFiles()));
        response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/zip");
        response.setChunked(true);
        response.drainHandler(nil -> this.run());
    }

    public void run() {
        if (this.response.closed()) {
            return;
        }
        while (!this.response.writeQueueFull()) {
            File file = this.files.poll();
            if (file == null) {
                try {
                    this.zipStream.close();
                }
                catch (IOException e) {
                    log.error("Failed closing zip stream", (Throwable)e);
                    return;
                }
                finally {
                    this.response.end();
                }
            }
            if (file.isDirectory()) {
                this.files.addAll(Arrays.asList(file.listFiles()));
                continue;
            }
            Path path = file.toPath();
            try {
                this.zipStream.putNextEntry(new ZipEntry(this.dir.relativize(path).toString()));
                this.zipStream.write(Files.readAllBytes(path));
                this.zipStream.closeEntry();
            }
            catch (IOException e) {
                log.error("Failed writing file {}", (Object)path, (Object)e);
                this.response.end();
                return;
            }
        }
    }
}

