/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.GlobalData;
import io.hyperfoil.clustering.AgentInfo;
import io.hyperfoil.clustering.ControllerPhase;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.impl.Util;
import io.vertx.core.Promise;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

class Run {
    final String id;
    final Path dir;
    Benchmark benchmark;
    final Map<String, ControllerPhase> phases = new HashMap<String, ControllerPhase>();
    final List<AgentInfo> agents = new ArrayList<AgentInfo>();
    final Phase[] phasesById;
    final List<Error> errors = new ArrayList<Error>();
    final List<RunHookOutput> hookResults = new ArrayList<RunHookOutput>();
    long deployTimerId;
    String description;
    long startTime = Long.MIN_VALUE;
    Promise<Long> terminateTime = Promise.promise();
    boolean cancelled;
    boolean completed;
    boolean persisted;
    Supplier<StatisticsStore> statsSupplier;
    private StatisticsStore statisticsStore;
    Map<String, GlobalData.Element> newGlobalData = new HashMap<String, GlobalData.Element>();

    Run(String id, Path dir, Benchmark benchmark) {
        this.id = id;
        this.dir = dir;
        this.benchmark = benchmark;
        this.phasesById = benchmark.phasesById();
    }

    void initStore(StatisticsStore store) {
        this.statisticsStore = store;
    }

    long nextTimestamp() {
        long nextPhaseStart = this.phases.values().stream().filter(phase -> phase.status() == ControllerPhase.Status.NOT_STARTED && phase.definition().startTime() >= 0L).mapToLong(phase -> this.startTime + phase.definition().startTime()).min().orElse(Long.MAX_VALUE);
        long nextPhaseFinish = this.phases.values().stream().filter(phase -> phase.status() == ControllerPhase.Status.RUNNING).mapToLong(phase -> phase.absoluteStartTime() + phase.definition().duration()).min().orElse(Long.MAX_VALUE);
        long nextPhaseTerminate = this.phases.values().stream().filter(phase -> (phase.status() == ControllerPhase.Status.RUNNING || phase.status() == ControllerPhase.Status.FINISHED) && phase.definition().maxDuration() >= 0L).mapToLong(phase -> phase.absoluteStartTime() + phase.definition().maxDuration()).min().orElse(Long.MAX_VALUE);
        return Math.min(Math.min(nextPhaseStart, nextPhaseFinish), nextPhaseTerminate);
    }

    ControllerPhase[] getAvailablePhases() {
        return (ControllerPhase[])this.phases.values().stream().filter(phase -> phase.status() == ControllerPhase.Status.NOT_STARTED && this.startTime + phase.definition().startTime() <= System.currentTimeMillis() && phase.definition().startAfter().stream().allMatch(dep -> this.phases.get(dep).status().isFinished()) && phase.definition().startAfterStrict().stream().allMatch(dep -> this.phases.get(dep).status().isTerminated()) && (phase.definition().startWithDelay() == null || this.phases.get(phase.definition().startWithDelay().phase).status().isStarted() && this.phases.get(phase.definition().startWithDelay().phase).absoluteStartTime() + phase.definition().startWithDelay().delay <= System.currentTimeMillis())).toArray(ControllerPhase[]::new);
    }

    public String phase(int phaseId) {
        if (phaseId < this.phasesById.length) {
            return this.phasesById[phaseId].name();
        }
        return null;
    }

    public StatisticsStore statisticsStore() {
        if (this.statisticsStore != null) {
            return this.statisticsStore;
        }
        if (this.statsSupplier != null) {
            this.statisticsStore = this.statsSupplier.get();
            return this.statisticsStore;
        }
        return null;
    }

    public boolean isLoaded() {
        return this.statisticsStore != null;
    }

    public void unload() {
        this.statisticsStore = null;
    }

    public static class RunHookOutput {
        public final String name;
        public final String output;

        RunHookOutput(String name, String output) {
            this.name = name;
            this.output = output;
        }
    }

    public static class Error {
        public final AgentInfo agent;
        public final Throwable error;

        Error(AgentInfo agent, Throwable error) {
            this.agent = agent;
            this.error = error;
        }

        public String toString() {
            return (String)(this.agent == null ? "" : this.agent.name + ": ") + Util.explainCauses((Throwable)this.error);
        }
    }
}

