/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.clustering.messages.PhaseStatsCompleteMessage;
import io.hyperfoil.clustering.messages.RequestStatsMessage;
import io.hyperfoil.core.impl.statistics.StatisticsCollector;
import io.hyperfoil.core.util.CountDown;
import io.vertx.core.eventbus.EventBus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestStatsSender
extends StatisticsCollector {
    private static final Logger log = LogManager.getLogger(RequestStatsSender.class);
    private final String address;
    private final String runId;
    private final EventBus eb;
    private final StatisticsCollector.StatisticsConsumer sendStats = this::sendStats;

    public RequestStatsSender(Benchmark benchmark, EventBus eb, String address, String runId) {
        super(benchmark);
        this.eb = eb;
        this.address = address;
        this.runId = runId;
    }

    public void send(CountDown completion) {
        this.visitStatistics(this.sendStats, completion);
    }

    private void sendStats(Phase phase, int stepId, String metric, StatisticsSnapshot statistics, CountDown countDown) {
        if (statistics.histogram.getEndTimeStamp() >= statistics.histogram.getStartTimeStamp()) {
            log.debug("Sending stats for {} {}/{}, id {}: {} requests, {} responses", (Object)phase.name(), (Object)stepId, (Object)metric, (Object)statistics.sequenceId, (Object)statistics.requestCount, (Object)statistics.responseCount);
            StatisticsSnapshot copy = statistics.clone();
            countDown.increment();
            this.eb.request("stats-feed", (Object)new RequestStatsMessage(this.address, this.runId, phase.id(), stepId, metric, copy), reply -> countDown.countDown());
        }
    }

    public void sendPhaseComplete(Phase phase, CountDown countDown) {
        Phase[] phaseArray = this.aggregated.keySet().iterator();
        while (phaseArray.hasNext()) {
            int phaseAndStepId = (Integer)phaseArray.next();
            if (phase != null && phase != this.phases[phaseAndStepId >> 16]) continue;
            countDown.increment();
            this.eb.request("stats-feed", (Object)new RequestStatsMessage(this.address, this.runId, phaseAndStepId >> 16, -1, null, null), reply -> countDown.countDown());
        }
        if (phase == null) {
            for (Phase p : this.phases) {
                this.eb.request("stats-feed", (Object)new PhaseStatsCompleteMessage(this.address, this.runId, p.name()));
            }
        } else {
            this.eb.request("stats-feed", (Object)new PhaseStatsCompleteMessage(this.address, this.runId, phase.name()));
        }
    }
}

