/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.RunHook;
import io.hyperfoil.api.config.SessionLimitPolicy;
import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.Deployer;
import io.hyperfoil.api.session.GlobalData;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.clustering.AgentInfo;
import io.hyperfoil.clustering.AgentVerticle;
import io.hyperfoil.clustering.ControllerPhase;
import io.hyperfoil.clustering.ControllerServer;
import io.hyperfoil.clustering.Run;
import io.hyperfoil.clustering.VersionConflictException;
import io.hyperfoil.clustering.messages.AgentControlMessage;
import io.hyperfoil.clustering.messages.AgentHello;
import io.hyperfoil.clustering.messages.AgentReadyMessage;
import io.hyperfoil.clustering.messages.AgentStatusMessage;
import io.hyperfoil.clustering.messages.AuxiliaryHello;
import io.hyperfoil.clustering.messages.ConnectionStatsMessage;
import io.hyperfoil.clustering.messages.DelayStatsCompletionMessage;
import io.hyperfoil.clustering.messages.ErrorMessage;
import io.hyperfoil.clustering.messages.PhaseChangeMessage;
import io.hyperfoil.clustering.messages.PhaseControlMessage;
import io.hyperfoil.clustering.messages.PhaseStatsCompleteMessage;
import io.hyperfoil.clustering.messages.RequestStatsMessage;
import io.hyperfoil.clustering.messages.SessionStatsMessage;
import io.hyperfoil.clustering.messages.StatsMessage;
import io.hyperfoil.clustering.util.PersistenceUtil;
import io.hyperfoil.controller.CsvWriter;
import io.hyperfoil.controller.JsonLoader;
import io.hyperfoil.controller.JsonWriter;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.core.hooks.ExecRunHook;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.util.CountDown;
import io.hyperfoil.core.util.LowHigh;
import io.hyperfoil.internal.Controller;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infinispan.commons.api.BasicCacheContainer;

public class ControllerVerticle
extends AbstractVerticle
implements NodeListener {
    private static final Logger log = LogManager.getLogger(ControllerVerticle.class);
    private static final int MAX_IN_MEMORY_RUNS = Properties.getInt((String)"io.hyperfoil.max.in.memory.runs", (int)20);
    static final String DEFAULT_STATS_JSON = "all.json";
    private EventBus eb;
    private ControllerServer server;
    private Deployer deployer;
    private final AtomicInteger runIds = new AtomicInteger();
    private final Map<String, Benchmark> benchmarks = new HashMap<String, Benchmark>();
    private final Map<String, BenchmarkSource> templates = new HashMap<String, BenchmarkSource>();
    private long timerId = -1L;
    Map<String, Run> runs = new HashMap<String, Run>();

    public void start(Promise<Void> future) {
        log.info("Starting in directory {}...", (Object)Controller.ROOT_DIR);
        CountDown startCountDown = new CountDown(future, 2);
        this.server = new ControllerServer(this, startCountDown);
        this.vertx.exceptionHandler(throwable -> log.error("Uncaught error: ", throwable));
        if (Files.exists(Controller.RUN_DIR, new LinkOption[0])) {
            try {
                Files.list(Controller.RUN_DIR).forEach(this::updateRuns);
            }
            catch (IOException e) {
                log.error("Could not list run dir contents", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Cannot load previous runs from {}", (Object)Controller.RUN_DIR, (Object)e);
            }
        }
        Controller.HOOKS_DIR.resolve("pre").toFile().mkdirs();
        Controller.HOOKS_DIR.resolve("post").toFile().mkdirs();
        this.eb = this.vertx.eventBus();
        this.eb.consumer("discovery-feed", message -> {
            if (message.body() instanceof AgentHello) {
                this.handleAgentHello((Message<Object>)message, (AgentHello)message.body());
            } else if (message.body() instanceof AuxiliaryHello) {
                AuxiliaryHello hello = (AuxiliaryHello)message.body();
                log.info("Noticed auxiliary {} (node {}, {})", (Object)hello.name(), (Object)hello.nodeId(), (Object)hello.deploymentId());
                String nodeId = ((VertxInternal)this.vertx).getClusterManager().getNodeId();
                message.reply((Object)nodeId);
            } else {
                log.error("Unknown message on discovery feed! {}", message.body());
            }
        });
        this.eb.consumer("response-feed", message -> {
            AgentStatusMessage msg = (AgentStatusMessage)message.body();
            Run run = this.runs.get(msg.runId());
            if (run == null) {
                log.error("No run {}", (Object)msg.runId());
                return;
            }
            AgentInfo agent = run.agents.stream().filter(a -> a.deploymentId.equals(msg.senderId())).findAny().orElse(null);
            if (agent == null) {
                log.error("No agent {} in run {}", (Object)msg.senderId(), (Object)run.id);
                return;
            }
            if (msg instanceof PhaseChangeMessage) {
                this.handlePhaseChange(run, agent, (PhaseChangeMessage)msg);
            } else if (msg instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)msg;
                run.errors.add(new Run.Error(agent, errorMessage.error()));
                if (errorMessage.isFatal()) {
                    agent.status = AgentInfo.Status.FAILED;
                    this.stopSimulation(run);
                }
            } else if (msg instanceof AgentReadyMessage) {
                agent.status = AgentInfo.Status.READY;
                if (run.agents.stream().allMatch(a -> a.status == AgentInfo.Status.READY)) {
                    this.startSimulation(run);
                }
            } else {
                log.error("Unexpected type of message: {}", (Object)msg);
            }
        });
        this.eb.consumer("stats-feed", message -> {
            if (!(message.body() instanceof StatsMessage)) {
                log.error("Unknown message type: {}", message.body());
                return;
            }
            StatsMessage statsMessage = (StatsMessage)message.body();
            Run run = this.runs.get(statsMessage.runId);
            if (run != null) {
                String agentName = run.agents.stream().filter(ai -> ai.deploymentId.equals(statsMessage.address)).map(ai -> ai.name).findFirst().orElse("<unknown>");
                if (statsMessage instanceof RequestStatsMessage) {
                    RequestStatsMessage rsm = (RequestStatsMessage)statsMessage;
                    String phase = run.phase(rsm.phaseId);
                    if (rsm.statistics != null) {
                        log.debug("Run {}: Received stats from {}({}): {}/{}/{}:{} ({} requests)", (Object)rsm.runId, (Object)agentName, (Object)rsm.address, (Object)phase, (Object)rsm.stepId, (Object)rsm.metric, (Object)rsm.statistics.sequenceId, (Object)rsm.statistics.requestCount);
                        boolean added = run.statisticsStore().record(agentName, rsm.phaseId, rsm.stepId, rsm.metric, rsm.statistics);
                        if (!added) {
                            String errorMessage = String.format("Received statistics for %s/%d/%s:%d with %d requests but the statistics are already completed; these statistics won't be reported.", phase, rsm.stepId, rsm.metric, rsm.statistics.sequenceId, rsm.statistics.requestCount);
                            run.errors.add(new Run.Error(null, (Throwable)new BenchmarkExecutionException(errorMessage)));
                        }
                    }
                } else if (statsMessage instanceof PhaseStatsCompleteMessage) {
                    PhaseStatsCompleteMessage pscm = (PhaseStatsCompleteMessage)statsMessage;
                    log.debug("Run {}: Received stats completion for phase {} from {}", (Object)run.id, (Object)pscm.phase, (Object)pscm.address);
                    AgentInfo agent = run.agents.stream().filter(a -> a.deploymentId.equals(pscm.address)).findFirst().orElse(null);
                    if (agent == null) {
                        log.error("Run {}: Cannot find agent {}", (Object)run.id, (Object)pscm.address);
                    } else {
                        PhaseInstance.Status prevStatus = agent.phases.put(pscm.phase, PhaseInstance.Status.STATS_COMPLETE);
                        if (prevStatus == PhaseInstance.Status.STATS_COMPLETE) {
                            log.info("Run {}: stats for phase {} are already completed, ignoring.", (Object)run.id, (Object)pscm.phase);
                        } else if (run.agents.stream().map(a -> a.phases.get(pscm.phase)).allMatch(s -> s == PhaseInstance.Status.STATS_COMPLETE)) {
                            ControllerPhase controllerPhase = run.phases.get(pscm.phase);
                            if (controllerPhase != null) {
                                this.tryCompletePhase(run, pscm.phase, controllerPhase);
                            } else {
                                log.error("Run {}: Cannot find phase {}!", (Object)run.id, (Object)pscm.phase);
                            }
                        }
                    }
                } else if (statsMessage instanceof SessionStatsMessage) {
                    SessionStatsMessage sessionStatsMessage = (SessionStatsMessage)statsMessage;
                    log.trace("Run {}: Received session pool stats from {}", (Object)sessionStatsMessage.runId, (Object)sessionStatsMessage.address);
                    for (Map.Entry<String, LowHigh> entry : sessionStatsMessage.sessionStats.entrySet()) {
                        run.statisticsStore().recordSessionStats(agentName, sessionStatsMessage.timestamp, entry.getKey(), entry.getValue().low, entry.getValue().high);
                    }
                } else if (statsMessage instanceof ConnectionStatsMessage) {
                    ConnectionStatsMessage connectionStatsMessage = (ConnectionStatsMessage)statsMessage;
                    log.trace("Run {}: Received connection stats from {}", (Object)connectionStatsMessage.runId, (Object)connectionStatsMessage.address);
                    run.statisticsStore().recordConnectionStats(agentName, connectionStatsMessage.timestamp, connectionStatsMessage.stats);
                } else if (statsMessage instanceof DelayStatsCompletionMessage) {
                    DelayStatsCompletionMessage delayStatsCompletionMessage = (DelayStatsCompletionMessage)statsMessage;
                    String phase = run.phase(delayStatsCompletionMessage.phaseId);
                    log.trace("Run {}: Received request for extension from {} for phase {} by {} ms", (Object)delayStatsCompletionMessage.runId, (Object)delayStatsCompletionMessage.address, (Object)phase, (Object)delayStatsCompletionMessage.delay);
                    ControllerPhase controllerPhase = run.phases.get(phase);
                    controllerPhase.delayStatsCompletionUntil(System.currentTimeMillis() + delayStatsCompletionMessage.delay);
                }
            } else {
                log.error("Unknown run {}", (Object)statsMessage.runId);
            }
            message.reply((Object)"OK");
        });
        if (this.vertx.isClustered()) {
            for (Deployer.Factory deployerFactory : ServiceLoader.load(Deployer.Factory.class)) {
                log.debug("Found deployer {}", (Object)deployerFactory.name());
                if (!Controller.DEPLOYER.equals(deployerFactory.name())) continue;
                this.deployer = deployerFactory.create();
                break;
            }
            if (this.deployer == null) {
                throw new IllegalStateException("Hyperfoil is running in clustered mode but it couldn't load deployer '" + Controller.DEPLOYER + "'");
            }
            if (this.vertx instanceof VertxInternal) {
                ClusterManager clusterManager = ((VertxInternal)this.vertx).getClusterManager();
                clusterManager.nodeListener((NodeListener)this);
            }
        }
        if (!Controller.BENCHMARK_DIR.toFile().exists() && !Controller.BENCHMARK_DIR.toFile().mkdirs()) {
            log.error("Failed to create benchmark directory: {}", (Object)Controller.BENCHMARK_DIR);
        }
        startCountDown.increment();
        this.loadBenchmarks((Handler<AsyncResult<Void>>)startCountDown);
        startCountDown.countDown();
    }

    private void tryCompletePhase(Run run, String phase, ControllerPhase controllerPhase) {
        long delay;
        long l = delay = controllerPhase.delayStatsCompletionUntil() == null ? -1L : controllerPhase.delayStatsCompletionUntil() - System.currentTimeMillis();
        if (delay <= 0L) {
            log.info("Run {}: completing stats for phase {}", (Object)run.id, (Object)phase);
            run.statisticsStore().completePhase(phase);
            if (!run.statisticsStore().validateSlas()) {
                log.info("SLA validation failed for {}", (Object)phase);
                controllerPhase.setFailed();
                if (run.benchmark.failurePolicy() == Benchmark.FailurePolicy.CANCEL) {
                    this.failNotStartedPhases(run, controllerPhase);
                }
            }
        } else {
            log.info("Run {}: all agents completed stats for phase {} but delaying for {} ms", (Object)run.id, (Object)phase, (Object)delay);
            this.vertx.setTimer(delay, ignored -> this.tryCompletePhase(run, phase, controllerPhase));
        }
    }

    private void handleAgentHello(Message<Object> message, AgentHello hello) {
        String runId = hello.runId();
        Run run = this.runs.get(runId);
        if (run == null) {
            log.error("Unknown run ID {}", (Object)runId);
            message.fail(1, "Unknown run ID");
            return;
        }
        AgentInfo agentInfo = run.agents.stream().filter(a -> a.name.equals(hello.name())).findAny().orElse(null);
        if (agentInfo == null) {
            log.error("Unknown agent {} ({}/{})", (Object)hello.name(), (Object)hello.nodeId(), (Object)hello.deploymentId());
            message.fail(1, "Unknown agent");
            return;
        }
        if (agentInfo.status != AgentInfo.Status.STARTING) {
            log.info("Ignoring message, {} is not starting", (Object)agentInfo.name);
            message.reply((Object)"Ignoring");
            return;
        }
        log.debug("Registering agent {} ({}/{})", (Object)hello.name(), (Object)hello.nodeId(), (Object)hello.deploymentId());
        agentInfo.nodeId = hello.nodeId();
        agentInfo.deploymentId = hello.deploymentId();
        agentInfo.status = AgentInfo.Status.REGISTERED;
        message.reply((Object)"Registered");
        if (run.agents.stream().allMatch(a -> a.status != AgentInfo.Status.STARTING)) {
            this.handleAgentsStarted(run);
        } else {
            log.debug("Waiting for registration from agents {}", run.agents.stream().filter(a -> a.status == AgentInfo.Status.STARTING).collect(Collectors.toList()));
        }
    }

    private void handlePhaseChange(Run run, AgentInfo agent, PhaseChangeMessage phaseChange) {
        String phase = phaseChange.phase();
        log.debug("{} Received phase change from {}: {} is {} (session limit exceeded={}, CPU usage={} errors={})", (Object)run.id, (Object)phaseChange.senderId(), (Object)phase, (Object)phaseChange.status(), (Object)phaseChange.sessionLimitExceeded(), (Object)phaseChange.cpuUsage(), (Object)phaseChange.getError());
        agent.phases.put(phase, phaseChange.status());
        ControllerPhase controllerPhase = run.phases.get(phase);
        if (phaseChange.cpuUsage() != null) {
            run.statisticsStore().recordCpuUsage(phaseChange.phase(), agent.name, phaseChange.cpuUsage());
        }
        if (phaseChange.sessionLimitExceeded()) {
            SessionLimitPolicy sessionLimitPolicy;
            Phase def = controllerPhase.definition();
            SessionLimitPolicy sessionLimitPolicy2 = sessionLimitPolicy = def.model instanceof Model.OpenModel ? ((Model.OpenModel)def.model).sessionLimitPolicy : null;
            if (sessionLimitPolicy == SessionLimitPolicy.CONTINUE) {
                log.warn("{} Phase {} session limit exceeded, continuing due to policy {}", (Object)run.id, (Object)def.name, (Object)sessionLimitPolicy);
            } else {
                run.statisticsStore().addFailure(def.name, null, controllerPhase.absoluteStartTime(), System.currentTimeMillis(), "Exceeded session limit");
                log.info("{} Failing phase due to exceeded session limit.", (Object)run.id);
                controllerPhase.setFailed();
            }
        }
        if (phaseChange.getError() != null) {
            log.error("{} Failing phase {} as agent {} reports error: {}", (Object)run.id, (Object)controllerPhase.definition().name, (Object)agent.name, (Object)phaseChange.getError().getMessage());
            controllerPhase.setFailed();
            run.errors.add(new Run.Error(agent, phaseChange.getError()));
        }
        controllerPhase.addGlobalData(phaseChange.globalData());
        this.tryProgressStatus(run, phase);
        this.runSimulation(run);
    }

    public void nodeAdded(String nodeID) {
    }

    public void nodeLeft(String nodeID) {
        block0: for (Run run : this.runs.values()) {
            if (run.terminateTime.future().isComplete()) continue;
            for (AgentInfo agent : run.agents) {
                if (!Objects.equals(agent.nodeId, nodeID)) continue;
                agent.status = AgentInfo.Status.FAILED;
                run.errors.add(new Run.Error(agent, (Throwable)new BenchmarkExecutionException("Agent unexpectedly left the cluster.")));
                this.kill(run, (Handler<AsyncResult<Void>>)((Handler)result -> {}));
                this.stopSimulation(run);
                continue block0;
            }
        }
    }

    private void updateRuns(Path runDir) {
        File file = runDir.toFile();
        if (!file.getName().matches("[0-9A-F][0-9A-F][0-9A-F][0-9A-F]")) {
            return;
        }
        String runId = file.getName();
        int id = Integer.parseInt(runId, 16);
        if (id >= this.runIds.get()) {
            this.runIds.set(id + 1);
        }
        Path infoFile = runDir.resolve("info.json");
        JsonObject info = new JsonObject();
        if (infoFile.toFile().exists() && infoFile.toFile().isFile()) {
            try {
                info = new JsonObject(Files.readString(infoFile));
            }
            catch (Exception e2) {
                log.error("Cannot read info for run {}", (Object)runId);
                return;
            }
        }
        String name = info.getString("benchmark", "<unknown>");
        JsonObject paramsObject = info.getJsonObject("params");
        Map templateParams = paramsObject == null ? Collections.emptyMap() : paramsObject.getMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> String.valueOf(entry.getValue())));
        Benchmark benchmark = Benchmark.empty((String)name, templateParams);
        Run run = new Run(runId, runDir, benchmark);
        run.statsSupplier = () -> this.loadStats(runDir.resolve(DEFAULT_STATS_JSON), benchmark);
        run.completed = true;
        run.startTime = info.getLong("startTime", Long.valueOf(0L));
        run.terminateTime.complete((Object)info.getLong("terminateTime", Long.valueOf(0L)));
        run.description = info.getString("description");
        JsonArray errors = info.getJsonArray("errors");
        if (errors != null) {
            run.errors.addAll(errors.stream().map(JsonObject.class::cast).map(e -> new Run.Error(new AgentInfo(e.getString("agent"), -1), new Throwable(e.getString("msg")))).collect(Collectors.toList()));
        }
        run.cancelled = info.getBoolean("cancelled", Boolean.FALSE);
        this.runs.put(runId, run);
    }

    private StatisticsStore loadStats(Path jsonPath, Benchmark benchmark) {
        File statsJson = jsonPath.toFile();
        if (!(statsJson.exists() && statsJson.isFile() && statsJson.canRead())) {
            log.error("Cannot load stats from {}", (Object)jsonPath);
            return null;
        }
        log.info("Loading stats from {}", (Object)jsonPath);
        StatisticsStore store = new StatisticsStore(benchmark, f -> {});
        try {
            JsonLoader.read(Files.readString(jsonPath, StandardCharsets.UTF_8), store);
        }
        catch (Exception e) {
            log.error("Cannot load stats from {}", (Object)jsonPath, (Object)e);
            return null;
        }
        return store;
    }

    public void stop(Promise<Void> stopFuture) throws Exception {
        if (this.deployer != null) {
            this.deployer.close();
        }
        this.server.stop(stopFuture);
    }

    private void tryProgressStatus(Run run, String phase) {
        PhaseInstance.Status minStatus = PhaseInstance.Status.TERMINATED;
        for (AgentInfo a : run.agents) {
            PhaseInstance.Status status = a.phases.get(phase);
            if (status == null) {
                return;
            }
            if (status.ordinal() >= minStatus.ordinal()) continue;
            minStatus = status;
        }
        ControllerPhase controllerPhase = run.phases.get(phase);
        if (controllerPhase == null) {
            log.error("Cannot find phase {} in run {}", (Object)phase, (Object)run.id);
            return;
        }
        switch (minStatus) {
            case RUNNING: {
                controllerPhase.status(run.id, ControllerPhase.Status.RUNNING);
                break;
            }
            case FINISHED: {
                controllerPhase.status(run.id, ControllerPhase.Status.FINISHED);
                break;
            }
            case TERMINATED: 
            case STATS_COMPLETE: {
                controllerPhase.status(run.id, ControllerPhase.Status.TERMINATED);
                controllerPhase.absoluteCompletionTime(System.currentTimeMillis());
                run.newGlobalData.putAll(run.phases.get(phase).completeGlobalData());
            }
        }
        if (controllerPhase.isFailed()) {
            this.failNotStartedPhases(run, controllerPhase);
        }
    }

    private void failNotStartedPhases(Run run, ControllerPhase controllerPhase) {
        log.info("Phase {} failed, cancelling other phases...", (Object)controllerPhase.definition().name());
        for (ControllerPhase p : run.phases.values()) {
            if (p.status() != ControllerPhase.Status.NOT_STARTED) continue;
            p.status(run.id, ControllerPhase.Status.CANCELLED);
        }
    }

    Run createRun(Benchmark benchmark, String description) {
        this.ensureMaxInMemoryRuns();
        String runId = String.format("%04X", this.runIds.getAndIncrement());
        Path runDir = Controller.RUN_DIR.resolve(runId);
        runDir.toFile().mkdirs();
        Run run = new Run(runId, runDir, benchmark);
        run.initStore(new StatisticsStore(benchmark, failure -> log.warn("Failed verify SLA(s) for {}/{}: {}", (Object)failure.phase(), (Object)failure.metric(), (Object)failure.message())));
        run.description = description;
        this.runs.put(run.id, run);
        if (run.benchmark.source() != null) {
            PersistenceUtil.store(run.benchmark.source(), run.dir);
        }
        return run;
    }

    private void ensureMaxInMemoryRuns() {
        List loadedRuns = this.runs.values().stream().filter(Run::isLoaded).sorted(Comparator.comparing(r -> r.id)).collect(Collectors.toList());
        if (loadedRuns.size() + 1 > MAX_IN_MEMORY_RUNS) {
            loadedRuns.stream().limit(loadedRuns.size() + 1 - MAX_IN_MEMORY_RUNS).forEach(r -> {
                log.info("Unloading run {}", (Object)r.id);
                r.unload();
                r.statsSupplier = () -> {
                    Path statsPath = Controller.RUN_DIR.resolve(r.id).resolve(DEFAULT_STATS_JSON);
                    return this.loadStats(statsPath, r.benchmark);
                };
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    String startBenchmark(Run run) {
        HashSet<String> activeAgents = new HashSet<String>();
        for (Run r : this.runs.values()) {
            if (r.terminateTime.future().isComplete()) continue;
            for (AgentInfo agentInfo : run.agents) {
                activeAgents.add(agentInfo.name);
            }
        }
        for (Agent agent : run.benchmark.agents()) {
            long currentTime;
            if (!activeAgents.contains(agent.name)) continue;
            run.startTime = currentTime = System.currentTimeMillis();
            run.terminateTime.complete((Object)currentTime);
            run.completed = true;
            return "Agent " + String.valueOf(agent) + " is already used; try starting the benchmark later";
        }
        if (run.benchmark.agents().length == 0) {
            if (this.vertx.isClustered()) {
                long currentTime;
                run.startTime = currentTime = System.currentTimeMillis();
                run.terminateTime.complete((Object)currentTime);
                run.completed = true;
                return "Server is started in clustered mode; benchmarks must define agents.";
            }
            run.agents.add(new AgentInfo("in-vm", 0));
            JsonObject config = new JsonObject().put("runId", (Object)run.id).put("name", (Object)"in-vm");
            this.vertx.deployVerticle(AgentVerticle.class, new DeploymentOptions().setConfig(config));
        } else {
            void var6_15;
            if (!this.vertx.isClustered()) {
                return "Server is not started as clustered and does not accept benchmarks with agents defined.";
            }
            log.info("Starting agents for run {}", (Object)run.id);
            int agentCounter = 0;
            Agent[] agentArray = run.benchmark.agents();
            int n = agentArray.length;
            boolean bl = false;
            while (var6_15 < n) {
                Agent agent = agentArray[var6_15];
                AgentInfo agentInfo = new AgentInfo(agent.name, agentCounter++);
                run.agents.add(agentInfo);
                log.debug("Starting agent {}", (Object)agent.name);
                this.vertx.executeBlocking(future -> {
                    agentInfo.deployedAgent = this.deployer.start(agent, run.id, run.benchmark, exception -> {
                        if (agentInfo.status.ordinal() < AgentInfo.Status.STOPPING.ordinal()) {
                            run.errors.add(new Run.Error(agentInfo, (Throwable)new BenchmarkExecutionException("Failed to deploy agent", exception)));
                            log.error("Failed to deploy agent {}", (Object)agent.name, exception);
                            this.vertx.runOnContext(nil -> this.stopSimulation(run));
                        }
                    });
                }, false, result -> {
                    if (result.failed()) {
                        run.errors.add(new Run.Error(agentInfo, (Throwable)new BenchmarkExecutionException("Failed to start agent", result.cause())));
                        log.error("Failed to start agent {}", (Object)agent.name, (Object)result.cause());
                        this.vertx.runOnContext(nil -> this.stopSimulation(run));
                    }
                });
                ++var6_15;
            }
        }
        run.deployTimerId = this.vertx.setTimer(Controller.DEPLOY_TIMEOUT, id -> {
            log.error("{} Deployment timed out.", (Object)run.id);
            run.errors.add(new Run.Error(null, (Throwable)new BenchmarkExecutionException("Deployment timed out.")));
            this.stopSimulation(run);
        });
        return null;
    }

    private void handleAgentsStarted(Run run) {
        this.vertx.cancelTimer(run.deployTimerId);
        log.info("Starting benchmark {} - run {}", (Object)run.benchmark.name(), (Object)run.id);
        for (AgentInfo agent : run.agents) {
            if (agent.status != AgentInfo.Status.REGISTERED) {
                log.error("{} Agent {}({}) already initializing, status is {}!", (Object)run.id, (Object)agent.name, (Object)agent.deploymentId, (Object)agent.status);
                continue;
            }
            this.eb.request(agent.deploymentId, (Object)new AgentControlMessage(AgentControlMessage.Command.INITIALIZE, agent.id, run.benchmark), reply -> {
                Throwable cause;
                if (reply.failed()) {
                    cause = reply.cause();
                    log.error("{} Agent {}({}) failed to initialize", (Object)run.id, (Object)agent.name, (Object)agent.deploymentId);
                    log.error("Failure thrown on the controller (this node): ", cause);
                } else {
                    Message message = (Message)reply.result();
                    if (message.body() instanceof ReplyException) {
                        String msg = ((ReplyException)message.body()).getMessage();
                        log.error("{} Agent {}({}) failed to initialize", (Object)run.id, (Object)agent.name, (Object)agent.deploymentId);
                        log.error("Failure thrown on the agent node (see agent log for details): {}", (Object)msg);
                        cause = new BenchmarkExecutionException(msg);
                    } else {
                        log.debug("{} Agent {}({}) was initialized.", (Object)run.id, (Object)agent.name, (Object)agent.deploymentId);
                        return;
                    }
                }
                agent.status = AgentInfo.Status.FAILED;
                run.errors.add(new Run.Error(agent, cause));
                this.stopSimulation(run);
            });
        }
    }

    private void startSimulation(Run run) {
        this.vertx.executeBlocking(future -> {
            List<RunHook> hooks = this.loadHooks("pre");
            hooks.addAll(run.benchmark.preHooks());
            Collections.sort(hooks);
            for (RunHook hook : hooks) {
                StringBuilder sb = new StringBuilder();
                boolean success = hook.run(this.getRunProperties(run), sb::append);
                run.hookResults.add(new Run.RunHookOutput(hook.name(), sb.toString()));
                if (success) continue;
                run.errors.add(new Run.Error(null, (Throwable)new BenchmarkExecutionException("Execution of run hook " + hook.name() + " failed.")));
                future.fail("Execution of pre-hook " + hook.name() + " failed.");
                break;
            }
            future.complete();
        }, result -> {
            if (result.succeeded()) {
                this.vertx.runOnContext(nil -> {
                    assert (run.startTime == Long.MIN_VALUE);
                    run.startTime = System.currentTimeMillis();
                    for (Phase phase : run.benchmark.phases()) {
                        run.phases.put(phase.name(), new ControllerPhase(phase));
                    }
                    this.runSimulation(run);
                });
            } else {
                log.error("{} Failed to start the simulation", (Object)run.id, (Object)result.cause());
                this.stopSimulation(run);
            }
        });
    }

    private void runSimulation(Run run) {
        ControllerPhase[] availablePhases;
        if (this.timerId >= 0L) {
            this.vertx.cancelTimer(this.timerId);
            this.timerId = -1L;
        }
        long now = System.currentTimeMillis();
        for (ControllerPhase controllerPhase : run.phases.values()) {
            if (controllerPhase.status() == ControllerPhase.Status.RUNNING && controllerPhase.absoluteStartTime() + controllerPhase.definition().duration() <= now) {
                this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.FINISH, controllerPhase.definition().name, null));
                controllerPhase.status(run.id, ControllerPhase.Status.FINISHING);
            }
            if (controllerPhase.status() != ControllerPhase.Status.FINISHED) continue;
            if (controllerPhase.definition().maxDuration() >= 0L && controllerPhase.absoluteStartTime() + controllerPhase.definition().maxDuration() <= now) {
                this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.TERMINATE, controllerPhase.definition().name, null));
                controllerPhase.status(run.id, ControllerPhase.Status.TERMINATING);
                continue;
            }
            if (!controllerPhase.definition().terminateAfterStrict().stream().map(run.phases::get).allMatch(p -> p.status().isTerminated())) continue;
            this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.TRY_TERMINATE, controllerPhase.definition().name, null));
        }
        for (ControllerPhase phase3 : availablePhases = run.getAvailablePhases()) {
            Map<String, GlobalData.Element> newGlobalData = run.newGlobalData;
            if (!newGlobalData.isEmpty()) {
                run.newGlobalData = new HashMap<String, GlobalData.Element>();
            }
            this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.RUN, phase3.definition().name, newGlobalData));
            phase3.absoluteStartTime(now);
            phase3.status(run.id, ControllerPhase.Status.STARTING);
        }
        if (run.phases.values().stream().allMatch(phase -> phase.status().isTerminated())) {
            log.info("{} All phases are terminated.", (Object)run.id);
            this.stopSimulation(run);
            return;
        }
        long l = run.nextTimestamp();
        long delay = l - System.currentTimeMillis();
        delay = Math.min(delay, 1000L);
        log.debug("Wait {} ms", (Object)delay);
        if (delay > 0L) {
            if (this.timerId >= 0L) {
                this.vertx.cancelTimer(this.timerId);
            }
            this.timerId = this.vertx.setTimer(delay, timerId -> this.runSimulation(run));
        } else {
            this.vertx.runOnContext(nil -> this.runSimulation(run));
        }
    }

    private void stopSimulation(Run run) {
        if (run.terminateTime.future().isComplete()) {
            log.warn("Run {} already completed.", (Object)run.id);
            return;
        }
        run.terminateTime.complete((Object)System.currentTimeMillis());
        run.completed = true;
        for (AgentInfo agent : run.agents) {
            if (agent.deploymentId == null) {
                assert (agent.status == AgentInfo.Status.STARTING);
                if (agent.deployedAgent == null) continue;
                agent.deployedAgent.stop();
                continue;
            }
            agent.status = AgentInfo.Status.STOPPING;
            this.eb.request(agent.deploymentId, (Object)new AgentControlMessage(AgentControlMessage.Command.STOP, agent.id, null), reply -> {
                if (reply.succeeded() && !(reply.result() instanceof Throwable)) {
                    agent.status = AgentInfo.Status.STOPPED;
                    this.checkAgentsStopped(run);
                    log.debug("Agent {}/{} stopped.", (Object)agent.name, (Object)agent.deploymentId);
                } else {
                    agent.status = AgentInfo.Status.FAILED;
                    log.error("Agent {}/{} failed to stop", (Object)agent.name, (Object)agent.deploymentId);
                    if (reply.result() instanceof Throwable) {
                        log.error("Failure thrown on the agent node (see agent log for details): ", (Throwable)reply.result());
                    } else {
                        log.error("Failure thrown on the controller (this node): ", reply.cause());
                    }
                }
                if (agent.deployedAgent != null) {
                    this.vertx.setTimer(3000L, timerId -> agent.deployedAgent.stop());
                }
            });
        }
        this.checkAgentsStopped(run);
    }

    private void checkAgentsStopped(Run run) {
        if (run.agents.stream().allMatch(a -> a.status.ordinal() >= AgentInfo.Status.STOPPED.ordinal())) {
            for (ControllerPhase phase : run.phases.values()) {
                run.statisticsStore().adjustPhaseTimestamps(phase.definition().name(), phase.absoluteStartTime(), phase.absoluteCompletionTime());
            }
            run.statisticsStore().completeAll(error -> {
                log.warn("Run {}: {}", (Object)run.id, error);
                run.errors.add(new Run.Error(null, (Throwable)new BenchmarkExecutionException(error)));
            });
            this.persistRun(run);
            log.info("Run {} completed", (Object)run.id);
        }
    }

    private void persistRun(Run run) {
        this.vertx.executeBlocking(future -> {
            try {
                CsvWriter.writeCsv(run.dir.resolve("stats"), run.statisticsStore());
            }
            catch (IOException e2) {
                log.error("Failed to persist statistics", (Throwable)e2);
                future.fail((Throwable)e2);
            }
            JsonObject info = new JsonObject().put("id", (Object)run.id).put("benchmark", (Object)run.benchmark.name()).put("params", (Object)new JsonObject(run.benchmark.params().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).put("startTime", (Object)run.startTime).put("terminateTime", run.terminateTime.future().result()).put("cancelled", (Object)run.cancelled).put("description", (Object)run.description).put("errors", (Object)new JsonArray(run.errors.stream().map(e -> {
                JsonObject json = new JsonObject();
                if (e.agent != null) {
                    json.put("agent", (Object)e.agent.name);
                }
                return json.put("msg", (Object)e.error.getMessage());
            }).collect(Collectors.toList())));
            try {
                Files.writeString(run.dir.resolve("info.json"), (CharSequence)info.encodePrettily(), new OpenOption[0]);
            }
            catch (IOException e3) {
                log.error("Cannot write info file", (Throwable)e3);
                future.fail((Throwable)e3);
            }
            try (FileOutputStream stream = new FileOutputStream(run.dir.resolve(DEFAULT_STATS_JSON).toFile());){
                JsonFactory jfactory = new JsonFactory();
                jfactory.setCodec((ObjectCodec)new ObjectMapper());
                JsonGenerator jGenerator = jfactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
                jGenerator.setCodec((ObjectCodec)new ObjectMapper());
                JsonWriter.writeArrayJsons(run.statisticsStore(), jGenerator, info);
                jGenerator.flush();
                jGenerator.close();
            }
            catch (IOException e4) {
                log.error("Cannot write to {}", (Object)DEFAULT_STATS_JSON, (Object)e4);
                future.fail((Throwable)e4);
            }
            List<RunHook> hooks = this.loadHooks("post");
            hooks.addAll(run.benchmark.postHooks());
            Collections.sort(hooks);
            for (RunHook hook : hooks) {
                StringBuilder sb = new StringBuilder();
                boolean success = hook.run(this.getRunProperties(run), sb::append);
                run.hookResults.add(new Run.RunHookOutput(hook.name(), sb.toString()));
                if (success) continue;
                log.error("Execution of post-hook {} failed.", (Object)hook.name());
                break;
            }
            JsonArray hookResults = new JsonArray(run.hookResults.stream().map(r -> new JsonObject().put("name", (Object)r.name).put("output", (Object)r.output)).collect(Collectors.toList()));
            try {
                Files.writeString(run.dir.resolve("hooks.json"), (CharSequence)hookResults.encodePrettily(), new OpenOption[0]);
            }
            catch (IOException e5) {
                log.error("Cannot write hook results", (Throwable)e5);
                future.fail((Throwable)e5);
            }
            future.tryComplete();
        }, result -> {
            run.completed = true;
            run.persisted = true;
            if (result.failed()) {
                log.error("Failed to persist run {}", (Object)run.id, (Object)result.cause());
            } else {
                log.info("Successfully persisted run {}", (Object)run.id);
            }
        });
    }

    private Map<String, String> getRunProperties(Run run) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("RUN_ID", run.id);
        properties.put("RUN_DIR", Controller.RUN_DIR.resolve(run.id).toAbsolutePath().toString());
        if (run.description != null) {
            properties.put("RUN_DESCRIPTION", run.description);
        }
        properties.put("BENCHMARK", run.benchmark.name());
        File benchmarkFile = Controller.BENCHMARK_DIR.resolve(run.benchmark.name() + ".yaml").toFile();
        if (benchmarkFile.exists()) {
            properties.put("BENCHMARK_PATH", benchmarkFile.getAbsolutePath());
        }
        return properties;
    }

    public Run run(String runId) {
        return this.runs.get(runId);
    }

    public Collection<Run> runs() {
        return this.runs.values();
    }

    public void kill(Run run, Handler<AsyncResult<Void>> handler) {
        log.info("{} Killing run", (Object)run.id);
        try {
            run.cancelled = true;
            for (Map.Entry<String, ControllerPhase> entry : run.phases.entrySet()) {
                ControllerPhase.Status status = entry.getValue().status();
                if (status.isTerminated()) continue;
                if (status == ControllerPhase.Status.NOT_STARTED) {
                    entry.getValue().status(run.id, ControllerPhase.Status.CANCELLED);
                    continue;
                }
                entry.getValue().status(run.id, ControllerPhase.Status.TERMINATING);
                this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.TERMINATE, entry.getKey(), null));
            }
            run.terminateTime.future().onComplete(result -> handler.handle((Object)result.mapEmpty()));
        }
        catch (Throwable e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public Future<Void> addBenchmark(Benchmark benchmark, String prevVersion) {
        BenchmarkSource template;
        Benchmark prev;
        String currentVersion;
        if (prevVersion != null && !prevVersion.equals(currentVersion = (prev = this.benchmarks.get(benchmark.name())) == null ? ((template = this.templates.get(benchmark.name())) != null ? template.version : null) : prev.version())) {
            log.info("Updating benchmark {}, version {} but current version is {}", (Object)benchmark.name(), (Object)prevVersion, (Object)(currentVersion != null ? currentVersion : "<non-existent>"));
            return Future.failedFuture((Throwable)new VersionConflictException());
        }
        this.benchmarks.put(benchmark.name(), benchmark);
        this.templates.remove(benchmark.name());
        return this.vertx.executeBlocking(promise -> {
            if (benchmark.source() != null) {
                PersistenceUtil.store(benchmark.source(), Controller.BENCHMARK_DIR);
            }
            promise.complete();
        });
    }

    public Future<Void> addTemplate(BenchmarkSource template, String prevVersion) {
        Benchmark benchmark;
        BenchmarkSource prev;
        String currentVersion;
        if (prevVersion != null && !prevVersion.equals(currentVersion = (prev = this.templates.get(template.name)) == null ? ((benchmark = this.benchmarks.get(template.name)) != null ? benchmark.version() : null) : prev.version)) {
            log.info("Updating template {}, version {} but current version is {}", (Object)template.name, (Object)prevVersion, (Object)(currentVersion != null ? currentVersion : "<non-existent>"));
            return Future.failedFuture((Throwable)new VersionConflictException());
        }
        this.templates.put(template.name, template);
        this.benchmarks.remove(template.name);
        return this.vertx.executeBlocking(promise -> {
            PersistenceUtil.store(template, Controller.BENCHMARK_DIR);
            promise.complete();
        });
    }

    public Collection<String> getBenchmarks() {
        return this.benchmarks.keySet();
    }

    public Collection<String> getTemplates() {
        return this.templates.keySet();
    }

    public Benchmark getBenchmark(String name) {
        return this.benchmarks.get(name);
    }

    public BenchmarkSource getTemplate(String name) {
        return this.templates.get(name);
    }

    private void loadBenchmarks(Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> {
            try {
                Files.list(Controller.BENCHMARK_DIR).forEach(file -> {
                    try {
                        BenchmarkSource source = PersistenceUtil.load(file);
                        if (source != null) {
                            if (source.isTemplate()) {
                                this.templates.put(source.name, source);
                            } else {
                                Benchmark benchmark = BenchmarkParser.instance().buildBenchmark(source, Collections.emptyMap());
                                this.benchmarks.put(benchmark.name(), benchmark);
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to load a benchmark from {}", file, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                log.error("Failed to list benchmark dir {}", (Object)Controller.BENCHMARK_DIR, (Object)e);
            }
            future.complete();
        }, handler);
    }

    private List<RunHook> loadHooks(String subdir) {
        try {
            File hookDir = Controller.HOOKS_DIR.resolve(subdir).toFile();
            if (hookDir.exists() && hookDir.isDirectory()) {
                return Files.list(hookDir.toPath()).map(Path::toFile).filter(file -> !file.isDirectory() && !file.isHidden()).map(file -> new ExecRunHook(file.getName(), file.getAbsolutePath())).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            log.error("Failed to list hooks.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public void listSessions(Run run, boolean includeInactive, BiConsumer<AgentInfo, String> sessionStateHandler, Handler<AsyncResult<Void>> completionHandler) {
        this.invokeOnAgents(run, AgentControlMessage.Command.LIST_SESSIONS, includeInactive, completionHandler, (agent, result) -> {
            if (result.failed()) {
                log.error("Agent {} failed listing sessions", agent, (Object)result.cause());
                sessionStateHandler.accept((AgentInfo)agent, "");
            } else if (result.result() instanceof Throwable) {
                log.error("Agent {} has thrown an error while listing sessions", agent, (Object)((Throwable)result.result()));
                sessionStateHandler.accept((AgentInfo)agent, "");
            } else {
                List sessions = (List)((Message)result.result()).body();
                for (String state : sessions) {
                    sessionStateHandler.accept((AgentInfo)agent, state);
                }
            }
        });
    }

    public void listConnections(Run run, BiConsumer<AgentInfo, String> connectionHandler, Handler<AsyncResult<Void>> completionHandler) {
        this.invokeOnAgents(run, AgentControlMessage.Command.LIST_CONNECTIONS, null, completionHandler, (agent, result) -> {
            if (result.failed()) {
                log.error("Agent {} failed listing connections", agent, (Object)result.cause());
                connectionHandler.accept((AgentInfo)agent, "");
            } else if (result.result() instanceof Throwable) {
                log.error("Agent {} has thrown an error while listing connections", agent, (Object)((Throwable)result.result()));
                connectionHandler.accept((AgentInfo)agent, "");
            } else {
                List connections = (List)((Message)result.result()).body();
                for (String state : connections) {
                    connectionHandler.accept((AgentInfo)agent, state);
                }
            }
        });
    }

    private void invokeOnAgents(Run run, AgentControlMessage.Command command, Object param, Handler<AsyncResult<Void>> completionHandler, BiConsumer<AgentInfo, AsyncResult<Message<Object>>> handler) {
        AtomicInteger agentCounter = new AtomicInteger(1);
        for (AgentInfo agent : run.agents) {
            if (agent.status.ordinal() >= AgentInfo.Status.STOPPED.ordinal()) {
                log.debug("Cannot invoke command on {}, status: {}", (Object)agent.name, (Object)agent.status);
                continue;
            }
            agentCounter.incrementAndGet();
            this.eb.request(agent.deploymentId, (Object)new AgentControlMessage(command, agent.id, param), result -> {
                if (result.failed()) {
                    log.error("Failed to connect to agent {}", (Object)agent.name, (Object)result.cause());
                    completionHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
                } else {
                    handler.accept(agent, (AsyncResult<Message<Object>>)result);
                    if (agentCounter.decrementAndGet() == 0) {
                        completionHandler.handle((Object)Future.succeededFuture());
                    }
                }
            });
        }
        if (agentCounter.decrementAndGet() == 0) {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    public boolean hasControllerLog() {
        return this.deployer != null && this.deployer.hasControllerLog();
    }

    public void downloadControllerLog(long offset, long maxLength, File tempFile, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> this.deployer.downloadControllerLog(offset, maxLength, tempFile.toString(), handler), result -> {
            if (result.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        });
    }

    public void downloadAgentLog(DeployedAgent deployedAgent, long offset, long maxLength, File tempFile, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> this.deployer.downloadAgentLog(deployedAgent, offset, maxLength, tempFile.toString(), handler), result -> {
            if (result.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        });
    }

    public Benchmark ensureBenchmark(Run run) throws ParserException {
        if (run.benchmark.source() == null) {
            BenchmarkSource source;
            File yamlSource = Controller.RUN_DIR.resolve(run.id).resolve(run.benchmark.name() + ".yaml").toFile();
            if (yamlSource.exists() && yamlSource.isFile() && (source = PersistenceUtil.load(yamlSource.toPath())) != null) {
                run.benchmark = BenchmarkParser.instance().buildBenchmark(source, run.benchmark.params());
                return run.benchmark;
            }
            log.warn("Cannot find benchmark source for run {}, benchmark {}", (Object)run.id, (Object)run.benchmark.name());
        }
        return run.benchmark;
    }

    public void shutdown() {
        InfinispanClusterManager clusterManager = (InfinispanClusterManager)((VertxInternal)this.vertx).getClusterManager();
        if (clusterManager != null) {
            BasicCacheContainer cacheManager = clusterManager.getCacheContainer();
            this.vertx.close(ar -> cacheManager.stop());
        } else {
            this.vertx.close();
        }
    }

    public int actualPort() {
        return this.server.httpServer.actualPort();
    }

    public Path getRunDir(Run run) {
        return Controller.RUN_DIR.resolve(run.id);
    }

    public JsonObject getConfig() {
        return this.context.config();
    }

    public boolean deleteBenchmark(String name) {
        Benchmark oldBenchmark = this.benchmarks.remove(name);
        BenchmarkSource oldTemplate = this.templates.remove(name);
        if (oldBenchmark != null || oldTemplate != null) {
            if (!PersistenceUtil.delete(name, Controller.BENCHMARK_DIR)) {
                throw new RuntimeException("Cannot delete benchmark " + name);
            }
            return true;
        }
        return false;
    }
}

