/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.Version;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.clustering.AgentInfo;
import io.hyperfoil.clustering.ControllerPhase;
import io.hyperfoil.clustering.ControllerVerticle;
import io.hyperfoil.clustering.Run;
import io.hyperfoil.clustering.VersionConflictException;
import io.hyperfoil.clustering.Zipper;
import io.hyperfoil.clustering.util.PersistedBenchmarkData;
import io.hyperfoil.clustering.webcli.WebCLI;
import io.hyperfoil.controller.ApiService;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.controller.model.Agent;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.Phase;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.controller.router.ApiRouter;
import io.hyperfoil.core.impl.LocalBenchmarkData;
import io.hyperfoil.core.impl.ProvidedBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.print.YamlVisitor;
import io.hyperfoil.core.util.CountDown;
import io.hyperfoil.core.util.LowHigh;
import io.hyperfoil.impl.Util;
import io.hyperfoil.internal.Controller;
import io.hyperfoil.internal.Properties;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.infinispan.commons.util.FileLookupFactory;

class ControllerServer
implements ApiService {
    private static final Logger log = LogManager.getLogger(ControllerServer.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_SERIALIZED = "application/java-serialized-object";
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final String MIME_TYPE_YAML = "text/vnd.yaml";
    private static final String KEYSTORE_PATH = Properties.get((String)"io.hyperfoil.controller.keystore.path", null);
    private static final String KEYSTORE_PASSWORD = Properties.get((String)"io.hyperfoil.controller.keystore.password", null);
    private static final String PEM_KEYS = Properties.get((String)"io.hyperfoil.controller.pem.keys", null);
    private static final String PEM_CERTS = Properties.get((String)"io.hyperfoil.controller.pem.certs", null);
    private static final String CONTROLLER_PASSWORD = Properties.get((String)"io.hyperfoil.controller.password", null);
    private static final boolean CONTROLLER_SECURED_VIA_PROXY = Properties.getBoolean((String)"io.hyperfoil.controller.secured.via.proxy");
    private static final String CONTROLLER_EXTERNAL_URI = Properties.get((String)"io.hyperfoil.controller.external.uri", null);
    private static final String TRIGGER_URL = Properties.get((String)"io.hyperfoil.trigger.url", null);
    private static final String BEARER_TOKEN;
    private static final Comparator<ControllerPhase> PHASE_COMPARATOR;
    private static final BinaryOperator<Run> LAST_RUN_OPERATOR;
    private static final String DATAKEY = "[/**DATAKEY**/]";
    final ControllerVerticle controller;
    HttpServer httpServer;
    String baseURL;

    ControllerServer(ControllerVerticle controller, CountDown countDown) {
        this.controller = controller;
        HttpServerOptions options = new HttpServerOptions();
        if (KEYSTORE_PATH != null) {
            options.setSsl(true).setUseAlpn(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setPath(KEYSTORE_PATH).setPassword(KEYSTORE_PASSWORD));
        } else if (PEM_CERTS != null || PEM_KEYS != null) {
            PemKeyCertOptions pem = new PemKeyCertOptions();
            if (PEM_CERTS != null) {
                for (String certPath : PEM_CERTS.split(",")) {
                    pem.addCertPath(certPath.trim());
                }
            }
            if (PEM_KEYS != null) {
                for (String keyPath : PEM_KEYS.split(",")) {
                    pem.addKeyPath(keyPath.trim());
                }
            }
            options.setSsl(true).setUseAlpn(true).setKeyCertOptions((KeyCertOptions)pem);
        }
        Router router = Router.router((Vertx)controller.getVertx());
        if (CONTROLLER_PASSWORD != null) {
            if (!options.isSsl() && !CONTROLLER_SECURED_VIA_PROXY) {
                throw new IllegalStateException("Server uses basic authentication scheme (io.hyperfoil.controller.password is set) but it does not use TLS connections. If the confidentiality is guaranteed by a proxy set -Dio.hyperfoil.controller.secured.via.proxy=true.");
            }
            log.info("Server is protected using a password.");
            router.route().handler((Handler)new BasicAuthHandler());
        }
        StaticHandler staticHandler = StaticHandler.create().setCachingEnabled(true);
        router.route("/").handler((Handler)staticHandler);
        router.route("/web/*").handler((Handler)staticHandler);
        router.route("/favicon.ico").handler((Handler)FaviconHandler.create((Vertx)controller.getVertx(), (String)"webroot/favicon.ico"));
        new ApiRouter((ApiService)this, router);
        String controllerHost = Properties.get((String)"io.hyperfoil.controller.host", (String)controller.getConfig().getString("io.hyperfoil.controller.host", "0.0.0.0"));
        int controllerPort = Properties.getInt((String)"io.hyperfoil.controller.port", (int)controller.getConfig().getInteger("io.hyperfoil.controller.port", Integer.valueOf(8090)));
        WebCLI webCLI = new WebCLI(controller.getVertx());
        this.httpServer = controller.getVertx().createHttpServer(options).requestHandler((Handler)router).webSocketHandler((Handler)webCLI).listen(controllerPort, controllerHost, serverResult -> {
            if (serverResult.succeeded()) {
                String host = controllerHost;
                if (host.equals("0.0.0.0")) {
                    try {
                        host = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        host = "localhost";
                    }
                }
                this.baseURL = CONTROLLER_EXTERNAL_URI == null ? (options.isSsl() ? "https://" : "http://") + host + ":" + ((HttpServer)serverResult.result()).actualPort() : CONTROLLER_EXTERNAL_URI;
                webCLI.setConnectionOptions(host, ((HttpServer)serverResult.result()).actualPort(), options.isSsl());
                log.info("Hyperfoil controller listening on {}", (Object)this.baseURL);
            }
            countDown.handle(serverResult.mapEmpty());
        });
    }

    void stop(Promise<Void> stopFuture) {
        this.httpServer.close(result -> stopFuture.complete());
    }

    public void openApi(RoutingContext ctx) {
        try {
            String contentType;
            Buffer payload;
            InputStream stream = ApiService.class.getClassLoader().getResourceAsStream("openapi.yaml");
            if (stream == null) {
                payload = Buffer.buffer((String)"API definition not available");
                contentType = MIME_TYPE_TEXT_PLAIN;
            } else {
                payload = Buffer.buffer((String)Util.toString((InputStream)stream));
                contentType = MIME_TYPE_YAML;
            }
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE.toString(), contentType).putHeader("x-epoch-millis", String.valueOf(System.currentTimeMillis())).end(payload);
        }
        catch (IOException e) {
            log.error("Cannot read OpenAPI definition", (Throwable)e);
            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Cannot read OpenAPI definition.").end();
        }
    }

    private void respondWithJson(RoutingContext ctx, boolean pretty, Object entity) {
        ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_JSON).end(pretty ? Json.encodePrettily((Object)entity) : Json.encode((Object)entity));
    }

    private void respondWithJson(RoutingContext ctx, JsonObject entity) {
        ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_JSON).end(entity.encodePrettily());
    }

    public void listBenchmarks(RoutingContext ctx) {
        this.respondWithJson(ctx, true, this.controller.getBenchmarks());
    }

    public void listTemplates(RoutingContext ctx) {
        this.respondWithJson(ctx, true, this.controller.getTemplates());
    }

    public void addBenchmark$application_json(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        this.addBenchmark$text_vnd_yaml(ctx, ifMatch, storedFilesBenchmark);
    }

    private void addBenchmarkAndReply(RoutingContext ctx, String source, BenchmarkData data, String prevVersion) throws ParserException {
        if (source == null || data == null) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Cannot read benchmark.");
            return;
        }
        BenchmarkSource benchmarkSource = BenchmarkParser.instance().createSource(source, data);
        if (benchmarkSource.isTemplate()) {
            Future<Void> future = this.controller.addTemplate(benchmarkSource, prevVersion);
            this.sendReply(ctx, future, benchmarkSource.name);
        } else {
            Benchmark benchmark = BenchmarkParser.instance().buildBenchmark(benchmarkSource, Collections.emptyMap());
            this.addBenchmarkAndReply(ctx, benchmark, prevVersion);
        }
    }

    private void sendReply(RoutingContext ctx, Future<Void> future, String name) {
        String location = this.baseURL + "/benchmark/" + ControllerServer.encode(name);
        future.onSuccess(nil -> ctx.response().setStatusCode(HttpResponseStatus.NO_CONTENT.code()).putHeader(HttpHeaders.LOCATION, (CharSequence)location).end()).onFailure(throwable -> {
            if (throwable instanceof VersionConflictException) {
                ctx.response().setStatusCode(HttpResponseStatus.CONFLICT.code()).end();
            } else {
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
            }
        });
    }

    private void addBenchmarkAndReply(RoutingContext ctx, Benchmark benchmark, String prevVersion) {
        if (benchmark == null) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Cannot read benchmark.");
            return;
        }
        if (benchmark.agents().length == 0 && this.controller.getVertx().isClustered()) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Hyperfoil controller is clustered but the benchmark does not define any agents.");
            return;
        }
        if (benchmark.agents().length != 0 && !this.controller.getVertx().isClustered()) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Hyperfoil runs in standalone mode but the benchmark defines agents for clustering");
            return;
        }
        this.sendReply(ctx, this.controller.addBenchmark(benchmark, prevVersion), benchmark.name());
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addBenchmark$text_uri_list(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        String loadDirProperty = Properties.get((String)"io.hyperfoil.loaddir", null);
        if (loadDirProperty == null) {
            log.error("Loading controller local benchmarks is not enabled, set the {} property to enable.", (Object)"io.hyperfoil.loaddir");
            ctx.response().setStatusCode(HttpResponseStatus.SERVICE_UNAVAILABLE.code()).end("Loading controller local benchmarks is not enabled.");
            return;
        }
        Path loadDirPath = Paths.get(loadDirProperty, new String[0]).toAbsolutePath();
        String body = ctx.getBodyAsString();
        if (body == null || body.isEmpty()) {
            log.error("Benchmark is empty, load failed.");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Benchmark is empty.");
            return;
        }
        List uris = body.lines().map(String::trim).filter(Predicate.not(String::isEmpty)).filter(Predicate.not(l -> l.startsWith("#"))).flatMap(l -> {
            try {
                return Stream.of(new URI((String)l));
            }
            catch (URISyntaxException e) {
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        if (uris.isEmpty()) {
            log.error("No Benchmark URIs specified, load failed.");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("No Benchmark URIs specified.");
            return;
        }
        if (uris.size() > 1) {
            log.error("Multiple Benchmark URIs specified, load failed.");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Multiple Benchmark URIs specified.");
            return;
        }
        URI uri = (URI)uris.get(0);
        if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
            log.error("Unsupported URI scheme of {} specified, load failed.", (Object)uri.getScheme());
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(uri.getScheme() + " scheme URIs are not supported.");
            return;
        }
        Path localPath = (uri.getScheme() == null ? Paths.get(uri.getPath(), new String[0]) : Paths.get(uri)).toAbsolutePath();
        if (!localPath.startsWith(loadDirPath) || !Files.isRegularFile(localPath, new LinkOption[0])) {
            log.error("Unknown controller local benchmark {}.", (Object)localPath);
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Unknown controller local benchmark.");
            return;
        }
        try {
            String source = Files.readString(localPath);
            Object data = new LocalBenchmarkData(localPath);
            if (storedFilesBenchmark != null) {
                storedFilesBenchmark = BenchmarkData.sanitize((String)storedFilesBenchmark);
                data = new PersistedBenchmarkData(Controller.BENCHMARK_DIR.resolve(storedFilesBenchmark + ".data"));
            }
            this.addBenchmarkAndReply(ctx, source, (BenchmarkData)data, ifMatch);
        }
        catch (BenchmarkDefinitionException | ParserException | IOException e) {
            this.respondParsingError(ctx, (Exception)e);
        }
    }

    public void addBenchmark$text_vnd_yaml(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        String source = ctx.getBodyAsString();
        if (source == null || source.isEmpty()) {
            log.error("Benchmark is empty, upload failed.");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Benchmark is empty.");
            return;
        }
        try {
            BenchmarkData data = BenchmarkData.EMPTY;
            if (storedFilesBenchmark != null) {
                storedFilesBenchmark = BenchmarkData.sanitize((String)storedFilesBenchmark);
                data = new PersistedBenchmarkData(Controller.BENCHMARK_DIR.resolve(storedFilesBenchmark + ".data"));
            }
            this.addBenchmarkAndReply(ctx, source, data, ifMatch);
        }
        catch (BenchmarkDefinitionException | ParserException e) {
            this.respondParsingError(ctx, (Exception)e);
        }
    }

    private void respondParsingError(RoutingContext ctx, Exception e) {
        log.error("Failed to read benchmark", (Throwable)e);
        ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Cannot read benchmark: " + Util.explainCauses((Throwable)e));
    }

    public void addBenchmark$application_java_serialized_object(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        if (storedFilesBenchmark != null) {
            log.warn("Ignoring parameter useStoredData for serialized benchmark upload.");
        }
        byte[] bytes = ctx.getBody().getBytes();
        try {
            Benchmark benchmark = Util.deserialize((byte[])bytes);
            this.addBenchmarkAndReply(ctx, benchmark, ifMatch);
        }
        catch (IOException | ClassNotFoundException e) {
            log.error("Failed to deserialize", (Throwable)e);
            StringBuilder message = new StringBuilder("Cannot read benchmark - the controller (server) version and CLI version are probably not in sync.\n");
            message.append("This partial stack-track might help you diagnose the problematic part:\n---\n");
            for (StackTraceElement ste : e.getStackTrace()) {
                message.append(ste).append('\n');
                if (ste.getClassName().equals(Util.class.getName())) break;
            }
            message.append("---\n");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(message.toString());
        }
    }

    public void addBenchmark$multipart_form_data(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        String source = null;
        Object data = new ProvidedBenchmarkData();
        for (FileUpload upload : ctx.fileUploads()) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(Paths.get(upload.uploadedFileName(), new String[0]));
            }
            catch (IOException e) {
                log.error("Cannot read uploaded file {}", (Object)upload.uploadedFileName(), (Object)e);
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
                return;
            }
            if (upload.name().equals("benchmark")) {
                try {
                    source = new String(bytes, upload.charSet());
                }
                catch (UnsupportedEncodingException e) {
                    source = new String(bytes, StandardCharsets.UTF_8);
                }
                continue;
            }
            data.files.put(upload.fileName(), bytes);
        }
        if (source == null) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Multi-part definition missing benchmark=source-file.yaml");
            return;
        }
        try {
            if (storedFilesBenchmark != null) {
                storedFilesBenchmark = BenchmarkData.sanitize((String)storedFilesBenchmark);
                Path dataDirPath = Controller.BENCHMARK_DIR.resolve(storedFilesBenchmark + ".data");
                log.info("Trying to use stored files from {}, adding files from request: {}", (Object)dataDirPath, data.files().keySet());
                if (!data.files().isEmpty()) {
                    File dataDir = dataDirPath.toFile();
                    dataDir.mkdirs();
                    if (dataDir.exists() && dataDir.isDirectory()) {
                        try {
                            PersistedBenchmarkData.store(data.files(), dataDirPath);
                        }
                        catch (IOException e) {
                            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end("Failed to store benchmark files.");
                        }
                    }
                }
                data = new PersistedBenchmarkData(dataDirPath);
            }
            this.addBenchmarkAndReply(ctx, source, (BenchmarkData)data, ifMatch);
        }
        catch (BenchmarkDefinitionException | ParserException e) {
            this.respondParsingError(ctx, (Exception)e);
        }
    }

    public void getBenchmark$text_vnd_yaml(RoutingContext ctx, String name) {
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            BenchmarkSource template = this.controller.getTemplate(name);
            if (template == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end("No benchmark or template '" + name + "'.");
            } else {
                this.sendYamlBenchmark(ctx, template, template.version);
            }
        } else {
            this.sendYamlBenchmark(ctx, benchmark.source(), benchmark.version());
        }
    }

    private void sendYamlBenchmark(RoutingContext ctx, BenchmarkSource source, String version) {
        if (source == null) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_ACCEPTABLE.code()).end("Benchmark does not preserve the original source.");
        } else {
            HttpServerResponse response = ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/vnd.yaml; charset=UTF-8").putHeader(HttpHeaders.ETAG.toString(), version);
            source.data.files().keySet().forEach(file -> response.putHeader("x-file", file));
            response.end(source.yaml);
        }
    }

    public void getBenchmark$application_java_serialized_object(RoutingContext ctx, String name) {
        this.withBenchmark(ctx, name, benchmark -> this.sendSerializedBenchmark(ctx, (Benchmark)benchmark));
    }

    public void deleteBenchmark(RoutingContext ctx, String name) {
        try {
            if (this.controller.deleteBenchmark(name)) {
                ctx.response().setStatusCode(204).end();
            } else {
                ctx.response().setStatusCode(404).end("Could not find benchmark " + name);
            }
        }
        catch (Throwable t) {
            ctx.response().setStatusCode(500).end(t.getMessage());
        }
    }

    private void sendSerializedBenchmark(RoutingContext ctx, Benchmark benchmark) {
        try {
            byte[] bytes = Util.serialize((Benchmark)benchmark);
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_SERIALIZED).end(Buffer.buffer((byte[])bytes));
        }
        catch (IOException e) {
            log.error("Failed to serialize", (Throwable)e);
            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end("Error encoding benchmark.");
        }
    }

    public void startBenchmark(RoutingContext ctx, String name, String desc, String xTriggerJob, String runId, List<String> templateParam) {
        Run run;
        Object triggerUrl;
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            BenchmarkSource template = this.controller.getTemplate(name);
            if (template == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end("Benchmark not found");
                return;
            }
            benchmark = this.templateToBenchmark(ctx, template, templateParam);
            if (benchmark == null) {
                return;
            }
        }
        Object object = triggerUrl = benchmark.triggerUrl() != null ? benchmark.triggerUrl() : TRIGGER_URL;
        if (triggerUrl != null && xTriggerJob == null) {
            Run run2 = this.controller.createRun(benchmark, desc);
            if (!((String)triggerUrl).endsWith("&") && !((String)triggerUrl).endsWith("?")) {
                triggerUrl = ((String)triggerUrl).contains("?") ? (String)triggerUrl + "&" : (String)triggerUrl + "?";
            }
            ctx.response().setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader(HttpHeaders.LOCATION, (CharSequence)((String)triggerUrl + "BENCHMARK=" + name + "&RUN_ID=" + run2.id)).putHeader("x-run-id", run2.id).end("This controller is configured to trigger jobs through CI instance.");
            return;
        }
        if (runId == null) {
            run = this.controller.createRun(benchmark, desc);
        } else {
            run = this.controller.run(runId);
            if (run == null || run.startTime != Long.MIN_VALUE) {
                ctx.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end("Run already started");
                return;
            }
        }
        String error = this.controller.startBenchmark(run);
        if (error == null) {
            ctx.response().setStatusCode(HttpResponseStatus.ACCEPTED.code()).putHeader(HttpHeaders.LOCATION, (CharSequence)(this.baseURL + "/run/" + run.id)).putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_JSON).end(Json.encodePrettily((Object)this.runInfo(run, false)));
        } else {
            ctx.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end(error);
        }
    }

    private Benchmark templateToBenchmark(RoutingContext ctx, BenchmarkSource template, List<String> templateParam) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (String item : templateParam) {
            int index = item.indexOf("=");
            if (index < 0) {
                paramMap.put(item, "");
                continue;
            }
            paramMap.put(item.substring(0, index), item.substring(index + 1));
        }
        List missingParams = template.paramsWithDefaults.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).filter(param -> !paramMap.containsKey(param)).collect(Collectors.toList());
        if (missingParams.isEmpty()) {
            try {
                return BenchmarkParser.instance().buildBenchmark(template, paramMap);
            }
            catch (BenchmarkData.MissingFileException e) {
                ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("This benchmark is a template; external files are not uploaded for templates and the run command must append them when the benchmark is first run.");
                return null;
            }
            catch (BenchmarkDefinitionException | ParserException e) {
                ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(Util.explainCauses((Throwable)e));
                return null;
            }
        }
        ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Benchmark " + template.name + " is missing these mandatory parameters: " + String.valueOf(missingParams));
        return null;
    }

    public void getBenchmarkStructure(RoutingContext ctx, String name, int maxCollectionSize, List<String> templateParam) {
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            BenchmarkSource template = this.controller.getTemplate(name);
            if (template == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end("No benchmark or template'" + name + "'.");
            } else {
                String content = null;
                if (!templateParam.isEmpty()) {
                    benchmark = this.templateToBenchmark(ctx, template, templateParam);
                    if (benchmark == null) {
                        return;
                    }
                    content = this.createStructure(maxCollectionSize, benchmark);
                }
                this.respondWithJson(ctx, false, new Client.BenchmarkStructure(template.paramsWithDefaults, content));
            }
        } else {
            String content = this.createStructure(maxCollectionSize, benchmark);
            this.respondWithJson(ctx, false, new Client.BenchmarkStructure(Collections.emptyMap(), content));
        }
    }

    public void getBenchmarkFiles(RoutingContext ctx, String name) {
        Map files;
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            BenchmarkSource template = this.controller.getTemplate(name);
            if (template == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end("No benchmark or template '" + name + "'");
                return;
            }
            files = template.data.files();
        } else {
            files = benchmark.files();
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String boundary = new UUID(random.nextLong(), random.nextLong()).toString();
        HttpServerResponse response = ctx.response();
        response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)("multipart/form-data; boundary=\"" + boundary + "\""));
        response.setChunked(true);
        response.write("--" + boundary);
        for (Map.Entry file : files.entrySet()) {
            response.write("\n");
            response.write(String.valueOf(HttpHeaders.CONTENT_TYPE) + ": application/octet-stream\n");
            response.write(String.valueOf(HttpHeaders.CONTENT_LENGTH) + ": " + ((byte[])file.getValue()).length + "\n");
            response.write(String.valueOf(HttpHeaders.CONTENT_DISPOSITION) + ": form-data; name=\"file\"; filename=\"" + (String)file.getKey() + "\"\n\n");
            response.write((Object)Buffer.buffer((byte[])((byte[])file.getValue())));
            response.write("\n--" + boundary);
        }
        response.write("--");
        response.end();
    }

    private String createStructure(int maxCollectionSize, Benchmark benchmark) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream((OutputStream)byteStream, true, StandardCharsets.UTF_8);){
            new YamlVisitor(stream, maxCollectionSize).walk(benchmark);
        }
        return byteStream.toString(StandardCharsets.UTF_8);
    }

    public void listRuns(RoutingContext ctx, boolean details) {
        io.hyperfoil.controller.model.Run[] runs = (io.hyperfoil.controller.model.Run[])this.controller.runs().stream().map(r -> details ? this.runInfo((Run)r, false) : new io.hyperfoil.controller.model.Run(r.id, null, null, null, r.cancelled, r.completed, r.persisted, null, null, null, null)).toArray(io.hyperfoil.controller.model.Run[]::new);
        this.respondWithJson(ctx, true, runs);
    }

    public void getRun(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> this.respondWithJson(ctx, true, this.runInfo((Run)run, true)));
    }

    public void agentCpu(RoutingContext ctx, String runId) {
        this.withStats(ctx, runId, run -> this.respondWithJson(ctx, false, run.statisticsStore().cpuUsage()));
    }

    private io.hyperfoil.controller.model.Run runInfo(Run run, boolean reportPhases) {
        String benchmark = null;
        if (run.benchmark != null) {
            benchmark = run.benchmark.name();
        }
        Date started = null;
        Date terminated = null;
        if (run.startTime > Long.MIN_VALUE) {
            started = new Date(run.startTime);
        }
        if (run.terminateTime.future().isComplete()) {
            terminated = new Date((Long)run.terminateTime.future().result());
        }
        List phases = null;
        if (reportPhases) {
            long now = System.currentTimeMillis();
            phases = run.phases.values().stream().filter(p -> !(p.definition().model instanceof Model.Noop)).sorted(PHASE_COMPARATOR).map(phase -> {
                Date phaseStarted = null;
                Date phaseTerminated = null;
                StringBuilder remaining = null;
                StringBuilder totalDuration = null;
                if (phase.absoluteStartTime() > Long.MIN_VALUE) {
                    phaseStarted = new Date(phase.absoluteStartTime());
                    if (!phase.status().isTerminated()) {
                        remaining = new StringBuilder().append(phase.definition().duration() - (now - phase.absoluteStartTime())).append(" ms");
                        if (phase.definition().maxDuration() >= 0L) {
                            remaining.append(" (").append(phase.definition().maxDuration() - (now - phase.absoluteStartTime())).append(" ms)");
                        }
                    } else {
                        phaseTerminated = new Date(phase.absoluteCompletionTime());
                        long totalDurationValue = phase.absoluteCompletionTime() - phase.absoluteStartTime();
                        totalDuration = new StringBuilder().append(totalDurationValue).append(" ms");
                        if (totalDurationValue > phase.definition().duration()) {
                            totalDuration.append(" (exceeded by ").append(totalDurationValue - phase.definition().duration()).append(" ms)");
                        }
                    }
                }
                Object type = phase.definition().getClass().getSimpleName();
                type = Character.toLowerCase(((String)type).charAt(0)) + ((String)type).substring(1);
                return new Phase(phase.definition().name(), phase.status().toString(), (String)type, phaseStarted, remaining == null ? null : remaining.toString(), phaseTerminated, phase.isFailed(), totalDuration == null ? null : totalDuration.toString(), phase.definition().description());
            }).collect(Collectors.toList());
        }
        List agents = run.agents.stream().map(ai -> new Agent(ai.name, ai.deploymentId, ai.status.toString())).collect(Collectors.toList());
        return new io.hyperfoil.controller.model.Run(run.id, benchmark, started, terminated, run.cancelled, run.completed, run.persisted, run.description, phases, agents, run.errors.stream().map(Run.Error::toString).collect(Collectors.toList()));
    }

    private void withRun(RoutingContext ctx, String runId, Consumer<Run> consumer) {
        Run run = "last".equals(runId) ? (Run)this.controller.runs.values().stream().reduce(LAST_RUN_OPERATOR).orElse(null) : this.controller.run(runId);
        if (run == null) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
        } else {
            consumer.accept(run);
        }
    }

    public void killRun(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> this.controller.kill((Run)run, (Handler<AsyncResult<Void>>)((Handler)result -> {
            if (result.succeeded()) {
                ctx.response().setStatusCode(HttpResponseStatus.ACCEPTED.code()).end();
            } else {
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage(result.cause().getMessage()).end();
            }
        })));
    }

    public void createReport(RoutingContext ctx, String runId, String source) {
        this.withRun(ctx, runId, run -> {
            StringBuilder template;
            block25: {
                template = new StringBuilder();
                String providedTemplatePath = Properties.get((String)"io.hyperfoil.report.template", (String)"");
                if (providedTemplatePath.isBlank()) {
                    try (InputStream stream = FileLookupFactory.newInstance().lookupFile("report-template.html", Thread.currentThread().getContextClassLoader());
                         BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            template.append(line).append("\n");
                        }
                        break block25;
                    }
                    catch (IOException e) {
                        log.error("Cannot read report template: ", (Throwable)e);
                        ctx.response().setStatusCode(500).end();
                        return;
                    }
                }
                log.info("Using the provided report template at {}", (Object)providedTemplatePath);
                File templateFile = Path.of(providedTemplatePath, new String[0]).toFile();
                if (templateFile.exists() && templateFile.isFile()) {
                    try {
                        template.append(Files.readString(templateFile.toPath(), StandardCharsets.UTF_8));
                    }
                    catch (IOException e) {
                        log.error("Cannot read report template: ", (Throwable)e);
                        ctx.response().setStatusCode(500).end();
                        return;
                    }
                } else {
                    log.error("Template file is not available.");
                    ctx.response().setStatusCode(500).end();
                    return;
                }
            }
            String sourceFile = source != null ? source : "all.json";
            Path runDir = this.controller.getRunDir((Run)run).toAbsolutePath();
            Path filePath = runDir.resolve(sourceFile).toAbsolutePath();
            if (!filePath.startsWith(runDir)) {
                ctx.response().setStatusCode(403).end("Requested file is not within the run directory!");
            } else if (!filePath.toFile().exists()) {
                ctx.response().setStatusCode(404).end("Requested file was not found");
            } else {
                try {
                    String json = Files.readString(filePath);
                    int placeholderIndex = template.indexOf(DATAKEY);
                    HttpServerResponse response = ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html").setChunked(true);
                    response.write(template.substring(0, placeholderIndex));
                    response.write(json);
                    response.write(template.substring(placeholderIndex + DATAKEY.length()));
                    response.end();
                }
                catch (IOException e) {
                    log.error("Cannot read file {}", (Object)filePath);
                    ctx.response().setStatusCode(500).end("Cannot fetch file " + sourceFile);
                }
            }
        });
    }

    public void listSessions(RoutingContext ctx, String runId, boolean inactive) {
        this.withRun(ctx, runId, run -> {
            ctx.response().setChunked(true);
            this.controller.listSessions((Run)run, inactive, (agent, session) -> {
                String line = agent.name + ": " + session + "\n";
                ctx.response().write((Object)Buffer.buffer((byte[])line.getBytes(StandardCharsets.UTF_8)));
            }, this.commonListingHandler(ctx.response()));
        });
    }

    private Handler<AsyncResult<Void>> commonListingHandler(HttpServerResponse response) {
        return result -> {
            if (result.succeeded()) {
                response.setStatusCode(HttpResponseStatus.OK.code()).end();
            } else if (result.cause() instanceof NoStackTraceThrowable) {
                response.setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            } else {
                response.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end(result.cause().getMessage());
            }
        };
    }

    public void getRecentSessions(RoutingContext ctx, String runId) {
        this.getSessionStats(ctx, runId, ss -> ss.recentSessionPoolSummary(System.currentTimeMillis() - 5000L));
    }

    public void getTotalSessions(RoutingContext ctx, String runId) {
        this.getSessionStats(ctx, runId, StatisticsStore::totalSessionPoolSummary);
    }

    private void getSessionStats(RoutingContext ctx, String runId, Function<StatisticsStore, Map<String, Map<String, LowHigh>>> func) {
        this.withStats(ctx, runId, run -> {
            Map stats = (Map)func.apply(run.statisticsStore());
            JsonObject reply = new JsonObject();
            for (Map.Entry entry : stats.entrySet()) {
                String phase = (String)entry.getKey();
                Map addressStats = (Map)entry.getValue();
                JsonObject phaseStats = new JsonObject();
                reply.put(phase, (Object)phaseStats);
                addressStats.forEach((address, lowHigh) -> {
                    String agent = run.agents.stream().filter(a -> a.deploymentId.equals(address)).map(a -> a.name).findFirst().orElse("unknown");
                    phaseStats.put(agent, (Object)new JsonObject().put("min", (Object)lowHigh.low).put("max", (Object)lowHigh.high));
                });
            }
            this.respondWithJson(ctx, reply);
        });
    }

    public void listConnections(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> {
            ctx.response().setChunked(true);
            this.controller.listConnections((Run)run, (agent, connection) -> {
                String line = agent.name + ": " + connection + "\n";
                ctx.response().write((Object)Buffer.buffer((byte[])line.getBytes(StandardCharsets.UTF_8)));
            }, this.commonListingHandler(ctx.response()));
        });
    }

    public void getRecentConnections(RoutingContext ctx, String runId) {
        this.connectionStats(ctx, runId, StatisticsStore::recentConnectionsSummary);
    }

    public void getTotalConnections(RoutingContext ctx, String runId) {
        this.connectionStats(ctx, runId, StatisticsStore::totalConnectionsSummary);
    }

    private void connectionStats(RoutingContext ctx, String runId, Function<StatisticsStore, Map<String, Map<String, LowHigh>>> mapper) {
        this.withStats(ctx, runId, run -> {
            Map stats = (Map)mapper.apply(run.statisticsStore());
            JsonObject result = stats.entrySet().stream().collect(JsonObject::new, (json, e) -> json.put((String)e.getKey(), (Object)ControllerServer.lowHighMapToJson((Map)e.getValue())), JsonObject::mergeIn);
            this.respondWithJson(ctx, JsonObject.mapFrom((Object)result));
        });
    }

    private static JsonObject lowHighMapToJson(Map<String, LowHigh> map) {
        return map.entrySet().stream().collect(JsonObject::new, (byType, e2) -> byType.put((String)e2.getKey(), (Object)new JsonObject().put("min", (Object)((LowHigh)e2.getValue()).low).put("max", (Object)((LowHigh)e2.getValue()).high)), JsonObject::mergeIn);
    }

    public void getAllStats$application_zip(RoutingContext ctx, String runId) {
        this.getAllStatsCsv(ctx, runId);
    }

    public void getAllStatsCsv(RoutingContext ctx, String runId) {
        this.withTerminatedRun(ctx, runId, run -> new Zipper(ctx.response(), this.controller.getRunDir((Run)run).resolve("stats")).run());
    }

    public void getAllStats$application_json(RoutingContext ctx, String runId) {
        this.getAllStatsJson(ctx, runId);
    }

    public void getAllStatsJson(RoutingContext ctx, String runId) {
        this.withTerminatedRun(ctx, runId, run -> ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_JSON).sendFile(this.controller.getRunDir((Run)run).resolve("all.json").toString()));
    }

    private void withTerminatedRun(RoutingContext ctx, String runId, Consumer<Run> consumer) {
        this.withRun(ctx, runId, run -> {
            if (!run.terminateTime.future().isComplete()) {
                ctx.response().setStatusCode(HttpResponseStatus.SEE_OTHER.code()).setStatusMessage("Run is not completed yet.").putHeader(HttpHeaders.LOCATION, (CharSequence)("/run/" + run.id)).end();
            } else {
                consumer.accept((Run)run);
            }
        });
    }

    public void getRecentStats(RoutingContext ctx, String runId) {
        this.withStats(ctx, runId, run -> {
            List<RequestStats> stats = run.statisticsStore().recentSummary(System.currentTimeMillis() - 5000L);
            this.respondWithJson(ctx, false, this.statsToJson((Run)run, stats));
        });
    }

    public void getTotalStats(RoutingContext ctx, String runId) {
        this.withStats(ctx, runId, run -> {
            List<RequestStats> stats = run.statisticsStore().totalSummary();
            this.respondWithJson(ctx, false, this.statsToJson((Run)run, stats));
        });
    }

    public void getHistogramStats(RoutingContext ctx, String runId, String phase, int stepId, String metric) {
        this.withStats(ctx, runId, run -> {
            Histogram histogram = run.statisticsStore().histogram(phase, stepId, metric);
            this.respondWithJson(ctx, false, histogram);
        });
    }

    public void getSeries(RoutingContext ctx, String runId, String phase, int stepId, String metric) {
        this.withStats(ctx, runId, run -> {
            List<StatisticsSummary> series = run.statisticsStore().series(phase, stepId, metric);
            this.respondWithJson(ctx, false, series);
        });
    }

    public void getRunFile(RoutingContext ctx, String runId, String file) {
        this.withRun(ctx, runId, run -> {
            Path runDir = this.controller.getRunDir((Run)run).toAbsolutePath();
            Path path = runDir.resolve(file).toAbsolutePath();
            if (!path.startsWith(runDir)) {
                ctx.response().setStatusCode(403).end("Requested file is not within the run directory!");
            } else if (!path.toFile().exists() || !path.toFile().isFile()) {
                ctx.response().setStatusCode(404).end("Requested file was not found");
            } else {
                ctx.response().sendFile(path.toString());
            }
        });
    }

    private void withStats(RoutingContext ctx, String runId, Consumer<Run> consumer) {
        this.withRun(ctx, runId, run -> {
            if (run.statisticsStore() == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            } else {
                consumer.accept((Run)run);
            }
        });
    }

    private RequestStatisticsResponse statsToJson(Run run, List<RequestStats> stats) {
        String status = run.terminateTime.future().isComplete() ? "TERMINATED" : (run.startTime > Long.MIN_VALUE ? "RUNNING" : "INITIALIZING");
        return new RequestStatisticsResponse(status, stats);
    }

    public void getBenchmarkForRun$text_vnd_yaml(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> {
            try {
                Benchmark benchmark = this.controller.ensureBenchmark((Run)run);
                this.sendYamlBenchmark(ctx, benchmark.source(), benchmark.version());
            }
            catch (ParserException e) {
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end(Util.explainCauses((Throwable)e));
            }
        });
    }

    public void getBenchmarkForRun$application_java_serialized_object(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> {
            try {
                this.sendSerializedBenchmark(ctx, this.controller.ensureBenchmark((Run)run));
            }
            catch (ParserException e) {
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end(Util.explainCauses((Throwable)e));
            }
        });
    }

    public void listAgents(RoutingContext ctx) {
        this.respondWithJson(ctx, true, new JsonArray(this.controller.runs.values().stream().flatMap(run -> run.agents.stream().map(agentInfo -> agentInfo.name)).distinct().collect(Collectors.toList())));
    }

    public void getControllerLog(RoutingContext ctx, long offset, long maxLength, String ifMatch) {
        if (maxLength < 0L) {
            maxLength = Long.MAX_VALUE;
        }
        String logPath = Properties.get((String)"io.hyperfoil.controller.log.file", (String)this.controller.getConfig().getString("io.hyperfoil.controller.log.file"));
        if (ifMatch != null && !ifMatch.equals(this.controller.deploymentID())) {
            ctx.response().setStatusCode(HttpResponseStatus.PRECONDITION_FAILED.code()).end();
            return;
        }
        if (this.controller.hasControllerLog()) {
            try {
                File tempFile = File.createTempFile("controller.", ".log");
                tempFile.deleteOnExit();
                this.controller.downloadControllerLog(offset, maxLength, tempFile, (Handler<AsyncResult<Void>>)((Handler)result -> {
                    if (result.succeeded()) {
                        this.sendFile(ctx, tempFile, this.controller.deploymentID());
                    } else {
                        log.error("Failed to download controller log.", result.cause());
                        ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Cannot download controller log").end();
                    }
                }));
            }
            catch (IOException e) {
                log.error("Failed to create temporary file", (Throwable)e);
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
            }
        } else {
            if (logPath == null || "/dev/null".equals(logPath)) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("Log file not defined.").end();
                return;
            }
            File logFile = new File(logPath);
            if (!logFile.exists()) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("Log file does not exist.").end();
            } else if (offset < 0L) {
                ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage("Offset must be non-negative").end();
            } else {
                ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)this.controller.deploymentID());
                ctx.response().sendFile(logPath, offset, maxLength);
            }
        }
    }

    private void sendFile(RoutingContext ctx, File tempFile, String etag) {
        ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)etag).sendFile(tempFile.toString(), r -> tempFile.delete());
    }

    public void getAgentLog(RoutingContext ctx, String agent, long offset, long maxLength, String ifMatch) {
        if (agent == null || "controller".equals(agent)) {
            this.getControllerLog(ctx, offset, maxLength, ifMatch);
            return;
        }
        if (maxLength < 0L) {
            maxLength = Long.MAX_VALUE;
        }
        if (offset < 0L) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage("Offset must be non-negative").end();
            return;
        }
        Optional agentInfo = this.controller.runs.values().stream().reduce(LAST_RUN_OPERATOR).flatMap(run -> run.agents.stream().filter(ai -> agent.equals(ai.name)).findFirst());
        if (agentInfo.isEmpty()) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("Agent " + agent + " not found.").end();
            return;
        }
        if (ifMatch != null && !ifMatch.equals(((AgentInfo)agentInfo.get()).deploymentId)) {
            ctx.response().setStatusCode(HttpResponseStatus.PRECONDITION_FAILED.code()).end();
            return;
        }
        try {
            File tempFile = File.createTempFile("agent." + agent, ".log");
            tempFile.deleteOnExit();
            this.controller.downloadAgentLog(((AgentInfo)agentInfo.get()).deployedAgent, offset, maxLength, tempFile, (Handler<AsyncResult<Void>>)((Handler)result -> {
                if (result.succeeded()) {
                    this.sendFile(ctx, tempFile, ((AgentInfo)agentInfo.get()).deploymentId);
                } else {
                    log.error("Failed to download agent log for {}", agentInfo.get(), (Object)result.cause());
                    ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Cannot download agent log").end();
                }
            }));
        }
        catch (IOException e) {
            log.error("Failed to create temporary file", (Throwable)e);
            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
        }
    }

    public void shutdown(RoutingContext ctx, boolean force) {
        List runs = this.controller.runs.values().stream().filter(run -> !run.terminateTime.future().isComplete()).collect(Collectors.toList());
        if (force) {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (Run run2 : runs) {
                Promise promise = Promise.promise();
                futures.add(promise.future());
                this.controller.kill(run2, (Handler<AsyncResult<Void>>)((Handler)result -> promise.complete()));
            }
            CompositeFuture.all(futures).onComplete(nil -> {
                ctx.response().end();
                this.controller.shutdown();
            });
        } else if (runs.isEmpty()) {
            ctx.response().end();
            this.controller.shutdown();
        } else {
            String running = runs.stream().map(run -> run.id).collect(Collectors.joining(", "));
            ctx.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).setStatusMessage("These runs are still in progress: " + running).end();
        }
    }

    public void getToken(RoutingContext ctx) {
        ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=utf-8").end(BEARER_TOKEN);
    }

    public void getVersion(RoutingContext ctx) {
        this.respondWithJson(ctx, true, new io.hyperfoil.controller.model.Version(Version.VERSION, Version.COMMIT_ID, this.controller.deploymentID(), new Date()));
    }

    public void withBenchmark(RoutingContext ctx, String name, Consumer<Benchmark> consumer) {
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            String message = "No benchmark '" + name + "'.";
            BenchmarkSource template = this.controller.getTemplate(name);
            if (template != null) {
                message = message + " There is an existing template with this name, though.";
            }
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end(message);
            return;
        }
        consumer.accept(benchmark);
    }

    static {
        PHASE_COMPARATOR = Comparator.comparing(ControllerPhase::absoluteStartTime).thenComparing(p -> p.definition().name);
        LAST_RUN_OPERATOR = (r1, r2) -> r1.id.compareTo(r2.id) > 0 ? r1 : r2;
        byte[] token = new byte[48];
        new SecureRandom().nextBytes(token);
        BEARER_TOKEN = Base64.getEncoder().encodeToString(token);
    }

    private static class BasicAuthHandler
    implements Handler<RoutingContext> {
        private BasicAuthHandler() {
        }

        public void handle(RoutingContext ctx) {
            String authorization = ctx.request().getHeader(HttpHeaders.AUTHORIZATION);
            if (authorization != null && authorization.startsWith("Basic ")) {
                byte[] credentials = Base64.getDecoder().decode(authorization.substring(6).trim());
                for (int i = 0; i < credentials.length; ++i) {
                    if (credentials[i] != 58) continue;
                    String password = new String(credentials, i + 1, credentials.length - i - 1, StandardCharsets.UTF_8);
                    if (!password.equals(CONTROLLER_PASSWORD)) break;
                    ctx.next();
                    return;
                }
                ctx.response().setStatusCode(403).end();
            } else if (authorization != null && authorization.startsWith("Bearer ")) {
                if (BEARER_TOKEN.equals(authorization.substring(7))) {
                    ctx.next();
                } else {
                    ctx.response().setStatusCode(403).end();
                }
            } else {
                ctx.response().setStatusCode(401).putHeader("WWW-Authenticate", "Basic realm=\"Hyperfoil\", charset=\"UTF-8\"").end();
            }
        }
    }
}

