/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.GlobalData;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ControllerPhase {
    private static final Logger log = LogManager.getLogger(ControllerPhase.class);
    private final Phase definition;
    private Status status = Status.NOT_STARTED;
    private long absoluteStartTime = Long.MIN_VALUE;
    private long absoluteCompletionTime = Long.MIN_VALUE;
    private boolean failed;
    private Long delayStatsCompletionUntil = null;
    private Map<String, GlobalData.Accumulator> globalData = new HashMap<String, GlobalData.Accumulator>();

    public ControllerPhase(Phase definition) {
        this.definition = definition;
    }

    public Phase definition() {
        return this.definition;
    }

    public Status status() {
        return this.status;
    }

    public long absoluteStartTime() {
        return this.absoluteStartTime;
    }

    public void status(String runId, Status status) {
        if (this.status.ordinal() < status.ordinal()) {
            log.info("{} {} changing status {} to {}", (Object)runId, (Object)this.definition.name, (Object)this.status, (Object)status);
            this.status = status;
        }
    }

    public void absoluteStartTime(long time) {
        this.absoluteStartTime = time;
    }

    public long absoluteCompletionTime() {
        return this.absoluteCompletionTime;
    }

    public void absoluteCompletionTime(long absoluteCompletionTime) {
        this.absoluteCompletionTime = absoluteCompletionTime;
    }

    public Long delayStatsCompletionUntil() {
        return this.delayStatsCompletionUntil;
    }

    public void setFailed() {
        this.failed = true;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void delayStatsCompletionUntil(long time) {
        this.delayStatsCompletionUntil = this.delayStatsCompletionUntil == null ? time : Math.max(time, this.delayStatsCompletionUntil);
    }

    public void addGlobalData(Map<String, GlobalData.Element> data) {
        if (data == null) {
            return;
        }
        for (Map.Entry<String, GlobalData.Element> entry : data.entrySet()) {
            log.debug("Received global data {} -> {}", (Object)entry.getKey(), (Object)entry.getValue());
            GlobalData.Accumulator accumulator = this.globalData.get(entry.getKey());
            if (accumulator == null) {
                accumulator = entry.getValue().newAccumulator();
                this.globalData.put(entry.getKey(), accumulator);
            }
            accumulator.add(entry.getValue());
        }
    }

    public Map<String, GlobalData.Element> completeGlobalData() {
        return this.globalData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((GlobalData.Accumulator)entry.getValue()).complete()));
    }

    static enum Status {
        NOT_STARTED,
        STARTING,
        RUNNING,
        FINISHING,
        FINISHED,
        TERMINATING,
        TERMINATED,
        CANCELLED;


        public boolean isFinished() {
            return this.ordinal() >= FINISHED.ordinal();
        }

        public boolean isTerminated() {
            return this.ordinal() >= TERMINATED.ordinal();
        }

        public boolean isStarted() {
            return this.ordinal() >= RUNNING.ordinal();
        }
    }
}

