/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.clustering.messages.ConnectionStatsMessage;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.core.util.LowHigh;
import io.vertx.core.eventbus.EventBus;
import java.util.HashMap;
import java.util.Map;

public class ConnectionStatsSender
implements ConnectionStatsConsumer {
    private final EventBus eventBus;
    private final String address;
    private final String runId;
    private Map<String, Map<String, LowHigh>> stats = new HashMap<String, Map<String, LowHigh>>();

    public ConnectionStatsSender(EventBus eb, String address, String runId) {
        this.eventBus = eb;
        this.address = address;
        this.runId = runId;
    }

    public void send() {
        this.eventBus.send("stats-feed", (Object)new ConnectionStatsMessage(this.address, this.runId, System.currentTimeMillis(), this.stats));
        this.stats = new HashMap<String, Map<String, LowHigh>>();
    }

    public void accept(String authority, String tag, int min, int max) {
        Map byTag = this.stats.computeIfAbsent(authority, a -> new HashMap());
        LowHigh lowHigh = byTag.computeIfAbsent(tag, t -> new LowHigh());
        lowHigh.low += min;
        lowHigh.high += max;
    }
}

