/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.Hyperfoil;
import io.hyperfoil.clustering.messages.AuxiliaryHello;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.Message;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.NodeListener;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseAuxiliaryVerticle
extends AbstractVerticle
implements NodeListener {
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private String nodeId = "unknown";
    private String controllerNodeId;
    private int registrationAttempt = 0;

    public void start() {
        if (this.vertx.isClustered() && this.vertx instanceof VertxInternal) {
            VertxInternal internal = (VertxInternal)this.vertx;
            if (internal.getClusterManager().getNodes().size() < 2) {
                this.log.info("Did not cluster with Hyperfoil Controller, shutting down.");
                Hyperfoil.shutdownVertx(this.vertx);
                return;
            }
            this.nodeId = internal.getClusterManager().getNodeId();
            internal.getClusterManager().nodeListener((NodeListener)this);
        }
        this.vertx.setPeriodic(1000L, timerId -> this.vertx.eventBus().request("discovery-feed", (Object)new AuxiliaryHello("CE Receiver", this.nodeId, this.deploymentID()), response -> {
            if (response.succeeded()) {
                this.log.info("Successfully registered at controller {}!", ((Message)response.result()).body());
                this.vertx.cancelTimer(timerId.longValue());
                this.controllerNodeId = (String)((Message)response.result()).body();
                this.onRegistered();
            } else if (this.registrationAttempt++ < 10) {
                this.log.info("Auxiliary registration failed (attempt {})", (Object)this.registrationAttempt);
                if (this.registrationAttempt == 10) {
                    this.log.info("Suspending registration failure logs.");
                }
            }
        }));
    }

    public void nodeAdded(String nodeID) {
    }

    public void nodeLeft(String nodeID) {
        if (Objects.equals(nodeID, this.controllerNodeId)) {
            this.log.info("Controller left the cluster, shutting down...");
            Hyperfoil.shutdownVertx(this.vertx);
        }
    }

    public void onRegistered() {
    }
}

