/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.Hyperfoil;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.clustering.ConnectionStatsSender;
import io.hyperfoil.clustering.RequestStatsSender;
import io.hyperfoil.clustering.SessionStatsSender;
import io.hyperfoil.clustering.messages.AgentControlMessage;
import io.hyperfoil.clustering.messages.AgentHello;
import io.hyperfoil.clustering.messages.AgentReadyMessage;
import io.hyperfoil.clustering.messages.ErrorMessage;
import io.hyperfoil.clustering.messages.PhaseChangeMessage;
import io.hyperfoil.clustering.messages.PhaseControlMessage;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.core.impl.SessionStatsConsumer;
import io.hyperfoil.core.impl.SimulationRunner;
import io.hyperfoil.core.util.CountDown;
import io.hyperfoil.impl.Util;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.impl.VertxInternal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentVerticle
extends AbstractVerticle {
    private static Logger log = LogManager.getLogger(AgentVerticle.class);
    private String name;
    private String deploymentId;
    private String nodeId = "in-vm";
    private String runId;
    private EventBus eb;
    private SimulationRunner runner;
    private MessageConsumer<Object> controlFeedConsumer;
    private long statsTimerId = -1L;
    private RequestStatsSender requestStatsSender;
    private CountDown statisticsCountDown;
    private SessionStatsSender sessionStatsSender;
    private ConnectionStatsSender connectionStatsSender;

    public void start() {
        this.deploymentId = this.deploymentID();
        this.name = this.context.config().getString("name");
        if (this.name == null) {
            this.name = Properties.get((String)"io.hyperfoil.agent.name", null);
        }
        if (this.name == null) {
            try {
                this.name = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                log.debug("Cannot deduce name from host name", (Throwable)e);
                this.name = this.deploymentId;
            }
        }
        this.runId = this.context.config().getString("runId");
        if (this.runId == null) {
            this.runId = Properties.get((String)"io.hyperfoil.runid", null);
            if (this.runId == null) {
                throw new IllegalStateException("No run ID defined for this agent.");
            }
        }
        this.eb = this.vertx.eventBus();
        this.eb.consumer(this.deploymentId, message -> {
            try {
                AgentControlMessage controlMessage = (AgentControlMessage)message.body();
                if (controlMessage == null) {
                    message.fail(1, "Could not decode message body. Does this Agent have the same version as the Controller?");
                    return;
                }
                this.handleAgentControlMessage((Message<Object>)message, controlMessage);
            }
            catch (Throwable t) {
                log.error("Processing of message failed", t);
                message.fail(1, t.getMessage());
            }
        });
        if (this.vertx.isClustered() && this.vertx instanceof VertxInternal) {
            this.nodeId = ((VertxInternal)this.vertx).getClusterManager().getNodeId();
        }
        this.vertx.setPeriodic(1000L, timerId -> this.eb.request("discovery-feed", (Object)new AgentHello(this.name, this.nodeId, this.deploymentId, this.runId), reply -> {
            log.trace("{} Pinging controller", (Object)this.deploymentId);
            if (reply.succeeded()) {
                log.info("{} Got reply from controller.", (Object)this.deploymentId);
                this.vertx.cancelTimer(timerId.longValue());
            } else if (reply.cause() instanceof ReplyException) {
                ReplyFailure replyFailure = ((ReplyException)reply.cause()).failureType();
                if (replyFailure == ReplyFailure.RECIPIENT_FAILURE) {
                    log.error("{} Failed to register, already registered!", (Object)this.deploymentId);
                } else {
                    log.info("{} Failed to register: {}", (Object)this.deploymentId, (Object)replyFailure);
                }
            }
        }));
    }

    private void handleAgentControlMessage(Message<Object> message, AgentControlMessage controlMessage) {
        switch (controlMessage.command()) {
            case INITIALIZE: {
                log.info("Initializing agent");
                try {
                    this.initBenchmark(controlMessage.benchmark(), controlMessage.agentId());
                    message.reply((Object)"OK");
                }
                catch (Throwable e) {
                    log.error("Failed to initialize agent", e);
                    message.fail(1, Util.explainCauses((Throwable)e));
                }
                break;
            }
            case STOP: {
                log.info("Received agent reset");
                try {
                    if (this.statsTimerId >= 0L) {
                        this.vertx.cancelTimer(this.statsTimerId);
                    }
                    CountDown completion = new CountDown(result -> {
                        message.reply(result.succeeded() ? "OK" : result.cause());
                        if (this.vertx.isClustered()) {
                            this.vertx.setTimer(1000L, id -> Hyperfoil.shutdownVertx(this.vertx));
                        } else {
                            this.vertx.undeploy(this.deploymentID());
                        }
                    }, 1);
                    if (this.runner != null) {
                        this.runner.visitStatistics((Consumer)((Object)this.requestStatsSender));
                        this.requestStatsSender.send(completion);
                        this.requestStatsSender.sendPhaseComplete(null, completion);
                        this.runner.shutdown();
                    }
                    if (this.controlFeedConsumer != null) {
                        this.controlFeedConsumer.unregister();
                    }
                    this.controlFeedConsumer = null;
                    this.runner = null;
                    this.requestStatsSender = null;
                    if (this.statisticsCountDown != null) {
                        this.statisticsCountDown.setHandler(result -> completion.countDown());
                        this.statisticsCountDown.countDown();
                        break;
                    }
                    completion.countDown();
                }
                catch (Throwable e) {
                    log.error("Exception thrown when stopping the agent", e);
                    message.reply((Object)e);
                }
                break;
            }
            case LIST_SESSIONS: {
                log.debug("Listing sessions...");
                try {
                    ArrayList sessions = new ArrayList();
                    boolean includeInactive = controlMessage.includeInactive();
                    this.runner.visitSessions(s -> {
                        if (s.isActive() || includeInactive) {
                            sessions.add(s.toString());
                        }
                    });
                    message.reply(sessions);
                }
                catch (Throwable e) {
                    log.error("Exception thrown when listing sessions", e);
                    message.reply((Object)e);
                }
                break;
            }
            case LIST_CONNECTIONS: {
                log.debug("Listing connections...");
                try {
                    message.reply((Object)this.runner.listConnections());
                    break;
                }
                catch (Throwable e) {
                    log.error("Exception thrown when listing connections", e);
                    message.reply((Object)e);
                }
            }
        }
    }

    private MessageConsumer<Object> listenOnControl() {
        return this.eb.consumer("control-feed", message -> {
            PhaseControlMessage controlMessage = (PhaseControlMessage)message.body();
            switch (controlMessage.command()) {
                case RUN: {
                    if (controlMessage.globalData() != null) {
                        this.runner.addGlobalData(controlMessage.globalData());
                    }
                    this.runner.startPhase(controlMessage.phase());
                    break;
                }
                case FINISH: {
                    this.runner.finishPhase(controlMessage.phase());
                    break;
                }
                case TRY_TERMINATE: {
                    this.runner.tryTerminatePhase(controlMessage.phase());
                    break;
                }
                case TERMINATE: {
                    this.runner.terminatePhase(controlMessage.phase());
                }
            }
        });
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.shutdown();
        }
    }

    private void initBenchmark(Benchmark benchmark, int agentId) {
        if (this.runner != null) {
            throw new IllegalStateException("Another simulation is running!");
        }
        Context context = this.vertx.getOrCreateContext();
        this.runner = new SimulationRunner(benchmark, this.runId, agentId, error -> this.eb.send("response-feed", (Object)new ErrorMessage(this.deploymentId, this.runId, (Throwable)error, false)));
        this.controlFeedConsumer = this.listenOnControl();
        this.requestStatsSender = new RequestStatsSender(benchmark, this.eb, this.deploymentId, this.runId);
        this.statisticsCountDown = new CountDown(1);
        this.sessionStatsSender = new SessionStatsSender(this.eb, this.deploymentId, this.runId);
        this.connectionStatsSender = new ConnectionStatsSender(this.eb, this.deploymentId, this.runId);
        this.runner.setControllerListener((phase, status, sessionLimitExceeded, error, globalData) -> {
            log.debug("{} changed phase {} to {}", (Object)this.deploymentId, (Object)phase, (Object)status);
            log.debug("New global data is {}", (Object)globalData);
            String cpuUsage = this.runner.getCpuUsage(phase.name());
            this.eb.send("response-feed", (Object)new PhaseChangeMessage(this.deploymentId, this.runId, phase.name(), status, sessionLimitExceeded, cpuUsage, error, globalData));
            if (status == PhaseInstance.Status.TERMINATED) {
                context.runOnContext(nil -> {
                    if (this.runner != null) {
                        this.runner.visitStatistics(phase, (Consumer)((Object)this.requestStatsSender));
                    }
                    this.requestStatsSender.send(this.statisticsCountDown);
                    this.requestStatsSender.sendPhaseComplete(phase, this.statisticsCountDown);
                });
            }
            return Util.COMPLETED_VOID_FUTURE;
        });
        this.runner.init();
        assert (context.isEventLoopContext());
        this.statsTimerId = this.vertx.setPeriodic(benchmark.statisticsCollectionPeriod(), timerId -> {
            this.runner.visitStatistics((Consumer)((Object)this.requestStatsSender));
            this.requestStatsSender.send(this.statisticsCountDown);
            this.runner.visitSessionPoolStats((SessionStatsConsumer)this.sessionStatsSender);
            this.sessionStatsSender.send();
            this.runner.visitConnectionStats((ConnectionStatsConsumer)this.connectionStatsSender);
            this.connectionStatsSender.send();
        });
        this.runner.openConnections(arg_0 -> ((Vertx)this.vertx).executeBlocking(arg_0), result -> {
            if (result.succeeded()) {
                this.eb.send("response-feed", (Object)new AgentReadyMessage(this.deploymentID(), this.runId));
            } else {
                this.eb.send("response-feed", (Object)new ErrorMessage(this.deploymentID(), this.runId, result.cause(), true));
            }
        });
    }
}

