/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil;

import io.hyperfoil.api.Version;
import io.hyperfoil.clustering.AgentVerticle;
import io.hyperfoil.clustering.Codecs;
import io.hyperfoil.clustering.ControllerVerticle;
import io.hyperfoil.internal.Properties;
import io.netty.util.ResourceLeakDetector;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.jgroups.JChannel;
import org.jgroups.protocols.TP;

public class Hyperfoil {
    static final Logger log = LogManager.getLogger(Hyperfoil.class);
    private static final Set<String> LOCALHOST_IPS = new HashSet<String>(Arrays.asList("127.0.0.1", "::1", "[::1]"));

    public static Future<Vertx> clusteredVertx(boolean isController) {
        Hyperfoil.logVersion();
        Thread.setDefaultUncaughtExceptionHandler(Hyperfoil::defaultUncaughtExceptionHandler);
        log.info("Starting Vert.x...");
        VertxOptions options = new VertxOptions();
        try {
            InetAddress address;
            String clusterIp = Properties.get((String)"io.hyperfoil.controller.cluster.ip", null);
            if (isController) {
                address = clusterIp == null ? InetAddress.getLocalHost() : InetAddress.getByName(clusterIp);
            } else {
                if (clusterIp == null) {
                    return Future.failedFuture((String)"Controller clustering IP was not set on agent/auxiliary node.");
                }
                InetAddress bestMatch = Hyperfoil.getAddressWithBestMatch(InetAddress.getByName(clusterIp));
                if (bestMatch != null) {
                    address = bestMatch;
                } else {
                    address = InetAddress.getLocalHost();
                    log.warn("No match found between controller IP ({}) and local addresses, using address {}", (Object)clusterIp, (Object)address);
                }
            }
            String hostName = address.getHostName();
            String hostAddress = address.getHostAddress();
            log.info("Using host name {}/{}", (Object)hostName, (Object)hostAddress);
            if (LOCALHOST_IPS.contains(hostAddress) && clusterIp == null) {
                log.error("This machine is configured to resolve its hostname to 127.0.0.1; this is an invalid configuration for clustering. Make sure `hostname -i` does not return 127.0.0.1 or ::1  or set -D{}=x.x.x.x to use different address. (if you set that to 127.0.0.1 you won't be able to connect from agents on other machines).", (Object)"io.hyperfoil.controller.cluster.ip");
                return Future.failedFuture((String)"Hostname resolves to 127.0.0.1");
            }
            options.getEventBusOptions().setHost(hostAddress).setClusterPublicHost(hostAddress);
            if (System.getProperty("jgroups.tcp.address") == null) {
                System.setProperty("jgroups.tcp.address", hostAddress);
            }
            String clusterPort = Properties.get((String)"io.hyperfoil.controller.cluster.port", null);
            if (isController && clusterPort != null && System.getProperty("jgroups.tcp.port") == null) {
                System.setProperty("jgroups.tcp.port", clusterPort);
            }
            if (!isController) {
                String initialHosts = clusterIp;
                if (clusterPort != null) {
                    initialHosts = String.format("%s[%s]", initialHosts, clusterPort);
                }
                log.info("Starting agent with controller: {}", (Object)initialHosts);
                System.setProperty("jgroups.tcpping.initial_hosts", initialHosts);
                System.setProperty("io.hyperfoil.cluster.jgroups_stack", "jgroups-tcp-agent.xml");
            }
        }
        catch (UnknownHostException e) {
            log.error("Cannot lookup hostname", (Throwable)e);
            return Future.failedFuture((String)"Cannot lookup hostname");
        }
        DefaultCacheManager cacheManager = Hyperfoil.createCacheManager();
        Hyperfoil.populateProperties(cacheManager);
        return Vertx.builder().with(options).withClusterManager((ClusterManager)new InfinispanClusterManager(cacheManager)).buildClustered().onSuccess(vertx -> {
            Codecs.register(vertx);
            Hyperfoil.ensureNettyResourceLeakDetection();
        }).onFailure(error -> log.error("Cannot start Vert.x", error));
    }

    private static void populateProperties(DefaultCacheManager dcm) {
        JGroupsTransport transport = (JGroupsTransport)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)dcm, Transport.class);
        JChannel channel = transport.getChannel();
        TP tp = channel.getProtocolStack().getTransport();
        System.setProperty("io.hyperfoil.controller.cluster.ip", tp.getBindAddress().getHostAddress());
        System.setProperty("io.hyperfoil.controller.cluster.port", String.valueOf(tp.getBindPort()));
        log.info("Using {}:{} as clustering address", (Object)tp.getBindAddress().getHostAddress(), (Object)tp.getBindPort());
    }

    private static InetAddress getAddressWithBestMatch(InetAddress controllerAddress) {
        InetAddress address = null;
        try {
            List allAddresses = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(nic -> {
                try {
                    return !nic.isLoopback() && nic.isUp();
                }
                catch (SocketException e) {
                    log.warn("Error enumerating NIC {}", nic, (Object)e);
                    return false;
                }
            }).flatMap(nic -> Collections.list(nic.getInetAddresses()).stream()).collect(Collectors.toList());
            log.info("Agent must choose NIC with best subnet match to controller ({}/{}), available IPs: {} (loopback is ignored)", (Object)controllerAddress.getHostName(), (Object)controllerAddress.getHostAddress(), allAddresses);
            int longestMatch = -1;
            BitSet controllerBits = BitSet.valueOf(controllerAddress.getAddress());
            for (InetAddress a : allAddresses) {
                int i;
                if (a.getAddress().length != controllerAddress.getAddress().length) {
                    log.debug("Ignoring {} as this has different address length", (Object)a);
                    continue;
                }
                BitSet aBits = BitSet.valueOf(a.getAddress());
                for (i = 0; i < aBits.length() && aBits.get(i) == controllerBits.get(i); ++i) {
                }
                log.debug("{} and {} have common prefix {} bits", (Object)controllerAddress, (Object)a, (Object)i);
                if (i <= longestMatch) continue;
                longestMatch = i;
                address = a;
            }
        }
        catch (SocketException e) {
            log.warn("Error enumerating NICs", (Throwable)e);
        }
        return address;
    }

    private static DefaultCacheManager createCacheManager() {
        DefaultCacheManager defaultCacheManager;
        block8: {
            InputStream stream = FileLookupFactory.newInstance().lookupFile("infinispan.xml", Thread.currentThread().getContextClassLoader());
            try {
                ConfigurationBuilderHolder holder = new ParserRegistry().parse(stream, MediaType.APPLICATION_XML);
                holder.getGlobalConfigurationBuilder().transport().defaultTransport().withProperties(System.getProperties()).initialClusterSize(1);
                defaultCacheManager = new DefaultCacheManager(holder, true);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Cannot load Infinispan configuration");
                    System.exit(1);
                    return null;
                }
            }
            stream.close();
        }
        return defaultCacheManager;
    }

    static void deploy(Vertx vertx, Class<? extends Verticle> verticleClass) {
        log.info("Deploying {}...", (Object)verticleClass.getSimpleName());
        vertx.deployVerticle(verticleClass, new DeploymentOptions(), event -> {
            if (event.succeeded()) {
                log.info("{} deployed.", (Object)verticleClass.getSimpleName());
            } else {
                log.error("Failed to deploy " + verticleClass.getSimpleName(), event.cause());
                System.exit(1);
            }
        });
    }

    static void ensureNettyResourceLeakDetection() {
        String leakDetectionLevel = System.getProperty("io.netty.leakDetection.level");
        if (leakDetectionLevel != null) {
            leakDetectionLevel = leakDetectionLevel.trim();
            for (ResourceLeakDetector.Level level : ResourceLeakDetector.Level.values()) {
                if (!leakDetectionLevel.equalsIgnoreCase(level.name()) && !leakDetectionLevel.equals(String.valueOf(level.ordinal()))) continue;
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
                return;
            }
            log.warn("Cannot parse Netty leak detection level '{}', use one of: {}", (Object)leakDetectionLevel, (Object)ResourceLeakDetector.Level.values());
        }
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.SIMPLE);
    }

    public static Future<Void> shutdownVertx(Vertx vertx) {
        ClusterManager clusterManager = ((VertxInternal)vertx).getClusterManager();
        DefaultCacheManager cacheManager = (DefaultCacheManager)((InfinispanClusterManager)clusterManager).getCacheContainer();
        return vertx.close().onComplete(result -> {
            try {
                cacheManager.close();
            }
            catch (IOException e) {
                log.error("Failed to close Infinispan cache manager", (Throwable)e);
            }
        });
    }

    private static void defaultUncaughtExceptionHandler(Thread thread, Throwable throwable) {
        log.error((Message)new FormattedMessage("Uncaught exception in thread {}({})", (Object)thread.getName(), (Object)thread.getId()), throwable);
    }

    private static void logVersion() {
        log.info("Java: {} {} {} {} ({}), CWD {}", (Object)System.getProperty("java.vm.vendor", "<unknown VM vendor>"), (Object)System.getProperty("java.vm.name", "<unknown VM name>"), (Object)System.getProperty("java.version", "<unknown version>"), (Object)System.getProperty("java.vm.version", "<unknown VM version>"), (Object)System.getProperty("java.home", "<unknown Java home>"), (Object)System.getProperty("user.dir", "<unknown current dir>"));
        String path = new File(Hyperfoil.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().getParent();
        log.info("Hyperfoil: {} ({})", (Object)Version.VERSION, (Object)Version.COMMIT_ID);
        log.info("           DISTRIBUTION:  {}", (Object)path);
        log.info("           ROOT_DIR:      {}", (Object)io.hyperfoil.internal.Controller.ROOT_DIR);
        log.info("           BENCHMARK_DIR: {}", (Object)io.hyperfoil.internal.Controller.BENCHMARK_DIR);
        log.info("           RUN_DIR:       {}", (Object)io.hyperfoil.internal.Controller.RUN_DIR);
        log.info("           HOOKS_DIR:     {}", (Object)io.hyperfoil.internal.Controller.HOOKS_DIR);
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(n, value) -> {
            String name = String.valueOf(n);
            if (name.startsWith("io.hyperfoil.") || name.startsWith("jgroups.")) {
                log.debug("System property {} = {}", (Object)name, value);
            }
        }));
    }

    public static class Standalone
    extends Hyperfoil {
        public static void main(String[] args) {
            Hyperfoil.logVersion();
            Thread.setDefaultUncaughtExceptionHandler(Hyperfoil::defaultUncaughtExceptionHandler);
            log.info("Starting non-clustered Vert.x...");
            Vertx vertx = Vertx.vertx();
            Standalone.ensureNettyResourceLeakDetection();
            Codecs.register(vertx);
            Standalone.deploy(vertx, ControllerVerticle.class);
        }
    }

    public static class Controller
    extends Hyperfoil {
        public static void main(String[] args) {
            Controller.clusteredVertx(true).onSuccess(vertx -> Controller.deploy(vertx, ControllerVerticle.class)).onFailure(error -> System.exit(1));
        }
    }

    public static class Agent
    extends Hyperfoil {
        public static void main(String[] args) {
            Agent.clusteredVertx(false).onSuccess(vertx -> Agent.deploy(vertx, AgentVerticle.class)).onFailure(error -> System.exit(1));
        }
    }
}

