/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Watermarks {
    private static final Logger log = LogManager.getLogger(Watermarks.class);
    protected volatile int used = 0;
    protected volatile int minUsed;
    protected volatile int maxUsed;

    public void incrementUsed() {
        assert (this.used >= 0);
        ++this.used;
        if (this.used > this.maxUsed) {
            this.maxUsed = (int)((long)this.used);
        }
    }

    public void decrementUsed() {
        this.decrementUsed(1);
    }

    public void decrementUsed(int num) {
        this.used -= num;
        if (this.used < this.minUsed) {
            this.minUsed = (int)((long)this.used);
        }
        assert (this.used >= 0);
    }

    public int minUsed() {
        return this.minUsed;
    }

    public int maxUsed() {
        return this.maxUsed;
    }

    public void resetStats() {
        this.minUsed = this.used;
        this.maxUsed = this.used;
    }

    public int current() {
        return this.used;
    }
}

