/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public class RandomConcurrentSet<T> {
    private final int maxPutLookup;
    private final int fetchAttempts;
    private final ReadWriteLock resizeLock = new ReentrantReadWriteLock();
    private volatile AtomicReferenceArray<T> fetchArray;
    private volatile AtomicReferenceArray<T> putArray;
    private volatile int reserved = 0;

    public RandomConcurrentSet(int initialCapacity, int maxPutLookup, int fetchAttempts) {
        this.maxPutLookup = maxPutLookup;
        this.fetchAttempts = fetchAttempts;
        this.putArray = new AtomicReferenceArray(initialCapacity);
        this.fetchArray = this.putArray;
    }

    public RandomConcurrentSet(int initialCapacity) {
        this(initialCapacity, 16, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T fetch() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        while (true) {
            AtomicReferenceArray<T> fetchArray = this.fetchArray;
            for (int i = 0; i < this.fetchAttempts; ++i) {
                int idx = random.nextInt(fetchArray.length());
                T element = fetchArray.get(idx);
                if (element == null || !fetchArray.compareAndSet(idx, element, null)) continue;
                return element;
            }
            if (fetchArray != this.fetchArray) continue;
            if (fetchArray == this.putArray) return null;
            Lock lock = this.resizeLock.readLock();
            lock.lock();
            try {
                this.fetchArray = this.putArray;
                continue;
            }
            finally {
                lock.unlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(T object) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Lock readLock = this.resizeLock.readLock();
        while (true) {
            readLock.lock();
            boolean isLocked = true;
            try {
                AtomicReferenceArray<T> fetchArray;
                AtomicReferenceArray<Object> putArray = this.putArray;
                for (int i = 0; i < this.maxPutLookup; ++i) {
                    int idx = random.nextInt(this.reserved, putArray.length());
                    if (putArray.get(idx) != null || !putArray.compareAndSet(idx, null, object)) continue;
                    return;
                }
                readLock.unlock();
                Lock writeLock = this.resizeLock.writeLock();
                writeLock.lock();
                try {
                    if (putArray != this.putArray) {
                        isLocked = false;
                        continue;
                    }
                    fetchArray = this.fetchArray;
                    assert (fetchArray == putArray);
                    this.reserved = putArray.length() + 1;
                    putArray = new AtomicReferenceArray(putArray.length() * 2);
                    this.putArray = putArray;
                    readLock.lock();
                }
                finally {
                    writeLock.unlock();
                    continue;
                }
                putArray.set(0, object);
                int writeIdx = 1;
                for (int i = 0; i < fetchArray.length(); ++i) {
                    T element = fetchArray.get(i);
                    if (element == null || !fetchArray.compareAndSet(i, element, null)) continue;
                    while (writeIdx < putArray.length() && !putArray.compareAndSet(writeIdx, null, element)) {
                        ++writeIdx;
                    }
                }
                this.fetchArray = putArray;
                this.reserved = 0;
                return;
            }
            finally {
                if (!isLocked) continue;
                readLock.unlock();
                continue;
            }
            break;
        }
    }

    void readAll(Consumer<T> consumer) {
        for (int i = 0; i < this.putArray.length(); ++i) {
            T element = this.putArray.get(i);
            if (element == null) continue;
            consumer.accept(element);
        }
    }
}

