/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.util;

import io.hyperfoil.api.session.Session;
import java.util.BitSet;

public interface BitSetResource
extends Session.Resource {
    public void set(int var1);

    public boolean get(int var1);

    public void clear(int var1);

    public static BitSetResource with(int nbits) {
        if (nbits == 0 || nbits == 1) {
            class SingleBitSetResource
            implements BitSetResource {
                private boolean set;

                SingleBitSetResource() {
                }

                @Override
                public void set(int index) {
                    SingleBitSetResource.validateBitIndex(index);
                    this.set = true;
                }

                private static void validateBitIndex(int index) {
                    if (index != 0) {
                        throw new IndexOutOfBoundsException();
                    }
                }

                @Override
                public boolean get(int index) {
                    SingleBitSetResource.validateBitIndex(index);
                    return this.set;
                }

                @Override
                public void clear(int index) {
                    SingleBitSetResource.validateBitIndex(index);
                    this.set = false;
                }
            }
            return new SingleBitSetResource();
        }
        class MultiBitSetResource
        extends BitSet
        implements BitSetResource {
            private final int nBits;

            MultiBitSetResource(int nbits) {
                super(nbits);
                this.nBits = nbits;
            }

            @Override
            public void set(int bitIndex) {
                this.validateBitIndex(bitIndex);
                super.set(bitIndex);
            }

            private void validateBitIndex(int bitIndex) {
                if (bitIndex >= this.nBits) {
                    throw new IndexOutOfBoundsException();
                }
            }

            @Override
            public boolean get(int bitIndex) {
                this.validateBitIndex(bitIndex);
                return super.get(bitIndex);
            }

            @Override
            public void clear(int bitIndex) {
                this.validateBitIndex(bitIndex);
                super.clear(bitIndex);
            }
        }
        return new MultiBitSetResource(nbits);
    }
}

