/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;

public class ReadAgentDataAction
implements Action {
    private final String name;
    private final ObjectAccess toVar;

    public ReadAgentDataAction(String name, ObjectAccess toVar) {
        this.name = name;
        this.toVar = toVar;
    }

    public void run(Session session) {
        session.agentData().pull(session, this.name, this.toVar);
    }

    @Name(value="readAgentData")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        private String name;
        private String toVar;

        public Builder init(String param) {
            return this.name(param).toVar(param);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public ReadAgentDataAction build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.name);
            }
            return new ReadAgentDataAction(this.name, SessionFactory.objectAccess(this.toVar));
        }
    }
}

