/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PullSharedMapStep
implements Step,
ResourceUtilizer {
    private static final Logger log = LogManager.getLogger(PullSharedMapStep.class);
    private static final boolean trace = log.isTraceEnabled();
    private final String key;
    private final ObjectAccess match;
    private final ObjectAccess[] vars;

    public PullSharedMapStep(String key, ObjectAccess match, ObjectAccess[] vars) {
        this.key = key;
        this.match = match;
        this.vars = vars;
    }

    public boolean invoke(Session session) {
        ThreadData.SharedMap sharedMap;
        if (this.match == null) {
            sharedMap = session.threadData().pullMap(this.key);
            if (sharedMap == null) {
                if (trace) {
                    log.trace("Did not find any shared map for key {}", (Object)this.key);
                }
                return true;
            }
        } else {
            Object value = this.match.getObject(session);
            sharedMap = session.threadData().pullMap(this.key, (Object)this.match, value);
            if (sharedMap == null) {
                if (trace) {
                    log.trace("Did not find any shared map for key {} matching {}={}", (Object)this.key, (Object)this.match, value);
                }
                return true;
            }
        }
        for (ObjectAccess access : this.vars) {
            Object value = sharedMap.get(access.key());
            access.setObject(session, value);
        }
        session.threadData().releaseMap(this.key, sharedMap);
        return true;
    }

    public void reserve(Session session) {
        session.threadData().reserveMap(this.key, (Object)this.match, 0);
    }

    @Name(value="pullSharedMap")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String key;
        private String match;
        private List<String> vars = new ArrayList<String>();

        public List<Step> build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.key);
            }
            if (this.vars.isEmpty()) {
                throw new BenchmarkDefinitionException("You have to set at least one variable.");
            }
            return Collections.singletonList(new PullSharedMapStep(this.key, SessionFactory.objectAccess(this.match), (ObjectAccess[])this.vars.stream().map(SessionFactory::objectAccess).toArray(ObjectAccess[]::new)));
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder match(String match) {
            this.match = match;
            return this;
        }

        public ListBuilder vars() {
            return this.vars::add;
        }
    }
}

