/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.data.SharedDataHelper;

public class PublishAgentDataAction
implements Action {
    private final String name;
    private final ReadAccess fromVar;

    public PublishAgentDataAction(String name, ReadAccess fromVar) {
        this.name = name;
        this.fromVar = fromVar;
    }

    public void run(Session session) {
        Object object = this.fromVar.getObject(session);
        object = SharedDataHelper.unwrapVars(session, object);
        session.agentData().push(session, this.name, object);
    }

    @Name(value="publishAgentData")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        private String name;
        private String fromVar;

        public Builder init(String param) {
            return this.name(param).fromVar(param);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public PublishAgentDataAction build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid name: " + this.name);
            }
            if (this.fromVar == null) {
                throw new BenchmarkDefinitionException("Must set 'fromVar'");
            }
            return new PublishAgentDataAction(this.name, SessionFactory.readAccess(this.fromVar));
        }
    }
}

