/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.data;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.function.SerializableLongBinaryOperator;
import io.hyperfoil.function.SerializableToIntFunction;
import java.io.Serializable;
import java.util.function.LongBinaryOperator;

public class AddToSharedCounterAction
implements Action,
ResourceUtilizer {
    private final String key;
    private final SerializableToIntFunction<Session> input;
    private final SerializableLongBinaryOperator operator;

    public AddToSharedCounterAction(String key, SerializableToIntFunction<Session> input, SerializableLongBinaryOperator operator) {
        this.key = key;
        this.input = input;
        this.operator = operator;
    }

    public void run(Session session) {
        ThreadData.SharedCounter counter = session.threadData().getCounter(this.key);
        counter.apply((LongBinaryOperator)this.operator, (long)this.input.applyAsInt((Object)session));
    }

    public void reserve(Session session) {
        session.threadData().reserveCounter(this.key);
    }

    public static enum Operator {
        ADD(Long::sum),
        SUBTRACT((SerializableLongBinaryOperator & Serializable)(a, b) -> a - b);

        final SerializableLongBinaryOperator operator;

        private Operator(SerializableLongBinaryOperator operator) {
            this.operator = operator;
        }
    }

    @Name(value="addToSharedCounter")
    public static class Builder
    implements Action.Builder,
    InitFromParam<Builder> {
        private String key;
        private Operator operator = Operator.ADD;
        @Embed
        public IntSourceBuilder<Builder> input = new IntSourceBuilder<Builder>(this);

        public Builder init(String param) {
            if ((param = param.trim()).endsWith("++")) {
                this.key = param.substring(0, param.length() - 2).trim();
                this.input.value(1);
            } else if (param.endsWith("--")) {
                this.key = param.substring(0, param.length() - 2).trim();
                this.input.value(-1);
            } else if (param.contains("+=")) {
                int plusEqualsIndex = param.indexOf("+=");
                this.key = param.substring(0, plusEqualsIndex).trim();
                this.input.value(Integer.parseInt(param.substring(plusEqualsIndex + 2).trim()));
            } else if (param.contains("-=")) {
                int minusEqualsIndex = param.indexOf("-=");
                this.key = param.substring(0, minusEqualsIndex).trim();
                this.input.value(-Integer.parseInt(param.substring(minusEqualsIndex + 2).trim()));
            } else {
                throw new BenchmarkDefinitionException("Accepting one of: var++, var--, var += value, var -= value");
            }
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public AddToSharedCounterAction build() {
            if (this.key == null || this.key.isEmpty()) {
                throw new BenchmarkDefinitionException("Invalid key: " + this.key);
            }
            return new AddToSharedCounterAction(this.key, this.input.build(), this.operator.operator);
        }
    }
}

