/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.collections;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.core.builders.ObjectSourceBuilder;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.function.SerializableToIntFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetItemAction
implements Action {
    private static final Logger log = LoggerFactory.getLogger(SetItemAction.class);
    private final SerializableFunction<Session, Object> item;
    private final SerializableToIntFunction<Session> index;
    private final ReadAccess toVar;

    public SetItemAction(SerializableFunction<Session, Object> item, SerializableToIntFunction<Session> index, ReadAccess toVar) {
        this.item = item;
        this.index = index;
        this.toVar = toVar;
    }

    public void run(Session session) {
        ObjectVar[] vars;
        if (!this.toVar.isSet(session)) {
            throw new IllegalStateException("Destination variable " + String.valueOf(this.toVar) + " is not set (should contain array)");
        }
        Object item = this.item.apply((Object)session);
        Object dest = this.toVar.getObject(session);
        int index = this.index.applyAsInt((Object)session);
        if (dest instanceof ObjectVar[]) {
            vars = (ObjectVar[])dest;
            if (index < 0) {
                throw new IllegalArgumentException("The index " + String.valueOf(this.index) + " = " + index + " is negative!");
            }
            if (index >= vars.length) {
                throw new IllegalArgumentException("The index " + String.valueOf(this.index) + " = " + index + " exceeds collection size (" + vars.length + ")!");
            }
        } else {
            throw new IllegalStateException("Variable " + String.valueOf(this.toVar) + " should contain ObjectVar array but it contains " + String.valueOf(dest));
        }
        vars[index].set(item);
    }

    @Name(value="setItem")
    public static class Builder
    implements Action.Builder {
        @Embed
        public ObjectSourceBuilder<Builder> item = new ObjectSourceBuilder<Builder>(this);
        private String toVar;
        private IntSourceBuilder<Builder> index = new IntSourceBuilder<Builder>(this);

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public IntSourceBuilder<Builder> index() {
            return this.index;
        }

        public SetItemAction build() {
            if (this.toVar == null) {
                throw new BenchmarkDefinitionException("Property 'toVar' must be set!");
            }
            if (this.index == null) {
                throw new BenchmarkDefinitionException("Property 'index' must be set!");
            }
            return new SetItemAction(this.item.build(), this.index.build(), SessionFactory.readAccess(this.toVar));
        }
    }
}

