/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.collections;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableToIntFunction;

public class RemoveItemAction
implements Action {
    private final ReadAccess fromVar;
    private final SerializableToIntFunction<Session> index;

    public RemoveItemAction(ReadAccess fromVar, SerializableToIntFunction<Session> index) {
        this.fromVar = fromVar;
        this.index = index;
    }

    public void run(Session session) {
        int lastIndex;
        ObjectVar[] vars;
        Object value = this.fromVar.getObject(session);
        if (value instanceof ObjectVar[]) {
            int index;
            vars = (ObjectVar[])value;
            lastIndex = index = this.index.applyAsInt((Object)session);
            int i = index + 1;
            while (i < vars.length && vars[i].isSet()) {
                vars[i - 1].set(vars[i].objectValue(session));
                lastIndex = i++;
            }
        } else {
            throw new IllegalStateException("Variable " + String.valueOf(this.fromVar) + " should contain a writable array.");
        }
        vars[lastIndex].unset();
    }

    @Name(value="removeItem")
    public static class Builder
    implements Action.Builder {
        private String fromVar;
        private IntSourceBuilder<Builder> index = new IntSourceBuilder<Builder>(this);

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public IntSourceBuilder<Builder> index() {
            return this.index;
        }

        public RemoveItemAction build() {
            if (this.fromVar == null) {
                throw new BenchmarkDefinitionException("Property 'fromVar' must be set!");
            }
            return new RemoveItemAction(SessionFactory.readAccess(this.fromVar), this.index.build());
        }
    }
}

