/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps.collections;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableToIntFunction;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetItemAction
implements Action {
    private static final Logger log = LogManager.getLogger(GetItemAction.class);
    private final ReadAccess fromVar;
    private final SerializableToIntFunction<Session> index;
    private final ObjectAccess toVar;

    public GetItemAction(ReadAccess fromVar, SerializableToIntFunction<Session> index, ObjectAccess toVar) {
        this.fromVar = fromVar;
        this.index = index;
        this.toVar = toVar;
    }

    public void run(Session session) {
        if (!this.fromVar.isSet(session)) {
            log.error("#{} Variable {} is not set", (Object)session.uniqueId(), (Object)this.fromVar);
            return;
        }
        Object obj = this.fromVar.getObject(session);
        int index = this.index.applyAsInt((Object)session);
        if (obj == null) {
            log.error("#{} Variable {} is null", (Object)session.uniqueId(), (Object)this.fromVar);
        } else if (obj.getClass().isArray()) {
            int length = Array.getLength(obj);
            if (length <= index) {
                log.error("#{} Index {} out of bounds: array in {} has {} elements", (Object)session.uniqueId(), (Object)index, (Object)this.fromVar, (Object)length);
                return;
            }
            Object item = Array.get(obj, index);
            if (item instanceof Session.Var) {
                Session.Var var = (Session.Var)item;
                if (var.isSet()) {
                    item = var.objectValue(session);
                } else {
                    log.error("#{} Cannot access {}[{}]: not set.", (Object)session.uniqueId(), (Object)this.fromVar, (Object)index);
                    return;
                }
            }
            this.toVar.setObject(session, item);
        } else if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() <= index) {
                log.error("#{} Index {} out of bounds: list in {} has {} elements", (Object)session.uniqueId(), (Object)index, (Object)this.fromVar, (Object)list.size());
                return;
            }
            this.toVar.setObject(session, list.get(index));
        } else {
            log.error("#{} Cannot retrieve item from {} = {}: not an array or list.", (Object)session.uniqueId(), (Object)this.fromVar, obj);
        }
    }

    @Name(value="getItem")
    public static class Builder
    implements Action.Builder {
        private String fromVar;
        private IntSourceBuilder<Builder> index = new IntSourceBuilder<Builder>(this);
        private String toVar;

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public IntSourceBuilder<Builder> index() {
            return this.index;
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public GetItemAction build() {
            return new GetItemAction(SessionFactory.readAccess(this.fromVar), this.index.build(), SessionFactory.objectAccess(this.toVar));
        }
    }
}

