/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableSupplier;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;

public class TimestampStep
implements Step,
ResourceUtilizer {
    private final ObjectAccess toVar;
    private final Session.ResourceKey<FormatterResource> formatterKey;
    private final SerializableSupplier<FormatterResource> formatterSupplier;

    public TimestampStep(ObjectAccess toVar, Session.ResourceKey<FormatterResource> formatterKey, SerializableSupplier<FormatterResource> formatterSupplier) {
        this.toVar = toVar;
        this.formatterKey = formatterKey;
        this.formatterSupplier = formatterSupplier;
    }

    public boolean invoke(Session session) {
        String timestamp = this.formatterKey != null ? ((FormatterResource)session.getResource(this.formatterKey)).format.format(new Date()) : String.valueOf(System.currentTimeMillis());
        this.toVar.setObject(session, (Object)timestamp);
        return true;
    }

    public void reserve(Session session) {
        if (this.formatterKey != null) {
            session.declareResource(this.formatterKey, this.formatterSupplier);
        }
    }

    private static class FormatterResource
    implements Session.Resource {
        private final SimpleDateFormat format;

        FormatterResource(String pattern, String localeCountry) {
            Locale locale = localeCountry == null || localeCountry.isBlank() ? Locale.US : Stream.of(Locale.getAvailableLocales()).filter(l -> localeCountry.equals(l.getCountry())).findFirst().orElseThrow(() -> new IllegalArgumentException("No locale with 2-letter country code '" + localeCountry + "' available."));
            this.format = new SimpleDateFormat(pattern, locale);
        }
    }

    @Name(value="timestamp")
    public static class Builder
    extends BaseStepBuilder<Builder>
    implements InitFromParam<Builder> {
        private String toVar;
        private String pattern;
        private String localeCountry;

        public Builder init(String param) {
            return this.toVar(param);
        }

        public Builder toVar(String toVar) {
            this.toVar = toVar;
            return this;
        }

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder localeCountry(String localeCountry) {
            this.localeCountry = localeCountry;
            return this;
        }

        public List<Step> build() {
            if (this.toVar == null) {
                throw new BenchmarkDefinitionException("Missing toVar attribute");
            }
            if (this.localeCountry != null && this.pattern == null) {
                throw new BenchmarkDefinitionException("Country code is used only when the formatter pattern is set.");
            }
            String myPattern = this.pattern;
            String myLocaleCountry = this.localeCountry;
            return Collections.singletonList(new TimestampStep(SessionFactory.objectAccess(this.toVar), this.pattern != null ? new FormatterKey() : null, this.pattern != null ? (SerializableSupplier & Serializable)() -> new FormatterResource(myPattern, myLocaleCountry) : null));
        }
    }

    private static final class FormatterKey
    implements Session.ResourceKey<FormatterResource> {
        private FormatterKey() {
        }
    }
}

