/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.IntAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.IntCondition;
import io.hyperfoil.core.builders.IntSourceBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableToIntFunction;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetIntAction
implements Action {
    private static final Logger log = LogManager.getLogger(SetIntAction.class);
    private static final boolean trace = log.isTraceEnabled();
    private final IntAccess var;
    private final SerializableToIntFunction<Session> input;
    private final boolean onlyIfNotSet;
    private final IntCondition condition;

    public SetIntAction(IntAccess var, SerializableToIntFunction<Session> input, boolean onlyIfNotSet, IntCondition condition) {
        this.var = var;
        this.input = input;
        this.onlyIfNotSet = onlyIfNotSet;
        this.condition = condition;
    }

    public void run(Session session) {
        if (this.onlyIfNotSet && this.var.isSet(session)) {
            if (trace) {
                int value = this.input.applyAsInt((Object)session);
                log.trace("#{} Not setting {} to {} as it is already set to {}", (Object)session.uniqueId(), (Object)this.var, (Object)value, (Object)this.var.getInt(session));
            }
            return;
        }
        if (this.condition == null || this.condition.test(session)) {
            this.var.setInt(session, this.input.applyAsInt((Object)session));
        }
    }

    @Name(value="setInt")
    public static class Builder
    implements InitFromParam<Builder>,
    Action.Builder {
        private String var;
        private Integer value;
        private String fromVar;
        private IntSourceBuilder.ListBuilder min;
        private IntSourceBuilder.ListBuilder max;
        private boolean onlyIfNotSet;
        private IntCondition.ProvidedVarBuilder<Builder> intCondition;

        public Builder init(String param) {
            int sep = param.indexOf("<-");
            if (sep < 0) {
                throw new BenchmarkDefinitionException("Invalid inline definition '" + param + "': should be 'var <- value'");
            }
            this.var = param.substring(0, sep).trim();
            try {
                this.value = Integer.parseInt(param.substring(sep + 2).trim());
            }
            catch (NumberFormatException e) {
                throw new BenchmarkDefinitionException("Cannot parse value as int: " + param.substring(sep + 2), (Throwable)e);
            }
            return this;
        }

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder value(int value) {
            this.value = value;
            return this;
        }

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public IntSourceBuilder.ListBuilder min() {
            this.min = new IntSourceBuilder.ListBuilder();
            return this.min;
        }

        public IntSourceBuilder.ListBuilder max() {
            this.max = new IntSourceBuilder.ListBuilder();
            return this.max;
        }

        public Builder onlyIfNotSet(boolean onlyIfNotSet) {
            this.onlyIfNotSet = onlyIfNotSet;
            return this;
        }

        public IntCondition.ProvidedVarBuilder<Builder> intCondition() {
            this.intCondition = new IntCondition.ProvidedVarBuilder<Builder>(this);
            return this.intCondition;
        }

        public SetIntAction build() {
            SerializableToIntFunction & Serializable input;
            if (this.var == null) {
                throw new BenchmarkDefinitionException("No variable set!");
            }
            if (Stream.of(this.value, this.fromVar, this.min, this.max).filter(Objects::nonNull).count() != 1L) {
                throw new BenchmarkDefinitionException("Must set exactly one of these properties: 'value', 'fromVar', 'min', 'max'");
            }
            if (this.value != null) {
                input = new IntSourceBuilder.ProvidedValue(this.value);
            } else if (this.fromVar != null) {
                input = new IntSourceBuilder.ValueFromVar(SessionFactory.readAccess(this.fromVar));
            } else if (this.min != null) {
                SerializableToIntFunction<Session>[] items = this.min.build();
                if (items.length == 0) {
                    throw new BenchmarkDefinitionException("Must calculate minimum from at least one item!");
                }
                input = (SerializableToIntFunction & Serializable)session -> {
                    int min = items[0].applyAsInt(session);
                    for (int i = 1; i < items.length; ++i) {
                        min = Math.min(min, items[i].applyAsInt(session));
                    }
                    return min;
                };
            } else if (this.max != null) {
                SerializableToIntFunction<Session>[] items = this.max.build();
                if (items.length == 0) {
                    throw new BenchmarkDefinitionException("Must calculate maximum from at least one item!");
                }
                input = (SerializableToIntFunction & Serializable)session -> {
                    int max = items[0].applyAsInt(session);
                    for (int i = 1; i < items.length; ++i) {
                        max = Math.max(max, items[i].applyAsInt(session));
                    }
                    return max;
                };
            } else {
                throw new IllegalStateException();
            }
            return new SetIntAction(SessionFactory.intAccess(this.var), (SerializableToIntFunction<Session>)input, this.onlyIfNotSet, this.intCondition == null ? null : this.intCondition.build(this.var));
        }
    }
}

