/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.IntVar;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableConsumer;
import io.hyperfoil.function.SerializableFunction;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class SetAction
implements Action {
    private final ObjectAccess var;
    private final SerializableFunction<Session, Object> valueSupplier;

    public SetAction(ObjectAccess var, SerializableFunction<Session, Object> valueSupplier) {
        this.var = var;
        this.valueSupplier = valueSupplier;
    }

    public void run(Session session) {
        this.var.setObject(session, this.valueSupplier.apply((Object)session));
    }

    private static class IntArraySupplier
    extends ValueSupplier<IntVar[]> {
        private final int size;
        private final ReadAccess fromVar;

        IntArraySupplier(int size, ReadAccess fromVar) {
            this.size = size;
            this.fromVar = fromVar;
        }

        @Override
        protected IntVar[] create(Session session) {
            return IntVar.newArray(session, this.size);
        }

        @Override
        public IntVar[] apply(Session session) {
            IntVar[] newArray;
            block12: {
                Session.Var var;
                block13: {
                    newArray = (IntVar[])super.apply(session);
                    if (this.fromVar == null) break block12;
                    var = this.fromVar.getVar(session);
                    if (var.type() != Session.VarType.OBJECT) break block13;
                    Object value = var.objectValue(session);
                    if (value == null) break block12;
                    if (value instanceof ObjectVar[]) {
                        session.fail((Throwable)new BenchmarkExecutionException("Type mismatch - are you trying to copy integers into objects?"));
                    } else if (value instanceof IntVar[]) {
                        IntVar[] vars = (IntVar[])value;
                        for (int i = 0; i < Math.min(this.size, vars.length); ++i) {
                            if (!vars[i].isSet()) continue;
                            newArray[i].set(vars[i].intValue(session));
                        }
                    } else if (value.getClass().isArray()) {
                        int length = Math.min(this.size, Array.getLength(value));
                        for (int i = 0; i < length; ++i) {
                            newArray[i].set(Array.getInt(value, i));
                        }
                    } else if (value instanceof List) {
                        List list = (List)value;
                        int length = Math.min(this.size, list.size());
                        for (int i = 0; i < length; ++i) {
                            newArray[i].set((Integer)list.get(i));
                        }
                    } else {
                        session.fail((Throwable)new IllegalArgumentException("Cannot use " + String.valueOf(value) + " to initialize an integer array"));
                    }
                    break block12;
                }
                int value = var.intValue(session);
                for (int i = 0; i < this.size; ++i) {
                    newArray[i].set(value);
                }
            }
            return newArray;
        }

        @Override
        protected void reset(IntVar[] object) {
        }
    }

    public static class IntArrayBuilder
    extends BaseArrayBuilder<IntArrayBuilder> {
        public IntArrayBuilder(Builder parent) {
            super(parent);
        }

        private ValueSupplier<IntVar[]> build() {
            int mySize = this.ensureNonNegativeSize();
            return new IntArraySupplier(mySize, SessionFactory.readAccess(this.fromVar));
        }
    }

    private static class ObjectArraySupplier
    extends ValueSupplier<ObjectVar[]> {
        private final int size;
        private final ReadAccess fromVar;

        ObjectArraySupplier(int size, ReadAccess fromVar) {
            this.size = size;
            this.fromVar = fromVar;
        }

        @Override
        protected ObjectVar[] create(Session session) {
            return ObjectVar.newArray(session, this.size);
        }

        @Override
        public ObjectVar[] apply(Session session) {
            ObjectVar[] newArray;
            block12: {
                Object value;
                newArray = (ObjectVar[])super.apply(session);
                if (this.fromVar == null || (value = this.fromVar.getObject(session)) == null) break block12;
                if (value instanceof ObjectVar[]) {
                    ObjectVar[] vars = (ObjectVar[])value;
                    for (int i = 0; i < Math.min(this.size, vars.length); ++i) {
                        if (!vars[i].isSet()) continue;
                        newArray[i].set(vars[i].objectValue(session));
                    }
                } else if (value instanceof IntVar[]) {
                    session.fail((Throwable)new BenchmarkExecutionException("Type mismatch - are you trying to copy integers into objects?"));
                } else if (value.getClass().isArray()) {
                    int length = Math.min(this.size, Array.getLength(value));
                    for (int i = 0; i < length; ++i) {
                        newArray[i].set(Array.get(value, i));
                    }
                } else if (value instanceof List) {
                    List list = (List)value;
                    int length = Math.min(this.size, list.size());
                    for (int i = 0; i < length; ++i) {
                        newArray[i].set(list.get(i));
                    }
                } else {
                    for (int i = 0; i < this.size; ++i) {
                        newArray[i].set(value);
                    }
                }
            }
            return newArray;
        }

        @Override
        protected void reset(ObjectVar[] object) {
            BaseArrayBuilder.resetArray(object);
        }
    }

    public static class ObjectArrayBuilder
    extends BaseArrayBuilder<ObjectArrayBuilder> {
        public ObjectArrayBuilder(Builder parent) {
            super(parent);
        }

        private ValueSupplier<ObjectVar[]> build() {
            int mySize = this.ensureNonNegativeSize();
            return new ObjectArraySupplier(mySize, SessionFactory.readAccess(this.fromVar));
        }
    }

    public static abstract class BaseArrayBuilder<S extends BaseArrayBuilder<S>>
    implements BuilderBase<S> {
        protected final Builder parent;
        protected int size;
        protected String fromVar;

        BaseArrayBuilder(Builder parent) {
            this.parent = parent;
        }

        public S size(int size) {
            this.size = size;
            return this.self();
        }

        public S fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this.self();
        }

        protected S self() {
            return (S)this;
        }

        public Builder end() {
            return this.parent;
        }

        protected int ensureNonNegativeSize() {
            if (this.size < 0) {
                throw new BenchmarkDefinitionException("Size must not be negative!");
            }
            return this.size;
        }

        protected static void resetArray(Session.Var[] array) {
            for (int i = 0; i < array.length; ++i) {
                array[i].unset();
            }
        }
    }

    private static abstract class ValueSupplier<T>
    implements SerializableFunction<Session, Object>,
    Session.ResourceKey<ValueResource<T>>,
    ResourceUtilizer {
        private ValueSupplier() {
        }

        public T apply(Session session) {
            return ((ValueResource)session.getResource((Session.ResourceKey)this)).object;
        }

        public void reserve(Session session) {
            session.declareResource((Session.ResourceKey)this, () -> new ValueResource<T>(this.create(session), this::reset));
        }

        protected abstract T create(Session var1);

        protected abstract void reset(T var1);
    }

    private static class ValueResource<T>
    implements Session.Resource {
        private final T object;
        private final SerializableConsumer<T> reset;

        ValueResource(T o, SerializableConsumer<T> reset) {
            this.object = o;
            this.reset = reset;
        }

        public void onSessionReset(Session session) {
            this.reset.accept(this.object);
        }
    }

    @Name(value="set")
    public static class Builder
    implements InitFromParam<Builder>,
    Action.Builder {
        private String var;
        private Object value;
        private ObjectArrayBuilder objectArray;
        private IntArrayBuilder intArray;

        public Builder init(String param) {
            int sep = param.indexOf("<-");
            if (sep < 0) {
                throw new BenchmarkDefinitionException("Invalid inline definition '" + param + "': should be 'var <- value'");
            }
            this.var = param.substring(0, sep).trim();
            this.value = param.substring(sep + 2).trim();
            return this;
        }

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public ObjectArrayBuilder objectArray() {
            this.objectArray = new ObjectArrayBuilder(this);
            return this.objectArray;
        }

        public IntArrayBuilder intArray() {
            this.intArray = new IntArrayBuilder(this);
            return this.intArray;
        }

        public SetAction build() {
            if (this.var == null) {
                throw new BenchmarkDefinitionException("Variable name was not set!");
            }
            if (Stream.of(this.value, this.objectArray, this.intArray).filter(Objects::nonNull).count() != 1L) {
                throw new BenchmarkDefinitionException("Must set exactly on of: value, objectArray, intArray");
            }
            if (this.value != null) {
                Object myValue = this.value;
                return new SetAction(SessionFactory.objectAccess(this.var), new ConstantValue(myValue));
            }
            if (this.objectArray != null) {
                return new SetAction(SessionFactory.objectAccess(this.var), this.objectArray.build());
            }
            return new SetAction(SessionFactory.objectAccess(this.var), this.intArray.build());
        }

        private static class ConstantValue
        implements SerializableFunction<Session, Object> {
            private final Object value;

            ConstantValue(Object value) {
                this.value = value;
            }

            public Object apply(Session s) {
                return this.value;
            }
        }
    }
}

