/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.AwaitDelayStep;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.function.SerializableToLongFunction;
import io.hyperfoil.impl.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduleDelayStep
implements Step,
ResourceUtilizer {
    private static final Logger log = LogManager.getLogger(ScheduleDelayStep.class);
    private final ObjectAccess key;
    private final Type type;
    private final SerializableToLongFunction<Session> duration;

    public ScheduleDelayStep(ObjectAccess key, Type type, SerializableToLongFunction<Session> duration) {
        this.key = key;
        this.type = type;
        this.duration = duration;
    }

    public boolean invoke(Session session) {
        Timestamp blockedUntil = (Timestamp)this.key.activate(session);
        long now = System.nanoTime();
        long baseTimestamp = switch (this.type.ordinal()) {
            case 0 -> {
                if (blockedUntil.timestamp != Long.MAX_VALUE) {
                    yield blockedUntil.timestamp;
                }
            }
            case 1 -> now;
            default -> throw new IllegalStateException();
        };
        long duration = this.duration.applyAsLong((Object)session);
        blockedUntil.timestamp = baseTimestamp + duration;
        long delay = blockedUntil.timestamp - now;
        if (delay > 0L) {
            log.trace("Scheduling #{} to run in {}", (Object)session.uniqueId(), (Object)delay);
            blockedUntil.delayExpired = session.executor().schedule(session.runTask(), delay, TimeUnit.NANOSECONDS);
        } else {
            log.trace("Continuing, duration {} resulted in delay {}", (Object)duration, (Object)delay);
        }
        return true;
    }

    public void reserve(Session session) {
        this.key.setObject(session, (Object)new Timestamp());
    }

    public static enum Type {
        FROM_LAST,
        FROM_NOW;

    }

    static class Timestamp {
        long timestamp = Long.MAX_VALUE;
        ScheduledFuture<?> delayExpired;

        Timestamp() {
        }
    }

    private static class RandomNegExpDuration
    implements SerializableToLongFunction<Session> {
        private final long duration;
        private final long max;
        private final long min;

        RandomNegExpDuration(long duration, long max, long min) {
            this.duration = duration;
            this.max = max;
            this.min = min;
        }

        public long applyAsLong(Session session) {
            double rand = ThreadLocalRandom.current().nextDouble();
            long delay = (long)((double)this.duration * -Math.log(Math.max(rand, 1.0E-20)));
            return Math.max(Math.min(delay, this.max), this.min);
        }
    }

    private static class RandomLinearDuration
    implements SerializableToLongFunction<Session> {
        private final long min;
        private final long max;

        RandomLinearDuration(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public long applyAsLong(Session session) {
            return ThreadLocalRandom.current().nextLong(this.min, this.max + 1L);
        }
    }

    private static class ConstantDuration
    implements SerializableToLongFunction<Session> {
        private final long duration;

        ConstantDuration(long duration) {
            this.duration = duration;
        }

        public long applyAsLong(Session session) {
            return this.duration;
        }
    }

    @Name(value="thinkTime")
    public static class ThinkTimeBuilder
    extends Builder
    implements InitFromParam<ThinkTimeBuilder> {
        @Override
        public ThinkTimeBuilder addTo(BaseSequenceBuilder<?> parent) {
            return (ThinkTimeBuilder)super.addTo(parent);
        }

        @Override
        public void prepareBuild() {
            this.key = new Unique();
            this.keyAccess = Locator.current().sequence().rootSequence().concurrency() > 0 ? SessionFactory.sequenceScopedObjectAccess(this.key) : SessionFactory.objectAccess(this.key);
        }

        @Override
        public List<Step> build() {
            return Arrays.asList(super.build().get(0), new AwaitDelayStep((ReadAccess)this.keyAccess));
        }

        public ThinkTimeBuilder init(String param) {
            this.duration(param);
            return this;
        }
    }

    @Name(value="scheduleDelay")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        protected Object key;
        protected ObjectAccess keyAccess;
        private long duration;
        private Type type = Type.FROM_NOW;
        private RandomType randomType = RandomType.CONSTANT;
        private long min = 0L;
        private long max = Long.MAX_VALUE;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder duration(long duration, TimeUnit timeUnit) {
            this.duration = timeUnit == null ? 0L : timeUnit.toNanos(duration);
            return this;
        }

        public Builder duration(String duration) {
            this.duration = Util.parseToNanos((String)duration);
            return this;
        }

        public Builder fromNow() {
            this.type = Type.FROM_NOW;
            return this;
        }

        public Builder fromLast() {
            this.type = Type.FROM_LAST;
            return this;
        }

        public Builder random(RandomType randomType) {
            this.randomType = randomType;
            return this;
        }

        public Builder min(long min, TimeUnit timeUnit) {
            this.min = timeUnit.toMillis(min);
            return this;
        }

        public Builder min(String min) {
            this.min = Util.parseToMillis((String)min);
            return this;
        }

        public Builder max(long max, TimeUnit timeUnit) {
            this.max = timeUnit.toMillis(max);
            return this;
        }

        public Builder max(String max) {
            this.max = Util.parseToMillis((String)max);
            return this;
        }

        public void prepareBuild() {
            if (this.key == null) {
                throw new BenchmarkDefinitionException("Key was not defined.");
            }
            this.keyAccess = SessionFactory.objectAccess(this.key);
        }

        public List<Step> build() {
            long duration = this.duration;
            long min = this.min;
            long max = this.max;
            return Collections.singletonList(new ScheduleDelayStep(this.keyAccess, this.type, (SerializableToLongFunction<Session>)(switch (this.randomType.ordinal()) {
                case 0 -> {
                    if (this.min != 0L || this.max != Long.MAX_VALUE) {
                        throw new BenchmarkDefinitionException("This duration should be constant; no need to define 'min' and 'max'.");
                    }
                    if (this.duration <= 0L) {
                        throw new BenchmarkDefinitionException("Duration must be positive.");
                    }
                    yield new ConstantDuration(duration);
                }
                case 1 -> {
                    if (this.duration != 0L) {
                        throw new BenchmarkDefinitionException("The duration is set through 'min' and 'max'; do not use 'duration'");
                    }
                    if (this.min < 0L) {
                        throw new BenchmarkDefinitionException("The minimum duration must not be lower than 0.");
                    }
                    if (this.max > TimeUnit.HOURS.toMillis(24L)) {
                        throw new BenchmarkDefinitionException("The maximum duration is over 24 hours: that's likely an error.");
                    }
                    yield new RandomLinearDuration(min, max);
                }
                case 2 -> new RandomNegExpDuration(duration, max, min);
                default -> throw new BenchmarkDefinitionException("Unknown randomness type: " + String.valueOf((Object)this.randomType));
            })));
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }
    }

    public static enum RandomType {
        CONSTANT,
        LINEAR,
        NEGATIVE_EXPONENTIAL;

    }
}

