/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import java.util.Collections;
import java.util.List;

public class RestartSequenceStep
implements Step {
    private final Session.ResourceKey<Trigger> triggerKey;

    public static Session.ResourceKey<Trigger> createTriggerKey() {
        return new Session.ResourceKey<Trigger>(){};
    }

    public RestartSequenceStep(Session.ResourceKey<Trigger> triggerKey) {
        this.triggerKey = triggerKey;
    }

    public boolean invoke(Session session) {
        if (this.triggerKey != null) {
            Trigger trigger = (Trigger)session.getResource(this.triggerKey);
            if (!trigger.restart) {
                return true;
            }
            trigger.restart = false;
        }
        session.currentSequence().restart(session);
        return true;
    }

    public static class Trigger
    implements Session.Resource {
        public boolean restart;
    }

    @Name(value="restartSequence")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        public List<Step> build() {
            return Collections.singletonList(new RestartSequenceStep(null));
        }
    }
}

