/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.steps.BreakSequenceStep;
import io.hyperfoil.core.steps.RestartSequenceStep;

public class RestartSequenceAction
implements Action,
ResourceUtilizer {
    private final Session.ResourceKey<RestartSequenceStep.Trigger> triggerKey;

    public RestartSequenceAction(Session.ResourceKey<RestartSequenceStep.Trigger> triggerKey) {
        this.triggerKey = triggerKey;
    }

    public void run(Session session) {
        ((RestartSequenceStep.Trigger)session.getResource(this.triggerKey)).restart = true;
    }

    public void reserve(Session session) {
        session.declareResource(this.triggerKey, RestartSequenceStep.Trigger::new);
    }

    @Name(value="restartSequence")
    public static class Builder
    implements Action.Builder {
        private Session.ResourceKey<RestartSequenceStep.Trigger> triggerKey;

        public void prepareBuild() {
            Locator locator = Locator.current();
            if (locator.step() instanceof BreakSequenceStep.Builder) {
                throw new BenchmarkDefinitionException("Restarting sequence this way from `breakSequence` does not work as this action adds subsequent step; use `conditional` instead.");
            }
            this.triggerKey = RestartSequenceStep.createTriggerKey();
            locator.sequence().insertAfter(locator).step((Step)new RestartSequenceStep(this.triggerKey));
        }

        public RestartSequenceAction build() {
            return new RestartSequenceAction(this.triggerKey);
        }
    }
}

