/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class ReadonlyWrappingByteBuf
extends AbstractReferenceCountedByteBuf {
    private byte[] array;

    protected ReadonlyWrappingByteBuf() {
        super(0);
    }

    public ReadonlyWrappingByteBuf wrap(byte[] array) {
        this.array = array;
        this.writerIndex(array.length);
        this.maxCapacity(array.length);
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected byte _getByte(int index) {
        return this.array[index];
    }

    protected short _getShort(int index) {
        return (short)(this.array[index] << 8 | this.array[index + 1] & 0xFF);
    }

    protected short _getShortLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected int _getUnsignedMedium(int index) {
        throw new UnsupportedOperationException();
    }

    protected int _getUnsignedMediumLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected int _getInt(int index) {
        return (this.array[index] & 0xFF) << 24 | (this.array[index + 1] & 0xFF) << 16 | (this.array[index + 2] & 0xFF) << 8 | this.array[index + 3] & 0xFF;
    }

    protected int _getIntLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected long _getLong(int index) {
        return ((long)this.array[index] & 0xFFL) << 56 | ((long)this.array[index + 1] & 0xFFL) << 48 | ((long)this.array[index + 2] & 0xFFL) << 40 | ((long)this.array[index + 3] & 0xFFL) << 32 | ((long)this.array[index + 4] & 0xFFL) << 24 | ((long)this.array[index + 5] & 0xFFL) << 16 | ((long)this.array[index + 6] & 0xFFL) << 8 | (long)this.array[index + 7] & 0xFFL;
    }

    protected long _getLongLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected void _setByte(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setShort(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setShortLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setMedium(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setMediumLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setInt(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setIntLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setLong(int index, long value) {
        throw new UnsupportedOperationException();
    }

    protected void _setLongLE(int index, long value) {
        throw new UnsupportedOperationException();
    }

    public int capacity() {
        return this.array.length;
    }

    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException();
    }

    public ByteBufAllocator alloc() {
        return PooledByteBufAllocator.DEFAULT;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public ByteBuf unwrap() {
        return null;
    }

    public boolean isDirect() {
        return false;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasMemoryAddress()) {
            PlatformDependent.copyMemory((byte[])this.array, (int)index, (long)(dst.memoryAddress() + (long)dstIndex), (long)length);
        } else if (dst.hasArray()) {
            this.getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, this.array, index, length);
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        System.arraycopy(this.array, index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        dst.put(this.array, index, dst.remaining());
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        out.write(this.array, index, length);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        ByteBuffer tmpBuf = ByteBuffer.wrap(this.array);
        return out.write(tmpBuf.clear().position(index).limit(index + length));
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        ByteBuffer tmpBuf = ByteBuffer.wrap(this.array);
        return out.write(tmpBuf.clear().position(index).limit(index + length), position);
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, InputStream in, int length) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, FileChannel in, long position, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public int nioBufferCount() {
        return 0;
    }

    public ByteBuffer nioBuffer(int index, int length) {
        if (index < 0 || length < 0 || index + length > this.array.length) {
            throw new IllegalArgumentException();
        }
        return ByteBuffer.wrap(this.array, index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        return null;
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public boolean hasArray() {
        return true;
    }

    public byte[] array() {
        return this.array;
    }

    public int arrayOffset() {
        return 0;
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        return 0L;
    }

    protected void deallocate() {
        this.array = EmptyArrays.EMPTY_BYTES;
    }
}

