/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.ListBuilder;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.Pattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogAction
implements Action {
    private static final Logger log = LogManager.getLogger(LogAction.class);
    private final Pattern message;

    public LogAction(Pattern message) {
        this.message = message;
    }

    public void run(Session session) {
        log.info(this.message.apply(session));
    }

    @Name(value="log")
    public static class Builder<P>
    implements Action.Builder,
    InitFromParam<Builder<P>> {
        String message;
        List<String> vars = new ArrayList<String>();

        public Builder<P> init(String param) {
            return this.message(param);
        }

        public Builder<P> message(String message) {
            this.message = message;
            return this;
        }

        @Deprecated
        public ListBuilder vars() {
            return this.vars::add;
        }

        public Builder<P> addVar(String var, Void ignored) {
            this.vars.add(var);
            return this;
        }

        public LogAction build() {
            if (this.message == null) {
                throw new BenchmarkDefinitionException("Missing message");
            }
            if (this.vars.isEmpty()) {
                return new LogAction(new Pattern(this.message, false, true));
            }
            StringBuilder msgBuilder = new StringBuilder();
            int from = 0;
            for (String var : this.vars) {
                int index = this.message.indexOf("{}", from);
                if (index >= 0) {
                    msgBuilder.append(this.message, from, index);
                    msgBuilder.append("${").append(var).append("}");
                    from = index + 2;
                    continue;
                }
                throw new BenchmarkDefinitionException("Missing position for variable " + var + " ('{}') in log message '" + this.message + "'");
            }
            msgBuilder.append(this.message.substring(from));
            return new LogAction(new Pattern(msgBuilder.toString(), false, true));
        }
    }
}

