/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.handlers.json.ByteArrayByteStream;
import io.hyperfoil.core.handlers.json.ByteStream;
import io.hyperfoil.core.handlers.json.JsonParser;
import io.hyperfoil.core.handlers.json.JsonUnquotingTransformer;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.ReadonlyWrappingByteBuf;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class JsonStep
implements Step {
    private final ByteArrayParser byteArrayParser;
    private final ReadAccess fromVar;

    private JsonStep(ReadAccess fromVar, String query, boolean delete, Transformer replace, Processor processor) {
        this.fromVar = fromVar;
        this.byteArrayParser = new ByteArrayParser(query, delete, replace, processor);
    }

    public boolean invoke(Session session) {
        Object object = this.fromVar.getObject(session);
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            if (array.length == 0) {
                return true;
            }
        } else {
            throw new IllegalStateException("Unexpected format of input (expecting byte[]): " + String.valueOf(object));
        }
        ByteArrayParser.Context ctx = (ByteArrayParser.Context)session.getResource((Session.ResourceKey)this.byteArrayParser);
        this.byteArrayParser.before(session);
        ctx.parse(ctx.wrap((byte[])object), session, true);
        this.byteArrayParser.after(session);
        ctx.reset();
        return true;
    }

    private static class ByteArrayParser
    extends JsonParser
    implements ResourceUtilizer,
    Session.ResourceKey<Context> {
        ByteArrayParser(String query, boolean delete, Transformer replace, Processor processor) {
            super(query, delete, replace, processor);
        }

        public void reserve(Session session) {
            session.declareResource((Session.ResourceKey)this, () -> new Context());
        }

        @Override
        protected void record(JsonParser.Context context, Session session, ByteStream data, int offset, int length, boolean isLastPart) {
            Context ctx = (Context)context;
            byte[] array = ((ByteArrayByteStream)data).array();
            this.processor.process(session, (ByteBuf)ctx.buffer.wrap(array), offset, length, isLastPart);
        }

        public void before(Session session) {
            this.processor.before(session);
            if (this.replace != null) {
                this.replace.before(session);
            }
        }

        public void after(Session session) {
            if (this.replace != null) {
                this.replace.after(session);
            }
            this.processor.after(session);
        }

        public class Context
        extends JsonParser.Context {
            ReadonlyWrappingByteBuf buffer;
            ByteArrayByteStream actualStream;
            boolean set;

            protected Context() {
                super(self -> new ByteArrayByteStream(null, self::release));
                this.buffer = new ReadonlyWrappingByteBuf();
                this.actualStream = new ByteArrayByteStream(this::retain, null);
            }

            @Override
            public void reset() {
                super.reset();
                this.set = false;
            }

            @Override
            protected void replaceConsumer(Void ignored, Session session, ByteStream data, int offset, int length, boolean lastFragment) {
                ByteArrayParser.this.replace.transform(session, (ByteBuf)this.buffer.wrap(((ByteArrayByteStream)data).array()), offset, length, lastFragment, this.replaceBuffer);
            }

            public ByteStream wrap(byte[] object) {
                return this.actualStream.wrap(object);
            }
        }
    }

    @Name(value="json")
    public static class Builder
    extends JsonParser.BaseBuilder<Builder>
    implements StepBuilder<Builder> {
        private BaseSequenceBuilder<?> parent;
        private String fromVar;

        public Builder fromVar(String fromVar) {
            this.fromVar = fromVar;
            return this;
        }

        public List<Step> build() {
            Transformer replace;
            this.validate();
            if (this.fromVar == null) {
                throw new BenchmarkDefinitionException("jsonQuery missing 'fromVar'");
            }
            Processor processor = this.processors.build(this.unquote);
            Transformer transformer = replace = this.replace == null ? null : this.replace.build(this.unquote);
            if (this.unquote) {
                processor = processor == null ? null : new JsonUnquotingTransformer(processor);
                replace = replace == null ? null : new JsonUnquotingTransformer(replace);
            }
            return Collections.singletonList(new JsonStep(SessionFactory.readAccess(this.fromVar), this.query, this.delete, replace, processor));
        }

        public Builder addTo(BaseSequenceBuilder<?> parent) {
            if (this.parent != null) {
                throw new UnsupportedOperationException("Cannot add builder " + this.getClass().getName() + " to another sequence!");
            }
            parent.stepBuilder((StepBuilder)this);
            this.parent = Objects.requireNonNull(parent);
            return (Builder)this.self();
        }
    }
}

