/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.ScheduleDelayStep;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class AwaitDelayStep
implements Step {
    private final ReadAccess key;

    public AwaitDelayStep(ReadAccess key) {
        this.key = key;
    }

    public boolean invoke(Session session) {
        ScheduledFuture<?> expirationTask;
        boolean canProgress;
        ScheduleDelayStep.Timestamp blockedUntil = (ScheduleDelayStep.Timestamp)this.key.getObject(session);
        boolean bl = canProgress = System.nanoTime() - blockedUntil.timestamp >= 0L;
        if (canProgress && (expirationTask = blockedUntil.delayExpired) != null) {
            expirationTask.cancel(false);
            blockedUntil.delayExpired = null;
        }
        return canProgress;
    }

    @Name(value="awaitDelay")
    public static class Builder
    extends BaseStepBuilder<Builder>
    implements InitFromParam<Builder> {
        private Object key;

        public Builder init(String param) {
            return this.key(param);
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public List<Step> build() {
            return Collections.singletonList(new AwaitDelayStep(SessionFactory.readAccess(this.key)));
        }
    }
}

