/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.steps;

import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableBiPredicate;
import io.hyperfoil.function.SerializablePredicate;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class AwaitConditionStep
implements Step {
    private final SerializablePredicate<Session> condition;

    public AwaitConditionStep(SerializablePredicate<Session> condition) {
        this.condition = condition;
    }

    public boolean invoke(Session session) {
        return this.condition.test((Object)session);
    }

    public static class Builder
    extends BaseStepBuilder<Builder> {
        private final String var;
        private final SerializableBiPredicate<Session, ReadAccess> predicate;

        public Builder(String var, SerializableBiPredicate<Session, ReadAccess> predicate) {
            this.var = var;
            this.predicate = predicate;
        }

        public Builder copy(Object newParent) {
            return this;
        }

        public List<Step> build() {
            ReadAccess access = SessionFactory.readAccess(this.var);
            return Collections.singletonList(new AwaitConditionStep((SerializablePredicate<Session>)(SerializablePredicate & Serializable)s -> this.predicate.test(s, (Object)access)));
        }
    }
}

