/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.function.SerializableToIntFunction;
import java.io.Serializable;
import java.util.Objects;

abstract class SpecialAccess
implements ReadAccess {
    final String name;

    SpecialAccess(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public boolean isSequenceScoped() {
        return false;
    }

    public java.lang.Object key() {
        return null;
    }

    public void setIndex(int index) {
        throw new UnsupportedOperationException();
    }

    public int index() {
        throw new UnsupportedOperationException();
    }

    public boolean isSet(Session session) {
        return true;
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof ReadAccess) {
            return this.name.equals(((ReadAccess)obj).key());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    static class Object
    extends SpecialAccess {
        private final SerializableFunction<Session, java.lang.Object> supplier;
        private final Var var = new Var();

        Object(String name, SerializableFunction<Session, java.lang.Object> supplier) {
            super(name);
            this.supplier = supplier;
        }

        @Override
        public boolean isSet(Session session) {
            return true;
        }

        public java.lang.Object getObject(Session session) {
            return this.supplier.apply((java.lang.Object)session);
        }

        public int getInt(Session session) {
            throw new UnsupportedOperationException("Cannot retrieve " + this.name + " as integer");
        }

        public Session.Var getVar(Session session) {
            return this.var;
        }

        private class Var
        extends BaseVar {
            private Var() {
            }

            public Session.VarType type() {
                return Session.VarType.OBJECT;
            }

            public java.lang.Object objectValue(Session session) {
                return Object.this.supplier.apply((java.lang.Object)session);
            }
        }
    }

    static class Int
    extends SpecialAccess {
        private final SerializableToIntFunction<Session> supplier;
        private final Var var = new Var();

        Int(String name, SerializableToIntFunction<Session> supplier) {
            super(name);
            this.supplier = supplier;
        }

        public Object getObject(Session session) {
            throw new UnsupportedOperationException("Cannot retrieve " + this.name + " as object");
        }

        public int getInt(Session session) {
            return this.supplier.applyAsInt((java.lang.Object)session);
        }

        public Session.Var getVar(Session session) {
            return this.var;
        }

        private class Var
        extends BaseVar {
            private Var() {
            }

            public Session.VarType type() {
                return Session.VarType.INTEGER;
            }

            public int intValue(Session session) {
                return Int.this.supplier.applyAsInt((java.lang.Object)session);
            }
        }
    }

    private abstract class BaseVar
    implements Session.Var,
    Serializable {
        private BaseVar() {
        }

        public boolean isSet() {
            return true;
        }

        public void unset() {
            throw new UnsupportedOperationException("Cannot unset " + SpecialAccess.this.name + "; it is read-only.");
        }

        public String toString() {
            return "(special:" + SpecialAccess.this.name + ")";
        }
    }
}

