/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionImpl;
import io.hyperfoil.core.session.SimpleReadAccess;
import io.hyperfoil.impl.Util;

class SimpleObjectAccess
extends SimpleReadAccess
implements ObjectAccess {
    SimpleObjectAccess(Object key) {
        super(key);
    }

    public Session.Var createVar(Session session, Session.Var existing) {
        if (existing == null) {
            return new ObjectVar((SessionImpl)session);
        }
        if (existing instanceof ObjectVar) {
            return existing;
        }
        throw new BenchmarkDefinitionException("Variable " + String.valueOf(this.key) + " should hold an object but it is defined to hold an integer elsewhere.");
    }

    public void setObject(Session session, Object value) {
        SessionImpl impl = (SessionImpl)session;
        if (trace) {
            log.trace("#{} {} <- {}", (Object)impl.uniqueId(), this.key, (Object)Util.prettyPrintObject((Object)value));
        }
        ObjectVar var = (ObjectVar)impl.getVar(this.index);
        var.value = value;
        var.set = true;
    }

    public Object activate(Session session) {
        SessionImpl impl = (SessionImpl)session;
        ObjectVar var = (ObjectVar)impl.getVar(this.index);
        var.set = true;
        return var.objectValue(session);
    }

    public void unset(Session session) {
        SessionImpl impl = (SessionImpl)session;
        impl.getVar(this.index).unset();
    }
}

