/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.collection.LimitedPool;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.AgentData;
import io.hyperfoil.api.session.GlobalData;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.api.statistics.SessionStatistics;
import io.hyperfoil.api.statistics.Statistics;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

class SessionImpl
implements Session {
    private static final Logger log = LogManager.getLogger(SessionImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Session.Var[] vars;
    private final Map<Session.ResourceKey<?>, Object> resources = new HashMap();
    private final List<Session.Var> allVars = new ArrayList<Session.Var>();
    private final List<Session.Resource> allResources = new ArrayList<Session.Resource>();
    private final LimitedPool<SequenceInstance> sequencePool;
    private final SequenceInstance[] runningSequences;
    private final BitSet usedSequences;
    private final Consumer<SequenceInstance> releaseSequence = this::releaseSequence;
    private PhaseInstance phase;
    private int lastRunningSequence = -1;
    private SequenceInstance currentSequence;
    private Request currentRequest;
    private boolean scheduled;
    private boolean resetting = true;
    private EventExecutor executor;
    private ThreadData threadData;
    private AgentData agentData;
    private GlobalData globalData;
    private SessionStatistics statistics;
    private final int threadId;
    private final int uniqueId;
    private final Runnable deferredStart = this::deferredStart;
    private final Runnable runTask = this::run;

    SessionImpl(Scenario scenario, int threadId, int uniqueId) {
        this.sequencePool = new LimitedPool(scenario.maxSequences(), SequenceInstance::new);
        this.threadId = threadId;
        this.runningSequences = new SequenceInstance[scenario.maxSequences()];
        this.usedSequences = new BitSet(scenario.sumConcurrency());
        this.uniqueId = uniqueId;
        this.vars = scenario.createVars((Session)this);
    }

    public void reserve(Scenario scenario) {
        Sequence[] sequences = scenario.sequences();
        for (int i = 0; i < sequences.length; ++i) {
            Sequence sequence = sequences[i];
            this.currentSequence(((SequenceInstance)this.sequencePool.acquire()).reset(sequence, 0, null, null));
            sequence.reserve((Session)this);
            this.sequencePool.release((Object)this.currentSequence);
            this.currentSequence = null;
        }
    }

    public Runnable runTask() {
        return this.runTask;
    }

    public int uniqueId() {
        return this.uniqueId;
    }

    public int agentThreadId() {
        return this.threadId;
    }

    public int agentThreads() {
        return this.phase.agentThreads();
    }

    public int globalThreadId() {
        return this.phase.agentFirstThreadId() + this.threadId;
    }

    public int globalThreads() {
        Benchmark benchmark = this.phase.definition().benchmark();
        return benchmark.totalThreads();
    }

    public int agentId() {
        return this.phase.agentId();
    }

    public int agents() {
        return this.phase.definition().benchmark().agents().length;
    }

    public String runId() {
        return this.phase.runId();
    }

    public EventExecutor executor() {
        return this.executor;
    }

    public ThreadData threadData() {
        return this.threadData;
    }

    public AgentData agentData() {
        return this.agentData;
    }

    public GlobalData globalData() {
        return this.globalData;
    }

    public PhaseInstance phase() {
        return this.phase;
    }

    public long phaseStartTimestamp() {
        return this.phase.absoluteStartTime();
    }

    void registerVar(Session.Var var) {
        this.allVars.add(var);
    }

    public <R extends Session.Resource> void declareResource(Session.ResourceKey<R> key, Supplier<R> resourceSupplier) {
        this.declareResource(key, resourceSupplier, false);
    }

    public <R extends Session.Resource> void declareResource(Session.ResourceKey<R> key, Supplier<R> resourceSupplier, boolean singleton) {
        int concurrency;
        if (this.resources.containsKey(key)) {
            return;
        }
        int n = concurrency = this.currentSequence == null ? 0 : this.currentSequence.definition().concurrency();
        if (!singleton && concurrency > 0) {
            Session.Resource[] array = new Session.Resource[concurrency];
            for (int i = 0; i < concurrency; ++i) {
                Session.Resource resource;
                array[i] = resource = (Session.Resource)resourceSupplier.get();
                this.allResources.add(resource);
            }
            this.resources.put(key, array);
        } else {
            Session.Resource resource = (Session.Resource)resourceSupplier.get();
            this.resources.put(key, resource);
            this.allResources.add(resource);
        }
    }

    public <R extends Session.Resource> void declareSingletonResource(Session.ResourceKey<R> key, R resource) {
        if (this.resources.containsKey(key)) {
            return;
        }
        this.resources.put(key, resource);
        this.allResources.add(resource);
    }

    public <R extends Session.Resource> R getResource(Session.ResourceKey<R> key) {
        Object res = this.resources.get(key);
        if (res == null) {
            return null;
        }
        if (res.getClass().isArray() && res instanceof Session.Resource[]) {
            Session.Resource[] array = (Session.Resource[])res;
            return (R)array[this.currentSequence.index()];
        }
        return (R)((Session.Resource)res);
    }

    <V extends Session.Var> V getVar(int index) {
        return (V)this.vars[index];
    }

    <V extends Session.Var> V requireSet(int index, Object key) {
        Session.Var var = this.vars[index];
        if (!var.isSet()) {
            throw new IllegalStateException("Variable " + String.valueOf(key) + " was not set yet!");
        }
        return (V)var;
    }

    private void run() {
        block3: {
            this.scheduled = false;
            try {
                this.runSession();
            }
            catch (SessionStopException e) {
                log.trace("#{} Session was stopped.", (Object)this.uniqueId);
            }
            catch (Throwable t) {
                log.error((Message)new FormattedMessage("#{} Uncaught error", (Object)this.uniqueId), t);
                if (this.phase == null) break block3;
                this.phase.fail(t);
            }
        }
    }

    public void runSession() {
        if (this.phase.status() == PhaseInstance.Status.TERMINATED) {
            if (trace) {
                log.trace("#{} Phase is terminated", (Object)this.uniqueId);
            }
            return;
        }
        if (this.lastRunningSequence < 0) {
            if (trace) {
                log.trace("#{} No sequences to run, ignoring.", (Object)this.uniqueId);
            }
            return;
        }
        if (trace) {
            log.trace("#{} Run ({} running sequences)", (Object)this.uniqueId, (Object)(this.lastRunningSequence + 1));
        }
        int lastProgressedSequence = -1;
        while (this.lastRunningSequence >= 0) {
            boolean progressed = false;
            for (int i = 0; i <= this.lastRunningSequence; ++i) {
                if (this.phase.status() == PhaseInstance.Status.TERMINATING) {
                    if (trace) {
                        log.trace("#{} Phase {} is terminating", (Object)this.uniqueId, (Object)this.phase.definition().name());
                    }
                    this.stop();
                    return;
                }
                if (lastProgressedSequence == i) break;
                SequenceInstance sequence = this.runningSequences[i];
                if (sequence == null || !sequence.progress((Session)this)) continue;
                progressed = true;
                lastProgressedSequence = i;
                if (!sequence.isCompleted()) continue;
                if (trace) {
                    log.trace("#{} Completed {}({})", (Object)this.uniqueId, (Object)sequence, (Object)sequence.index());
                }
                if (this.lastRunningSequence == -1) {
                    log.trace("#{} was stopped.", (Object)this.uniqueId);
                    return;
                }
                sequence.decRefCnt((Session)this);
                if (i >= this.lastRunningSequence) {
                    this.runningSequences[i] = null;
                } else {
                    this.runningSequences[i] = this.runningSequences[this.lastRunningSequence];
                    this.runningSequences[this.lastRunningSequence] = null;
                }
                --this.lastRunningSequence;
                lastProgressedSequence = -1;
            }
            if (progressed || this.lastRunningSequence < 0) continue;
            if (trace) {
                log.trace("#{} ({}) no progress, not finished.", (Object)this.uniqueId, (Object)this.phase.definition().name());
            }
            return;
        }
        if (trace) {
            log.trace("#{} Session finished", (Object)this.uniqueId);
        }
        if (!this.resetting) {
            this.reset();
            this.phase.notifyFinished((Session)this);
        }
    }

    private void releaseSequence(SequenceInstance sequence) {
        this.usedSequences.clear(sequence.definition().offset() + sequence.index());
        this.sequencePool.release((Object)sequence);
    }

    public void currentSequence(SequenceInstance current) {
        if (trace) {
            log.trace("#{} Changing sequence {} -> {}", (Object)this.uniqueId, (Object)this.currentSequence, (Object)current);
        }
        this.currentSequence = current;
    }

    public SequenceInstance currentSequence() {
        return this.currentSequence;
    }

    public void attach(EventExecutor executor, ThreadData threadData, AgentData agentData, GlobalData globalData, SessionStatistics statistics) {
        assert (this.executor == null);
        this.executor = executor;
        this.threadData = threadData;
        this.agentData = agentData;
        this.globalData = globalData;
        this.statistics = statistics;
    }

    public void start(PhaseInstance phase) {
        if (trace) {
            log.trace("#{} Session starting in {}", (Object)this.uniqueId, (Object)phase.definition().name);
        }
        this.resetPhase(phase);
        this.executor.execute(this.deferredStart);
    }

    private Void deferredStart() {
        this.resetting = false;
        for (Sequence sequence : this.phase.definition().scenario().initialSequences()) {
            this.startSequence(sequence, false, Session.ConcurrencyPolicy.FAIL);
        }
        this.run();
        return null;
    }

    public SequenceInstance startSequence(String name, boolean forceSameIndex, Session.ConcurrencyPolicy policy) {
        return this.startSequence(this.phase.definition().scenario().sequence(name), forceSameIndex, policy);
    }

    private SequenceInstance startSequence(Sequence sequence, boolean forceSameIndex, Session.ConcurrencyPolicy policy) {
        int index = 0;
        if (forceSameIndex) {
            if (this.currentSequence == null) {
                this.fail(new IllegalStateException("Current sequence is not set!"));
            } else if (sequence.concurrency() != this.currentSequence.definition().concurrency()) {
                this.fail(new IllegalArgumentException("Sequence '" + sequence.name() + "' does not have the same concurrency factor (" + sequence.concurrency() + ") as the spawning sequence '" + this.currentSequence.definition().name() + "' (" + this.currentSequence.definition().concurrency() + ")"));
            }
            index = this.currentSequence.index();
        }
        SequenceInstance instance = (SequenceInstance)this.sequencePool.acquire();
        while (true) {
            if (sequence.concurrency() == 0) {
                if (index >= 1) {
                    log.error("Cannot start sequence {} as it has already started and it is not marked as concurrent", (Object)sequence.name());
                    if (sequence == this.currentSequence.definition()) {
                        log.info("Hint: maybe you intended only to restart the current sequence?");
                    }
                    this.sequencePool.release((Object)instance);
                    this.fail(new IllegalStateException("Cannot start sequence '" + sequence.name() + "' as it is not concurrent"));
                }
            } else if (index >= sequence.concurrency()) {
                if (instance != null) {
                    this.sequencePool.release((Object)instance);
                }
                if (policy == Session.ConcurrencyPolicy.WARN) {
                    log.warn("Cannot start sequence {}, exceeded maximum concurrency ({})", (Object)sequence.name(), (Object)sequence.concurrency());
                } else {
                    log.error("Cannot start sequence {}, exceeded maximum concurrency ({})", (Object)sequence.name(), (Object)sequence.concurrency());
                    this.fail(new IllegalStateException("Concurrency limit exceeded"));
                }
                return null;
            }
            if (!this.usedSequences.get(sequence.offset() + index)) break;
            if (forceSameIndex) {
                if (policy == Session.ConcurrencyPolicy.WARN) {
                    log.warn("Cannot start sequence {} with index {} as it is already executing.", (Object)sequence.name(), (Object)index);
                } else {
                    log.error("Cannot start sequence {} with index {} as it is already executing.", (Object)sequence.name(), (Object)index);
                    this.fail(new IllegalArgumentException("Cannot start sequence with forced index."));
                }
            }
            ++index;
        }
        if (instance == null) {
            log.error("Cannot instantiate sequence {}, no free instances.", (Object)sequence.name());
            this.fail(new IllegalStateException("No free sequence instances"));
        } else {
            log.trace("#{} starting sequence {}({})", (Object)this.uniqueId(), (Object)sequence.name(), (Object)index);
            this.usedSequences.set(sequence.offset() + index);
            instance.reset(sequence, index, sequence.steps(), this.releaseSequence);
            if (this.lastRunningSequence >= this.runningSequences.length - 1) {
                throw new IllegalStateException("Maximum number of scheduled sequences exceeded!");
            }
            ++this.lastRunningSequence;
            assert (this.runningSequences[this.lastRunningSequence] == null);
            this.runningSequences[this.lastRunningSequence] = instance;
        }
        return instance;
    }

    public void proceed() {
        if (!this.scheduled) {
            this.scheduled = true;
            this.executor.execute(this.runTask);
        }
    }

    public Statistics statistics(int stepId, String name) {
        return this.statistics.getOrCreate(this.phase.definition(), stepId, name, this.phase.absoluteStartTime());
    }

    public void pruneStats(Phase phase) {
        this.statistics.prune(phase);
    }

    public void reset() {
        int i;
        this.resetting = true;
        for (i = 0; i < this.allVars.size(); ++i) {
            this.allVars.get(i).unset();
        }
        for (i = 0; i < this.allResources.size(); ++i) {
            Session.Resource r = this.allResources.get(i);
            r.onSessionReset((Session)this);
        }
        assert (this.usedSequences.isEmpty());
        assert (this.sequencePool.isFull());
    }

    public void resetPhase(PhaseInstance newPhase) {
        if (this.phase == newPhase) {
            return;
        }
        assert (this.phase == null || newPhase.definition().scenario() == this.phase.definition().scenario());
        assert (this.phase == null || newPhase.definition().sharedResources.equals(this.phase.definition().sharedResources));
        assert (this.phase == null || this.phase.status().isTerminated());
        this.phase = newPhase;
    }

    public void stop() {
        for (int i = 0; i <= this.lastRunningSequence; ++i) {
            SequenceInstance sequence = this.runningSequences[i];
            sequence.decRefCnt((Session)this);
            this.runningSequences[i] = null;
        }
        this.lastRunningSequence = -1;
        this.currentSequence = null;
        if (trace) {
            log.trace("#{} Session stopped.", (Object)this.uniqueId);
        }
        if (!this.resetting) {
            this.reset();
            this.phase.notifyFinished((Session)this);
        }
        throw SessionStopException.INSTANCE;
    }

    public void fail(Throwable t) {
        log.error((Message)new FormattedMessage("#{} Failing phase {}", (Object)this.uniqueId, (Object)this.phase.definition().name), t);
        this.phase.fail(t);
        this.stop();
    }

    public boolean isActive() {
        return this.lastRunningSequence >= 0;
    }

    public Request currentRequest() {
        return this.currentRequest;
    }

    public void currentRequest(Request request) {
        this.currentRequest = request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("#").append(this.uniqueId).append(" (").append(this.phase != null ? this.phase.definition().name : null).append(") ").append(this.lastRunningSequence + 1).append(" sequences:");
        for (int i = 0; i <= this.lastRunningSequence; ++i) {
            sb.append(' ');
            this.runningSequences[i].appendTo(sb);
        }
        return sb.toString();
    }

    public void destroy() {
        for (Session.Resource resource : this.allResources) {
            resource.destroy();
        }
    }
}

