/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SequenceScopedReadAccess;
import io.hyperfoil.core.session.SessionImpl;
import java.util.Arrays;

class SequenceScopedObjectAccess
extends SequenceScopedReadAccess
implements ObjectAccess {
    SequenceScopedObjectAccess(Object key, int maxConcurrency) {
        super(key, maxConcurrency);
    }

    public Session.Var createVar(Session session, Session.Var existing) {
        SessionImpl impl = (SessionImpl)session;
        if (existing == null) {
            existing = new ObjectVar(impl);
        }
        if (!(existing instanceof ObjectVar)) {
            throw new BenchmarkDefinitionException("Variable " + String.valueOf(this.key) + " should hold an object but it is defined to hold an integer elsewhere.");
        }
        Object contents = existing.objectValue(session);
        if (contents == null) {
            ((ObjectVar)existing).set(ObjectVar.newArray(session, this.maxConcurrency));
        } else if (contents instanceof ObjectVar[]) {
            ObjectVar[] oldArray = (ObjectVar[])contents;
            if (oldArray.length < this.maxConcurrency) {
                ObjectVar[] newArray = Arrays.copyOf(oldArray, this.maxConcurrency);
                for (int i = oldArray.length; i < newArray.length; ++i) {
                    newArray[i] = new ObjectVar(impl);
                }
                ((ObjectVar)existing).set(newArray);
            }
        } else {
            throw new BenchmarkDefinitionException("Unexpected content in " + String.valueOf(this.key) + ": should hold array of ObjectVar but holds " + String.valueOf(contents));
        }
        return existing;
    }

    public void setObject(Session session, Object value) {
        ObjectVar var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof ObjectVar) {
            if (trace) {
                log.trace("#{} {}[{}] <- {}", (Object)session.uniqueId(), this.key, (Object)session.currentSequence().index(), value);
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + String.valueOf(this.key) + "[" + index + "] should contain ObjectVar but contains " + String.valueOf(o));
        }
        ((ObjectVar)o).set(value);
    }

    public Object activate(Session session) {
        Object o = this.getItem(session);
        if (o instanceof ObjectVar) {
            ObjectVar ov = (ObjectVar)o;
            if (trace) {
                log.trace("#{} activate {}[{}]", (Object)session.uniqueId(), this.key, (Object)session.currentSequence().index());
            }
            ov.set = true;
            return ov.objectValue(session);
        }
        int index = session.currentSequence().index();
        throw new IllegalStateException("Variable " + String.valueOf(this.key) + "[" + index + "] should contain ObjectVar but contains " + String.valueOf(o));
    }

    public void unset(Session session) {
        ObjectVar var = this.getVarToSet(session);
        Object o = this.getItemFromVar(session, var);
        if (o instanceof ObjectVar) {
            if (trace) {
                log.trace("#{} unset {}[{}]", (Object)session.uniqueId(), this.key, (Object)session.currentSequence().index());
            }
        } else {
            int index = session.currentSequence().index();
            throw new IllegalStateException("Variable " + String.valueOf(this.key) + "[" + index + "] should contain Session.Var(Object) but contains " + String.valueOf(o));
        }
        ((ObjectVar)o).unset();
    }
}

