/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.session;

import io.hyperfoil.api.session.GlobalData;
import io.netty.channel.EventLoop;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalDataImpl
implements GlobalData {
    private static final Logger log = LogManager.getLogger(GlobalDataImpl.class);
    private static final PoisonedQueue POISON = new PoisonedQueue();
    private final EventLoop executor;
    private final Map<String, String> publishingPhase = new HashMap<String, String>();
    private final Map<String, GlobalData.Element> published = new HashMap<String, GlobalData.Element>();
    private final Map<String, Queue<GlobalData.Element>> toPublish = new HashMap<String, Queue<GlobalData.Element>>();

    public GlobalDataImpl(EventLoop executor) {
        this.executor = executor;
    }

    public void publish(String phase, String key, GlobalData.Element element) {
        assert (this.executor.inEventLoop());
        String otherPhase = this.publishingPhase.put(key, phase);
        if (otherPhase != null && !otherPhase.equals(phase)) {
            throw new IllegalStateException("Global record for key '" + key + "' is published by phase '" + phase + "', no other phase can publish it.");
        }
        Queue queue = this.toPublish.computeIfAbsent(key, k -> new ArrayDeque());
        if (queue == POISON) {
            throw new IllegalStateException("Global record for key '" + key + "' has already been published; cannot add any more records.");
        }
        queue.add(element);
    }

    public GlobalData.Element read(String key) {
        assert (this.executor.inEventLoop());
        GlobalData.Element element = this.published.get(key);
        if (element == null) {
            throw new IllegalStateException("Cannot retrieve global record for key '" + key + "' - probably it was not published yet. Make sure the publishing phase and this phase are strictly ordered.");
        }
        return element;
    }

    public GlobalData.Element extractOne(String key) {
        GlobalData.Element next;
        Queue<GlobalData.Element> queue = this.toPublish.get(key);
        if (queue == null || queue.isEmpty()) {
            return null;
        }
        GlobalData.Element first = queue.remove();
        if (queue.isEmpty()) {
            return first;
        }
        GlobalData.Accumulator accumulator = first.newAccumulator();
        accumulator.add(first);
        while ((next = queue.poll()) != null) {
            accumulator.add(next);
        }
        this.toPublish.put(key, POISON);
        return accumulator.complete();
    }

    public void add(Map<String, GlobalData.Element> data) {
        assert (this.executor.inEventLoop());
        for (Map.Entry<String, GlobalData.Element> entry : data.entrySet()) {
            GlobalData.Element prev = this.published.put(entry.getKey(), entry.getValue());
            if (prev == null) continue;
            log.error("Global data for key {} has been overridden: previous: {}, new: {}", (Object)entry.getKey(), (Object)prev, (Object)entry.getValue());
            assert (false);
        }
    }

    private static class PoisonedQueue
    extends AbstractQueue<GlobalData.Element> {
        private PoisonedQueue() {
        }

        @Override
        public Iterator<GlobalData.Element> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean offer(GlobalData.Element element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlobalData.Element poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GlobalData.Element peek() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Collector {
        private final Map<String, GlobalData.Accumulator> accumulators = new HashMap<String, GlobalData.Accumulator>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void collect(String phase, GlobalDataImpl data) {
            assert (data.executor.inEventLoop());
            for (Map.Entry<String, String> entry : data.publishingPhase.entrySet()) {
                if (!phase.equals(entry.getValue())) continue;
                GlobalData.Element reduced = data.extractOne(entry.getKey());
                Collector collector = this;
                synchronized (collector) {
                    GlobalData.Accumulator accumulator = this.accumulators.get(entry.getKey());
                    if (accumulator == null) {
                        accumulator = reduced.newAccumulator();
                        this.accumulators.put(entry.getKey(), accumulator);
                    }
                    accumulator.add(reduced);
                }
            }
        }

        public synchronized Map<String, GlobalData.Element> extract() {
            Map<String, GlobalData.Element> newData = this.accumulators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((GlobalData.Accumulator)entry.getValue()).complete()));
            this.accumulators.clear();
            return newData;
        }
    }
}

