/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.core.parser.ParserException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionEndEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class TemplateIterator
implements Iterator<Event> {
    private final Iterator<Event> delegate;
    private final Map<String, AnchorInfo> anchors = new HashMap<String, AnchorInfo>();
    private final List<List<Event>> anchorStack = new ArrayList<List<Event>>();
    private final Map<String, Stack<String>> params;
    private final Stack<Integer> depthStack = new Stack();
    private final Stack<Iterator<Event>> replaying = new Stack();
    private int depth;

    public TemplateIterator(Iterator<Event> delegate, Map<String, String> params) {
        this.delegate = delegate;
        this.params = params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Stack<String> stack = new Stack<String>();
            stack.push((String)entry.getValue());
            return stack;
        }));
    }

    @Override
    public boolean hasNext() {
        while (!this.replaying.isEmpty()) {
            Iterator<Event> iterator = this.replaying.peek();
            if (iterator.hasNext()) {
                return true;
            }
            this.replaying.pop();
        }
        return this.delegate.hasNext();
    }

    @Override
    public Event next() {
        Event event = this.nextRawEvent();
        String tag = null;
        if (event instanceof ScalarEvent) {
            tag = ((ScalarEvent)event).getTag();
        } else if (event instanceof CollectionStartEvent) {
            tag = ((CollectionStartEvent)event).getTag();
        }
        if (tag != null) {
            switch (tag.toLowerCase(Locale.ENGLISH)) {
                case "!param": {
                    return this.paramEvent(event);
                }
                case "!concat": {
                    return this.concatEvent(event);
                }
                case "!foreach": {
                    return this.forEachEvent(event);
                }
            }
        }
        return event;
    }

    private Event nextRawEvent() {
        Event event = this.nextEventFromStacks();
        if (event instanceof NodeEvent) {
            NodeEvent nodeEvent = (NodeEvent)event;
            if (nodeEvent instanceof AliasEvent) {
                AnchorInfo anchorInfo = this.anchors.get(nodeEvent.getAnchor());
                if (anchorInfo == null) {
                    throw new RuntimeException(new ParserException((Event)nodeEvent, "No anchor for alias '" + nodeEvent.getAnchor() + "'"));
                }
                Iterator<Event> iterator = anchorInfo.events.iterator();
                this.replaying.push(iterator);
                assert (iterator.hasNext());
                event = iterator.next();
            } else if (nodeEvent.getAnchor() != null) {
                ArrayList<Event> newReplayList = new ArrayList<Event>();
                AnchorInfo prev = this.anchors.put(nodeEvent.getAnchor(), new AnchorInfo(nodeEvent, newReplayList));
                if (prev != null) {
                    throw new RuntimeException(new ParserException((Event)nodeEvent, "Anchor '" + nodeEvent.getAnchor() + "' was already defined before on line " + (prev.anchorEvent.getStartMark().getLine() + 1)));
                }
                if (nodeEvent instanceof CollectionStartEvent) {
                    this.anchorStack.add(newReplayList);
                    this.depthStack.push(this.depth);
                    if (nodeEvent instanceof MappingStartEvent) {
                        MappingStartEvent mse = (MappingStartEvent)nodeEvent;
                        event = new MappingStartEvent(null, mse.getTag(), mse.getImplicit(), mse.getStartMark(), mse.getEndMark(), mse.getFlowStyle());
                    } else if (nodeEvent instanceof SequenceStartEvent) {
                        SequenceStartEvent sse = (SequenceStartEvent)nodeEvent;
                        event = new SequenceStartEvent(null, sse.getTag(), sse.getImplicit(), sse.getStartMark(), sse.getEndMark(), sse.getFlowStyle());
                    }
                } else {
                    ScalarEvent se = (ScalarEvent)nodeEvent;
                    event = new ScalarEvent(null, se.getTag(), se.getImplicit(), se.getValue(), se.getStartMark(), se.getEndMark(), se.getScalarStyle());
                    newReplayList.add(event);
                }
            }
            if (event instanceof CollectionStartEvent) {
                ++this.depth;
            }
        }
        for (List<Event> list : this.anchorStack) {
            list.add(event);
        }
        if (event instanceof CollectionEndEvent) {
            --this.depth;
            if (!this.depthStack.isEmpty() && this.depth == this.depthStack.peek()) {
                this.depthStack.pop();
                this.anchorStack.remove(this.anchorStack.size() - 1);
            }
        }
        return event;
    }

    private Event nextEventFromStacks() {
        while (!this.replaying.isEmpty()) {
            Iterator<Event> iterator = this.replaying.peek();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            this.replaying.pop();
        }
        return this.delegate.next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Event paramEvent(Event event) {
        String paramValue;
        if (!(event instanceof ScalarEvent)) throw new RuntimeException(new ParserException(event, "Parameter in template assumes scalar - example: 'foo: !param FOO optional default"));
        ScalarEvent scalar = (ScalarEvent)event;
        String value = scalar.getValue();
        if (value.isEmpty()) {
            throw new RuntimeException(new ParserException(event, "Cannot use !param with empty value!"));
        }
        String[] parts = value.split(" +", 2);
        Stack<String> paramStack = this.params.get(parts[0]);
        if (paramStack == null || paramStack.isEmpty()) {
            if (parts.length <= 1) throw new RuntimeException(new ParserException(event, "Cannot replace parameter '" + parts[0] + "': not defined and no default value"));
            String defaultValue = parts[1];
            if (defaultValue.startsWith("\"") && defaultValue.endsWith("\"") || defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            paramValue = defaultValue;
            return new ScalarEvent(null, null, scalar.getImplicit(), paramValue, scalar.getStartMark(), scalar.getEndMark(), scalar.getScalarStyle());
        } else {
            paramValue = paramStack.peek();
        }
        return new ScalarEvent(null, null, scalar.getImplicit(), paramValue, scalar.getStartMark(), scalar.getEndMark(), scalar.getScalarStyle());
    }

    private Event concatEvent(Event event) {
        if (event instanceof SequenceStartEvent) {
            Event itemEvent;
            StringBuilder sb = new StringBuilder();
            while (this.hasNext() && !((itemEvent = this.next()) instanceof SequenceEndEvent)) {
                if (itemEvent instanceof ScalarEvent) {
                    sb.append(((ScalarEvent)itemEvent).getValue());
                    continue;
                }
                throw new RuntimeException(new ParserException(itemEvent, "Concatenation expects only scalar events in the list."));
            }
            return new ScalarEvent(null, null, new ImplicitTuple(true, true), sb.toString(), event.getStartMark(), event.getEndMark(), DumperOptions.ScalarStyle.PLAIN);
        }
        throw new RuntimeException(new ParserException(event, "Concatenation expects a sequence - example: 'foo: !concat [ \"http://\", !param SERVER ]'"));
    }

    private Event forEachEvent(Event event) {
        String scalarItems = null;
        List<String> items = null;
        String separator = null;
        String param = null;
        ArrayList<Event> rawEvents = null;
        if (event instanceof MappingStartEvent) {
            Event mappingEvent = null;
            block12: while (this.hasNext() && !((mappingEvent = this.next()) instanceof MappingEndEvent)) {
                if (mappingEvent instanceof ScalarEvent) {
                    String property;
                    switch (property = ((ScalarEvent)mappingEvent).getValue()) {
                        case "items": {
                            if (scalarItems != null || items != null) {
                                throw new RuntimeException(new ParserException(mappingEvent, "ForEach.items set twice?"));
                            }
                            Event itemsEvent = this.next();
                            if (itemsEvent instanceof ScalarEvent) {
                                scalarItems = ((ScalarEvent)itemsEvent).getValue();
                                break;
                            }
                            if (itemsEvent instanceof SequenceStartEvent) {
                                Event itemEvent;
                                items = new ArrayList<String>();
                                while (this.hasNext() && !((itemEvent = this.next()) instanceof SequenceEndEvent)) {
                                    if (itemEvent instanceof ScalarEvent) {
                                        items.add(((ScalarEvent)itemEvent).getValue());
                                        continue;
                                    }
                                    throw new RuntimeException(new ParserException(itemsEvent, "ForEach.items as a sequence must only contain scalars!"));
                                }
                                continue block12;
                            }
                            throw new RuntimeException(new ParserException(itemsEvent, "ForEach.items must be scalar or sequence!"));
                        }
                        case "separator": {
                            if (separator != null) {
                                throw new RuntimeException(new ParserException(mappingEvent, "Separator set twice?"));
                            }
                            Event separatorEvent = this.next();
                            if (separatorEvent instanceof ScalarEvent) {
                                separator = ((ScalarEvent)separatorEvent).getValue();
                                break;
                            }
                            throw new RuntimeException(new ParserException(separatorEvent, "ForEach.separator must be scalar!"));
                        }
                        case "param": {
                            if (param != null) {
                                throw new RuntimeException(new ParserException(mappingEvent, "Param set twice?"));
                            }
                            Event paramEvent = this.next();
                            if (paramEvent instanceof ScalarEvent) {
                                param = ((ScalarEvent)paramEvent).getValue();
                                break;
                            }
                            throw new RuntimeException(new ParserException(paramEvent, "ForEach.param must be scalar!"));
                        }
                        case "do": {
                            int depth = 0;
                            rawEvents = new ArrayList<Event>();
                            do {
                                Event raw = this.nextRawEvent();
                                rawEvents.add(raw);
                                if (raw instanceof CollectionStartEvent) {
                                    ++depth;
                                    continue;
                                }
                                if (!(raw instanceof CollectionEndEvent)) continue;
                                --depth;
                            } while (depth > 0);
                            break;
                        }
                        default: {
                            throw new RuntimeException(new ParserException(mappingEvent, "Unknown ForEach property: '" + property + "', valid options are 'items', 'param', 'separator' and 'do'"));
                        }
                    }
                    continue;
                }
                throw new RuntimeException(new ParserException(mappingEvent, "ForEach expect scalar property names"));
            }
            if (separator == null) {
                separator = ",";
            }
            if (param == null) {
                param = "ITEM";
            }
            if (items == null) {
                if (scalarItems != null) {
                    items = Stream.of(scalarItems.split(separator)).map(String::trim).collect(Collectors.toList());
                    ListIterator it = items.listIterator(items.size());
                    while (it.hasPrevious()) {
                        if (!((String)it.previous()).isEmpty()) continue;
                        it.remove();
                    }
                } else {
                    throw new RuntimeException(new ParserException("ForEach.items must be defined (set to empty string if you want an empty list)"));
                }
            }
            if (rawEvents == null) {
                throw new RuntimeException(new ParserException("ForEach.do must be defined: that's what you want repeat."));
            }
            this.replaying.push(new ForeachIterator(this, items, rawEvents, param, new SequenceEndEvent(mappingEvent.getStartMark(), mappingEvent.getEndMark())));
            return new SequenceStartEvent(null, null, true, event.getStartMark(), event.getEndMark(), DumperOptions.FlowStyle.BLOCK);
        }
        throw new RuntimeException(new ParserException(event, "ForEach expects a mapping with 'items', 'do' and optional 'param' and 'separator' properties."));
    }

    private static class AnchorInfo {
        final NodeEvent anchorEvent;
        final List<Event> events;

        private AnchorInfo(NodeEvent anchorEvent, List<Event> events) {
            this.anchorEvent = anchorEvent;
            this.events = events;
        }
    }

    private class ForeachIterator
    implements Iterator<Event> {
        private final Iterator<String> itemsIterator;
        private final List<Event> events;
        private final SequenceEndEvent endEvent;
        private final Stack<String> paramStack;
        private Iterator<Event> currentEventsIterator;
        private boolean started = false;
        private boolean atEnd = false;

        ForeachIterator(TemplateIterator templateIterator, List<String> items, List<Event> events, String param, SequenceEndEvent endEvent) {
            this.itemsIterator = items.iterator();
            this.events = events;
            this.endEvent = endEvent;
            this.paramStack = templateIterator.params.computeIfAbsent(param, p -> new Stack());
            this.advanceCurrentIterator();
        }

        private void advanceCurrentIterator() {
            if (this.itemsIterator.hasNext()) {
                if (this.started) {
                    this.paramStack.pop();
                } else {
                    this.started = true;
                }
                this.paramStack.push(this.itemsIterator.next());
                this.currentEventsIterator = this.events.iterator();
            } else if (!this.atEnd) {
                if (this.started) {
                    this.paramStack.pop();
                }
                this.currentEventsIterator = Collections.singletonList(this.endEvent).iterator();
                this.atEnd = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.currentEventsIterator.hasNext()) {
                return this.itemsIterator.hasNext() || !this.atEnd;
            }
            return true;
        }

        @Override
        public Event next() {
            if (!this.currentEventsIterator.hasNext()) {
                this.advanceCurrentIterator();
            }
            return this.currentEventsIterator.next();
        }
    }
}

