/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.PhaseReferenceDelay;
import io.hyperfoil.api.config.RelativeIteration;
import io.hyperfoil.core.parser.AbstractMappingParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.impl.Util;
import java.util.function.BiConsumer;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class StartWithParser
implements Parser<PhaseBuilder<?>> {
    private final BiConsumer<PhaseBuilder<?>, PhaseReferenceDelay> consumer;

    StartWithParser(BiConsumer<PhaseBuilder<?>, PhaseReferenceDelay> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void parse(Context ctx, PhaseBuilder<?> target) throws ParserException {
        if (!ctx.hasNext()) {
            throw ctx.noMoreEvents(ScalarEvent.class, SequenceStartEvent.class, MappingStartEvent.class);
        }
        Event event = ctx.peek();
        if (event instanceof ScalarEvent) {
            this.consumer.accept(target, new PhaseReferenceDelay(((ScalarEvent)event).getValue(), RelativeIteration.NONE, null, 0L));
            ctx.consumePeeked(event);
        } else if (event instanceof MappingStartEvent) {
            StartWithBuilder swb = new StartWithBuilder();
            MappingParser.INSTANCE.parse(ctx, swb);
            if (swb.phase == null || swb.phase.isEmpty()) {
                throw new BenchmarkDefinitionException("Missing name in phase reference.");
            }
            this.consumer.accept(target, new PhaseReferenceDelay(swb.phase, swb.iteration, swb.fork, swb.delay));
        } else {
            throw ctx.unexpectedEvent(event);
        }
    }

    private static class StartWithBuilder {
        String phase;
        RelativeIteration iteration = RelativeIteration.NONE;
        String fork;
        long delay;

        private StartWithBuilder() {
        }
    }

    private static class MappingParser
    extends AbstractMappingParser<StartWithBuilder> {
        static MappingParser INSTANCE = new MappingParser();

        MappingParser() {
            this.register("phase", new PropertyParser.String<StartWithBuilder>((b, value) -> {
                b.phase = value;
            }));
            this.register("iteration", new PropertyParser.String<StartWithBuilder>((b, value) -> {
                b.iteration = RelativeIteration.valueOf((String)value.toUpperCase());
            }));
            this.register("fork", new PropertyParser.String<StartWithBuilder>((b, value) -> {
                b.fork = value;
            }));
            this.register("delay", new PropertyParser.String<StartWithBuilder>((b, value) -> {
                b.delay = Util.parseToMillis((String)value);
            }));
        }
    }
}

